/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.VarType;
import com.caucho.inject.Module;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class ParamType
extends BaseType
implements ParameterizedType {
    private Class<?> _type;
    private BaseType[] _param;
    private Type[] _actualArguments;
    private HashMap<String, BaseType> _paramMap;

    public ParamType(Class<?> type, BaseType[] param, HashMap<String, BaseType> paramMap) {
        this._type = type;
        this._param = param;
        this._paramMap = paramMap;
        this._actualArguments = new Type[param.length];
        for (int i = 0; i < param.length; ++i) {
            this._actualArguments[i] = param[i].toType();
        }
    }

    @Override
    public Class<?> getRawClass() {
        return this._type;
    }

    @Override
    public Type toType() {
        return this;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this._actualArguments;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    @Override
    public BaseType[] getParameters() {
        return this._param;
    }

    @Override
    public boolean isGeneric() {
        for (BaseType type : this._param) {
            if (!type.isGeneric()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGenericVariable() {
        for (BaseType type : this._param) {
            if (!type.isVariable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public HashMap<String, BaseType> getParamMap() {
        return this._paramMap;
    }

    @Override
    public Type getRawType() {
        return this._type;
    }

    @Override
    protected void fillTypeClosure(InjectManager manager, Set<Type> typeSet) {
        typeSet.add(this.toType());
        for (Type type : this._type.getGenericInterfaces()) {
            BaseType ifaceType = ParamType.createForSource(type, this._paramMap, null);
            ifaceType.fillTypeClosure(manager, typeSet);
        }
        Type superclass = this._type.getGenericSuperclass();
        if (superclass == null) {
            return;
        }
        BaseType superType = ParamType.createForSource(superclass, this._paramMap, null);
        superType.fillTypeClosure(manager, typeSet);
    }

    @Override
    public BaseType fill(BaseType ... types) {
        TypeVariable<Class<?>>[] vars = this._type.getTypeParameters();
        if (vars.length != types.length) {
            throw new IllegalStateException();
        }
        HashMap<String, BaseType> paramMap = new HashMap<String, BaseType>(this._paramMap);
        for (int i = 0; i < vars.length; ++i) {
            TypeVariable<Class<?>> var = vars[i];
            paramMap.put(var.getName(), types[i]);
        }
        return new ParamType(this._type, types, paramMap);
    }

    @Override
    public void fillSyntheticTypes(Set<VarType<?>> varTypeList) {
        for (BaseType param : this._param) {
            param.fillSyntheticTypes(varTypeList);
        }
    }

    @Override
    public boolean isAssignableFrom(BaseType type) {
        BaseType[] paramB;
        if (!this.getRawClass().isAssignableFrom(type.getRawClass())) {
            return false;
        }
        if (!this.getRawClass().equals(type.getRawClass())) {
            return false;
        }
        BaseType[] paramA = this.getParameters();
        if (paramA.length != (paramB = type.getParameters()).length) {
            return false;
        }
        for (int i = 0; i < paramA.length; ++i) {
            if (paramA[i].isParamAssignableFrom(paramB[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isParamAssignableFrom(BaseType type) {
        BaseType[] paramB;
        if (!(type instanceof ParamType)) {
            return false;
        }
        ParamType pType = (ParamType)type;
        Type rawType = pType.getRawType();
        if (!this._type.equals(rawType)) {
            return false;
        }
        BaseType[] paramA = this.getParameters();
        if (paramA.length != (paramB = type.getParameters()).length) {
            return false;
        }
        for (int i = 0; i < paramA.length; ++i) {
            if (paramA[i].isParamAssignableFrom(paramB[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this._type.hashCode() ^ Arrays.hashCode(this._param);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParamType)) {
            return false;
        }
        ParamType type = (ParamType)o;
        if (!this._type.equals(type._type)) {
            return false;
        }
        if (this._param.length != type._param.length) {
            return false;
        }
        for (int i = 0; i < this._param.length; ++i) {
            if (this._param[i].equals(type._param[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getSimpleName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRawClass().getSimpleName());
        sb.append("<");
        for (int i = 0; i < this._param.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this._param[i].getSimpleName());
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRawClass().toString());
        sb.append("<");
        for (int i = 0; i < this._param.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this._param[i]);
        }
        sb.append(">");
        return sb.toString();
    }
}

