/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.type.ConfigType;
import com.caucho.config.types.InterfaceConfig;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceType<T>
extends ConfigType<T> {
    private static final L10N L = new L10N(InterfaceType.class);
    private final Class<T> _type;

    public InterfaceType(Class<T> type) {
        this._type = type;
    }

    @Override
    public Class<T> getType() {
        return this._type;
    }

    @Override
    public Object create(Object parent, QName name) {
        InterfaceConfig cfg = new InterfaceConfig(this._type, this._type.getSimpleName());
        return cfg;
    }

    @Override
    public void init(Object bean) {
        if (bean instanceof InterfaceConfig) {
            ((InterfaceConfig)bean).init();
        } else {
            super.init(bean);
        }
    }

    @Override
    public Object replaceObject(Object bean) {
        if (bean instanceof InterfaceConfig) {
            return ((InterfaceConfig)bean).replaceObject();
        }
        return bean;
    }

    @Override
    public Object valueOf(String text) {
        if (text == null) {
            return null;
        }
        InjectManager beanManager = InjectManager.create();
        Set<Bean<Object>> beans = !text.equals("") ? beanManager.getBeans(this._type, Names.create(text)) : beanManager.getBeans(this._type, new Annotation[0]);
        if (beans.iterator().hasNext()) {
            Bean bean = beanManager.resolve(beans);
            CreationalContext env = beanManager.createCreationalContext(bean);
            Object value = beanManager.getReference(bean, this._type, env);
            return value;
        }
        Object value = Jndi.lookup(text);
        if (value != null) {
            return value;
        }
        throw new ConfigException(L.l("{0}: '{1}' is an unknown bean.", (Object)this._type.getName(), (Object)text));
    }

    @Override
    public Object valueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (this._type.isAssignableFrom(value.getClass())) {
            return value;
        }
        throw new ConfigException(L.l("{0}: '{1}' is an invalid value.", (Object)this._type.getName(), value));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type.getName() + "]";
    }
}

