/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.core.ResinChoose;
import com.caucho.config.core.ResinIf;
import com.caucho.config.core.ResinImport;
import com.caucho.config.core.ResinLog;
import com.caucho.config.core.ResinProperties;
import com.caucho.config.core.ResinSet;
import com.caucho.config.core.ResinSystemConfig;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.NamespaceBeanConfig;
import com.caucho.config.type.NamespaceFlowConfig;
import com.caucho.config.type.TypeFactory;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamespaceConfig {
    static final NamespaceConfig NS_RESIN = new NamespaceConfig("http://caucho.com/ns/resin", true);
    static final NamespaceConfig NS_DEFAULT;
    static final NamespaceConfig NS_RESIN_CORE;
    static final NamespaceConfig URN_RESIN;
    private TypeFactory _factory;
    private String _ns = "";
    private boolean _isDefault;
    private Path _path;
    private HashMap<String, NamespaceBeanConfig> _beanMap = new HashMap();

    private NamespaceConfig(String ns, boolean isDefault) {
        this._factory = TypeFactory.getFactory(this.getClass().getClassLoader());
        this._isDefault = isDefault;
        this.setName(ns);
    }

    private void setName(String ns) {
        if ("default".equals(ns)) {
            ns = "";
        }
        this._ns = ns;
    }

    public String getName() {
        return this._ns;
    }

    public void setDefault(boolean isDefault) {
        this._isDefault = isDefault;
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public void setPath(String path) {
        this._path = path.indexOf(58) < 0 ? Vfs.lookup("classpath:" + path) : Vfs.lookup(path);
    }

    public Path getPath() {
        return this._path;
    }

    public ConfigType<?> getBean(String name) {
        NamespaceBeanConfig beanConfig = this._beanMap.get(name);
        if (beanConfig != null) {
            return beanConfig.getConfigType();
        }
        return null;
    }

    public NamespaceBeanConfig createBean() {
        return new NamespaceBeanConfig(this._factory, this._ns, this._isDefault);
    }

    public void addBean(NamespaceBeanConfig bean) {
        this._beanMap.put(bean.getName(), bean);
    }

    public NamespaceFlowConfig createFlow() {
        return new NamespaceFlowConfig(this._factory, this._ns, this._isDefault);
    }

    public void addFlow(NamespaceFlowConfig flow) {
        this._beanMap.put(flow.getName(), flow);
    }

    private void addFlow(String name, Class<?> cl) {
        this.addFlow(name, cl.getName());
    }

    private void addFlow(String name, String className) {
        NamespaceFlowConfig bean = this.createFlow();
        bean.setName(name);
        bean.setClass(className);
        this.addFlow(bean);
    }

    private void addBean(String name, Class<?> cl) {
        this.addBean(name, cl.getName());
    }

    private void addBean(String name, String className) {
        NamespaceBeanConfig bean = this.createBean();
        bean.setName(name);
        bean.setClass(className);
        this.addBean(bean);
    }

    private void initCore() {
        this.addFlow("choose", ResinChoose.class);
        this.addFlow("if", ResinIf.class);
        this.addFlow("properties", ResinProperties.class);
        this.addBean("import", ResinImport.class);
        this.addBean("log", ResinLog.class);
        this.addBean("message", ResinLog.class);
        this.addBean("set", ResinSet.class);
        this.addBean("system", ResinSystemConfig.class);
        this.addBean("value", "com.caucho.config.type.ValueType");
    }

    private void initResin() {
        this.addBean("authenticator", "com.caucho.security.Authenticator");
        this.addBean("bam-service", "com.caucho.hemp.broker.BamServiceConfig");
        this.addBean("bean", "com.caucho.config.cfg.BeanConfig");
        this.addBean("case-insensitive", "com.caucho.vfs.CaseInsensitive");
        this.addBean("character-encoding", "com.caucho.i18n.CharacterEncoding");
        this.addBean("choose", "com.caucho.config.core.ResinChoose");
        this.addBean("class-loader", "com.caucho.loader.ClassLoaderConfig");
        this.addBean("classpath", "com.caucho.loader.ClasspathConfig");
        this.addBean("class-update-interval", "com.caucho.loader.DependencyCheckInterval");
        this.addBean("component", "com.caucho.config.cfg.WbComponentConfig");
        this.addBean("connection-factory", "com.caucho.jca.cfg.ConnectionFactoryConfig");
        this.addBean("connector", "com.caucho.jca.ra.ConnectorConfig");
        this.addBean("database", "com.caucho.sql.DBPool");
        this.addBean("database-default", "com.caucho.sql.DatabaseConfig");
        this.addBean("data-source", "com.caucho.config.types.DataSourceRef");
        this.addBean("dependency", "com.caucho.make.DependencyConfig");
        this.addBean("dependency-check-interval", "com.caucho.loader.DependencyCheckInterval");
        this.addBean("ejb-local-ref", "com.caucho.config.types.EjbLocalRef");
        this.addBean("ejb-message-bean", "com.caucho.ejb.cfg.MessageBeanConfig");
        this.addBean("ejb-ref", "com.caucho.config.types.EjbRef");
        this.addBean("ejb-server", "com.caucho.ejb.EJBServer");
        this.addBean("ejb-stateless-bean", "com.caucho.ejb.cfg.StatelessBeanConfig");
        this.addBean("ejb-stateful-bean", "com.caucho.ejb.cfg.StatefulBeanConfig");
        this.addBean("env-entry", "com.caucho.config.types.EnvEntry");
        this.addBean("if", "com.caucho.config.core.ResinIf");
        this.addBean("import", "com.caucho.config.core.ResinImport");
        this.addBean("include", "com.caucho.config.core.ResinInclude");
        this.addBean("interceptor", "com.caucho.config.cfg.InterceptorConfig");
        this.addBean("java", "com.caucho.java.JavacConfig");
        this.addBean("javac", "com.caucho.java.JavacConfig");
        this.addBean("jndi-link", "com.caucho.naming.LinkProxy");
        this.addBean("jms-connection-factory", "com.caucho.jms.cfg.JmsConnectionFactoryConfig");
        this.addBean("jms-queue", "com.caucho.jms.cfg.JmsQueueConfig");
        this.addBean("jms-topic", "com.caucho.jms.cfg.JmsTopicConfig");
        this.addBean("jpa-persistence", "com.caucho.amber.cfg.PersistenceManager");
        this.addBean("jpa-persistence-unit", "com.caucho.env.jpa.ConfigJpaPersistenceUnit");
        this.addBean("jpa-persistence-unit-default", "com.caucho.env.jpa.ConfigJpaPersistenceUnitDefault");
        this.addBean("list", "com.caucho.config.type.ListType");
        this.addBean("log", "com.caucho.log.LogConfig");
        this.addBean("log-handler", "com.caucho.log.LogHandlerConfig");
        this.addBean("logger", "com.caucho.log.LoggerConfig");
        this.addBean("mail", "com.caucho.jca.cfg.JavaMailConfig");
        this.addBean("map", "com.caucho.config.type.MapType");
        this.addBean("mbean", "com.caucho.jmx.MBeanConfig");
        this.addBean("message", "com.caucho.config.core.ResinLog");
        this.addBean("message-destination-ref", "com.caucho.config.types.MessageDestinationRef");
        this.addBean("null", "com.caucho.config.type.NullType");
        this.addBean("persistent-store", "com.caucho.server.distcache.PersistentStoreConfig");
        this.addBean("persistence-manager", "com.caucho.amber.cfg.PersistenceManager");
        this.addBean("persistence-unit-ref", "com.caucho.config.types.PersistenceUnitRef");
        this.addBean("rar-deploy", "com.caucho.jca.ra.ResourceDeploy");
        this.addBean("reference", "com.caucho.config.types.ReferenceConfig");
        this.addBean("remote-client", "com.caucho.remote.client.RemoteClient");
        this.addBean("resource", "com.caucho.jca.cfg.Resource");
        this.addBean("resource-adapter", "com.caucho.jca.cfg.ResourceAdapterBeanConfig");
        this.addBean("resource-default", "com.caucho.jca.ra.ResourceDefault");
        this.addBean("resource-deploy", "com.caucho.jca.ra.ResourceDeploy");
        this.addBean("resource-env-ref", "com.caucho.config.types.ResourceEnvRef");
        this.addBean("resource-manager", "com.caucho.jca.ra.ResourceManagerConfig");
        this.addBean("resource-ref", "com.caucho.jca.ra.ResourceRef");
        this.addBean("role-map", "com.caucho.security.RoleMap");
        this.addBean("scheduled-task", "com.caucho.resources.ScheduledTaskConfig");
        this.addBean("security-role-ref", "com.caucho.config.types.SecurityRoleRef");
        this.addBean("servlet-classloader-hack", "com.caucho.loader.ServletClassloaderHack");
        this.addBean("set", "com.caucho.config.core.ResinSet");
        this.addBean("stderr-log", "com.caucho.log.StderrLog");
        this.addBean("stdout-log", "com.caucho.log.StdoutLog");
        this.addBean("system-property", "com.caucho.loader.SystemProperty");
        this.addBean("temp-dir", "com.caucho.java.TempDir");
        this.addBean("temporary-directory", "com.caucho.java.TempDir");
        this.addBean("value", "com.caucho.config.type.ValueType");
        this.addBean("web-service-client", "com.caucho.remote.client.RemoteClient");
        this.addBean("work-dir", "com.caucho.java.WorkDir");
        this.addBean("work-directory", "com.caucho.java.WorkDir");
    }

    static {
        NS_RESIN.initResin();
        NS_RESIN_CORE = new NamespaceConfig("http://caucho.com/ns/resin/core", false);
        NS_RESIN_CORE.initCore();
        NS_DEFAULT = new NamespaceConfig("", true);
        NS_DEFAULT.initCore();
        NS_DEFAULT.initResin();
        URN_RESIN = new NamespaceConfig("urn:java:com.caucho.resin", false);
        URN_RESIN.initCore();
    }
}

