/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.xml;

import com.caucho.config.ConfigException;
import com.caucho.config.ConfiguredLiteral;
import com.caucho.config.cfg.BeansConfig;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.Arg;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.NodeBuilderChildProgram;
import com.caucho.config.reflect.AnnotatedElementImpl;
import com.caucho.config.reflect.AnnotatedMethodImpl;
import com.caucho.config.reflect.AnnotatedTypeImpl;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.xml.XmlBean;
import com.caucho.config.xml.XmlBeanFieldConfig;
import com.caucho.config.xml.XmlBeanMethodConfig;
import com.caucho.config.xml.XmlConfigContext;
import com.caucho.config.xml.XmlCookie;
import com.caucho.config.xml.XmlInjectionTarget;
import com.caucho.config.xml.XmlManagedBeanImpl;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeanConfig<T> {
    private static final L10N L = new L10N(XmlBeanConfig.class);
    private static final String RESIN_NS = "http://caucho.com/ns/resin";
    private InjectManager _cdiManager;
    private Class<T> _class;
    private AnnotatedTypeImpl<T> _annotatedType;
    private Bean<T> _bean;
    private ConfigType<T> _configType;
    private ArrayList<ConfigProgram> _args;
    private QName _name;
    private String _filename;
    private int _line;
    private ContainerProgram _init;
    private boolean _hasBindings;
    private boolean _hasInterceptorBindings;
    private boolean _isInlineBean;
    private boolean _isBeansXml;

    public XmlBeanConfig(QName name, Class<T> cl, Object parent) {
        this._name = name;
        this._class = cl;
        this._cdiManager = InjectManager.create();
        BaseType baseType = this._cdiManager.createSourceBaseType(cl);
        ReflectionAnnotatedType annType = ReflectionAnnotatedFactory.introspectType(baseType);
        this._annotatedType = new AnnotatedTypeImpl(annType);
        this._cdiManager.addConfiguredBean(cl.getName());
        this._configType = TypeFactory.getCustomBeanType(cl);
        this._annotatedType.addAnnotation(ConfiguredLiteral.create());
        for (AnnotatedMethod<T> method : this._annotatedType.getMethods()) {
            AnnotatedMethodImpl methodImpl = (AnnotatedMethodImpl)method;
            if (!methodImpl.isAnnotationPresent(Produces.class)) continue;
            methodImpl.addAnnotation(ConfiguredLiteral.create());
        }
        if (parent instanceof BeansConfig) {
            this._isBeansXml = true;
        }
    }

    public ConfigType<T> getConfigType() {
        return this._configType;
    }

    public Class<T> getClassType() {
        return this._class;
    }

    public void setConfigLocation(String filename, int line) {
        this._filename = filename;
        this._line = line;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    public void setInlineBean(boolean isInline) {
        this._isInlineBean = isInline;
    }

    public void setBeansXml(boolean isBeansXml) {
        this._isBeansXml = isBeansXml;
    }

    public void addArg(ConfigProgram arg) {
        if (this._args == null) {
            this._args = new ArrayList();
        }
        this._args.add(arg);
    }

    public void addArgs(ArrayList<ConfigProgram> args) {
        this._args = new ArrayList<ConfigProgram>(args);
    }

    public void addAdd(ConfigProgram add) {
        this.addInitProgram(add);
    }

    public void addInitProgram(ConfigProgram program) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(program);
    }

    public void addBuilderProgram(ConfigProgram program) {
        QName name = program.getQName();
        if (name == null) {
            this.addInitProgram(program);
            return;
        }
        Class<?> cl = this.createClass(name);
        if (cl != null && Annotation.class.isAssignableFrom(cl)) {
            ConfigType<?> type = TypeFactory.getType(cl);
            Object bean = type.create(null, name);
            Node node = this.getProgramNode(program);
            if (node != null) {
                XmlConfigContext.getCurrent().configureNode(node, bean, type);
            }
            Annotation ann = (Annotation)type.replaceObject(bean);
            this.addAnnotation(ann);
            return;
        }
        if (name.getNamespaceURI().equals(this._name.getNamespaceURI())) {
            if (this._configType.getAttribute(name) == null) {
                throw new ConfigException(L.l("'{0}' is an unknown field for '{1}'", (Object)name.getLocalName(), (Object)this._class.getName()));
            }
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown field name.  Fields must belong to the same namespace as the class", (Object)name.getCanonicalName()));
        }
        this.addInitProgram(program);
    }

    private Node getProgramNode(ConfigProgram program) {
        if (program instanceof NodeBuilderChildProgram) {
            return ((NodeBuilderChildProgram)program).getNode();
        }
        return null;
    }

    public void addAnnotation(Annotation ann) {
        if (ann.annotationType().isAnnotationPresent(Qualifier.class) && !this._hasBindings) {
            this._hasBindings = true;
            this.clearBindings(this._annotatedType);
        }
        if (ann.annotationType().isAnnotationPresent(InterceptorBinding.class) && !this._hasInterceptorBindings) {
            this._hasInterceptorBindings = true;
            this.clearAnnotations(this._annotatedType, InterceptorBinding.class);
        }
        if (ann.annotationType().isAnnotationPresent(Scope.class) || ann.annotationType().isAnnotationPresent(NormalScope.class)) {
            this.clearAnnotations(this._annotatedType, Scope.class);
            this.clearAnnotations(this._annotatedType, NormalScope.class);
        }
        this._annotatedType.addAnnotation(ann);
    }

    public void addMethod(XmlBeanMethodConfig methodConfig) {
        Method method = methodConfig.getMethod();
        Annotation[] annList = methodConfig.getAnnotations();
        AnnotatedMethod<T> annMethod = this._annotatedType.createMethod(method);
        if (annMethod instanceof AnnotatedMethodImpl) {
            AnnotatedMethodImpl methodImpl = (AnnotatedMethodImpl)annMethod;
            methodImpl.clearAnnotations();
            this.addAnnotations(methodImpl, annList);
        }
    }

    private void addAnnotations(AnnotatedElementImpl annotated, Annotation[] annList) {
        for (Annotation ann : annList) {
            annotated.addAnnotation(ann);
        }
    }

    public void addField(XmlBeanFieldConfig fieldConfig) {
    }

    private void clearBindings(AnnotatedTypeImpl<?> beanType) {
        HashSet<Annotation> annSet = new HashSet<Annotation>(beanType.getAnnotations());
        for (Annotation ann : annSet) {
            if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            beanType.removeAnnotation(ann);
        }
    }

    private void clearAnnotations(AnnotatedTypeImpl<?> beanType, Class<? extends Annotation> annType) {
        HashSet<Annotation> annSet = new HashSet<Annotation>(beanType.getAnnotations());
        for (Annotation ann : annSet) {
            if (!ann.annotationType().isAnnotationPresent(annType)) continue;
            beanType.removeAnnotation(ann);
        }
    }

    private Class<?> createClass(QName name) {
        String uri = name.getNamespaceURI();
        String localName = name.getLocalName();
        if (uri.equals(RESIN_NS)) {
            return this.createResinClass(localName);
        }
        if (!uri.startsWith("urn:java:")) {
            return null;
        }
        String pkg = uri.substring("urn:java:".length());
        return TypeFactory.loadClass(pkg, name.getLocalName());
    }

    private Class<?> createResinClass(String name) {
        Class<?> cl = TypeFactory.loadClass("ee", name);
        if (cl != null) {
            return cl;
        }
        cl = TypeFactory.loadClass("com.caucho.config", name);
        if (cl != null) {
            return cl;
        }
        return null;
    }

    @PostConstruct
    public void init() {
        if (this._annotatedType != null) {
            this.initComponent();
        }
    }

    public void initComponent() {
        ConfigProgram[] injectProgram;
        Arg[] newProgram = null;
        Constructor javaCtor = null;
        if (this._args != null) {
            AnnotatedConstructor<T> ctor = null;
            for (AnnotatedConstructor<T> testCtor : this._annotatedType.getConstructors()) {
                if (testCtor.getParameters().size() != this._args.size()) continue;
                ctor = testCtor;
            }
            if (ctor == null) {
                throw new ConfigException(L.l("No matching constructor found for '{0}' with {1} arguments.", (Object)this._annotatedType, this._args.size()));
            }
            javaCtor = ctor.getJavaMember();
            ArrayList<ConfigProgram> newList = this._args;
            newProgram = new Arg[newList.size()];
            Type[] genericParam = javaCtor.getGenericParameterTypes();
            List parameters = ctor.getParameters();
            String loc = null;
            for (int i = 0; i < this._args.size(); ++i) {
                ConfigProgram argProgram = this._args.get(i);
                ConfigType<?> type = TypeFactory.getType(genericParam[i]);
                newProgram[i] = argProgram != null ? new ProgramArg(type, argProgram) : new BeanArg(loc, genericParam[i], parameters.get(i).getAnnotations());
            }
        } else {
            newProgram = new Arg[]{};
        }
        if (this._init != null) {
            ArrayList<ConfigProgram> programList = this._init.getProgramList();
            injectProgram = new ConfigProgram[programList.size()];
            programList.toArray(injectProgram);
        } else {
            injectProgram = new ConfigProgram[]{};
        }
        XmlCookie xmlCookie = this._cdiManager.generateXmlCookie();
        this._annotatedType.addAnnotation(xmlCookie);
        XmlManagedBeanImpl<T> managedBean = new XmlManagedBeanImpl<T>(this._cdiManager, this._annotatedType, false, this._name, this._filename, this._line);
        managedBean.introspect();
        XmlInjectionTarget<T> injectionTarget = new XmlInjectionTarget<T>(managedBean, javaCtor, newProgram, injectProgram);
        this._bean = new XmlBean<T>(managedBean, injectionTarget);
        this._cdiManager.addXmlInjectionTarget(xmlCookie.value(), injectionTarget);
        if (!this._isInlineBean) {
            this._cdiManager.discoverBean(this._annotatedType);
            if (!this._isBeansXml) {
                this._cdiManager.update();
            }
        }
    }

    protected Bean bindParameter(String loc, Type type, Set<Annotation> bindingSet) {
        Annotation[] bindings = new Annotation[bindingSet.size()];
        bindingSet.toArray(bindings);
        Set set = this._cdiManager.getBeans(type, bindings);
        if (set == null || set.size() == 0) {
            return null;
        }
        return this._cdiManager.resolve(set);
    }

    public Object toObject() {
        if (this._bean == null) {
            this.init();
        }
        InjectManager beanManager = InjectManager.create();
        CreationalContext<T> env = beanManager.createCreationalContext(this._bean);
        Class<?> type = this._bean.getBeanClass();
        return InjectManager.create().getReference(this._bean, type, env);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._class.getSimpleName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProgramArg<T>
    extends Arg<T> {
        private ConfigType<T> _type;
        private ConfigProgram _program;

        ProgramArg(ConfigType<T> type, ConfigProgram program) {
            this._type = type;
            this._program = program;
        }

        @Override
        public Object eval(CreationalContext<T> creationalContext) {
            return this._program.create(this._type, creationalContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BeanArg
    extends Arg<T> {
        private String _loc;
        private Constructor<T> _ctor;
        private Type _type;
        private Set<Annotation> _bindings;
        private Bean<T> _bean;

        BeanArg(String loc, Type type, Set<Annotation> bindings) {
            this._loc = loc;
            this._type = type;
            this._bindings = bindings;
            this.bind();
        }

        @Override
        public void bind() {
            if (this._bean == null) {
                this._bean = XmlBeanConfig.this.bindParameter(this._loc, this._type, this._bindings);
                if (this._bean == null) {
                    throw new ConfigException(L.l("{0}: {1} does not have valid arguments", (Object)this._loc, (Object)this._ctor));
                }
            }
        }

        @Override
        public Object eval(CreationalContext<T> env) {
            if (this._bean == null) {
                this.bind();
            }
            Type type = null;
            return XmlBeanConfig.this._cdiManager.getReference(this._bean, type, env);
        }
    }
}

