/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.blob;

import com.caucho.db.blob.BlobInputStream;
import com.caucho.db.blob.BlobOutputStream;
import com.caucho.db.blob.ClobReader;
import com.caucho.db.blob.ClobWriter;
import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.db.xa.RawTransaction;
import com.caucho.db.xa.StoreTransaction;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.TempCharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Inode {
    private static final L10N L = new L10N(Inode.class);
    private static final Logger log = Logger.getLogger(Inode.class.getName());
    public static final int INODE_SIZE = 128;
    public static final int INLINE_BLOB_SIZE = 120;
    public static final int BLOCK_SIZE = 8192;
    public static final int MINI_FRAG_SIZE = 256;
    public static final int MINI_FRAG_BLOB_SIZE = 3840;
    public static final int INDIRECT_BLOCKS = 1024;
    public static final int DIRECT_BLOCKS = 14;
    public static final int SINGLE_INDIRECT_BLOCKS = 512;
    public static final int DOUBLE_INDIRECT_BLOCKS = 256;
    public static final int TRIPLE_INDIRECT_BLOCKS = 256;
    public static final long INLINE_MAX = 120L;
    public static final int MINI_FRAG_MAX = 3840;
    public static final long DIRECT_MAX = 114688L;
    public static final long SINGLE_INDIRECT_MAX = 4308992L;
    public static final long DOUBLE_INDIRECT_MAX = 2151792640L;
    private static final FreeList<byte[]> _freeBytes = new FreeList(16);
    private BlockStore _store;
    private final byte[] _bytes = new byte[128];

    public Inode() {
    }

    public Inode(BlockStore store, StoreTransaction xa) {
        this._store = store;
    }

    public Inode(BlockStore store) {
        this(store, RawTransaction.create());
    }

    public BlockStore getStore() {
        return this._store;
    }

    public byte[] getBuffer() {
        return this._bytes;
    }

    public long getLength() {
        return Inode.readLong(this._bytes, 0);
    }

    public void init(BlockStore store, StoreTransaction xa, byte[] buffer, int offset) {
        this._store = store;
        System.arraycopy(buffer, offset, this._bytes, 0, this._bytes.length);
    }

    public InputStream openInputStream() {
        return new BlobInputStream(this);
    }

    public void writeToStream(OutputStreamWithBuffer os) throws IOException {
        this.writeToStream(os, 0L, 0x3FFFFFFFFFFFFFFFL);
    }

    public void writeToStreamOld(OutputStreamWithBuffer os, long offset, long length) throws IOException {
        byte[] buffer = os.getBuffer();
        int writeLength = buffer.length;
        int writeOffset = os.getBufferOffset();
        while (length > 0L) {
            int len;
            int sublen = writeLength - writeOffset;
            if (sublen == 0) {
                buffer = os.nextBuffer(writeOffset);
                writeOffset = os.getBufferOffset();
                sublen = writeLength - writeOffset;
            }
            if (length < (long)sublen) {
                sublen = (int)length;
            }
            if ((len = Inode.read(this._bytes, 0, this._store, offset, buffer, writeOffset, sublen)) <= 0) break;
            writeOffset += len;
            offset += (long)len;
            length -= (long)len;
        }
        os.setBufferOffset(writeOffset);
    }

    public void writeToStream(OutputStream os, long offset, long length) throws IOException {
        int sublen;
        int len;
        while (length > 0L && (len = Inode.readToOutput(this._bytes, 0, this._store, offset, sublen = (int)length, os)) > 0) {
            offset += (long)len;
            length -= (long)len;
        }
    }

    public static int writeToStream(byte[] inode, int inodeOffset, BlockStore store, OutputStream os, long offset, long length) throws IOException {
        int readLength = 0;
        while (length > 0L) {
            int sublen = (int)length;
            int len = Inode.readToOutput(inode, inodeOffset, store, offset, sublen, os);
            if (len <= 0) {
                return readLength;
            }
            offset += (long)len;
            length -= (long)len;
            readLength += len;
        }
        return readLength;
    }

    public void writeToWriter(Writer writer) throws IOException {
        int sublen;
        int len;
        TempCharBuffer tempBuffer = TempCharBuffer.allocate();
        char[] buffer = tempBuffer.getBuffer();
        int writeLength = buffer.length;
        long offset = 0L;
        while ((len = Inode.read(this._bytes, 0, this._store, offset, buffer, 0, sublen = writeLength)) > 0) {
            writer.write(buffer, 0, len);
            offset += (long)(2 * len);
        }
        TempCharBuffer.free(tempBuffer);
    }

    static int read(byte[] inode, int inodeOffset, BlockStore store, long fileOffset, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int sublen;
        long fileLength = Inode.readLong(inode, inodeOffset);
        if (fileLength - fileOffset < (long)(sublen = bufferLength)) {
            sublen = (int)(fileLength - fileOffset);
        }
        if (sublen <= 0) {
            return -1;
        }
        if (fileLength <= 120L) {
            System.arraycopy(inode, inodeOffset + 8 + (int)fileOffset, buffer, bufferOffset, sublen);
            return sublen;
        }
        if (fileLength <= 3840L) {
            long fragAddr = Inode.readMiniFragAddr(inode, inodeOffset, store, fileOffset);
            int fragOffset = (int)(fileOffset % 256L);
            if (256 - fragOffset < sublen) {
                sublen = 256 - fragOffset;
            }
            store.readMiniFragment(fragAddr, fragOffset, buffer, bufferOffset, sublen);
            return sublen;
        }
        long addr = Inode.readBlockAddr(inode, inodeOffset, store, fileOffset);
        int offset = (int)(fileOffset % 8192L);
        if (8192 - offset < sublen) {
            sublen = 8192 - offset;
        }
        store.readBlock(addr, offset, buffer, bufferOffset, sublen);
        return sublen;
    }

    static int readToOutput(byte[] inode, int inodeOffset, BlockStore store, long fileOffset, int sublen, OutputStream os) throws IOException {
        long fileLength = Inode.readLong(inode, inodeOffset);
        if (fileLength - fileOffset < (long)sublen) {
            sublen = (int)(fileLength - fileOffset);
        }
        if (sublen <= 0) {
            return -1;
        }
        if (fileLength <= 120L) {
            os.write(inode, inodeOffset + 8 + (int)fileOffset, sublen);
            return sublen;
        }
        if (fileLength <= 3840L) {
            long fragAddr = Inode.readMiniFragAddr(inode, inodeOffset, store, fileOffset);
            int fragOffset = (int)(fileOffset % 256L);
            if (256 - fragOffset < sublen) {
                sublen = 256 - fragOffset;
            }
            store.readMiniFragmentNoLock(fragAddr, fragOffset, sublen, os);
            return sublen;
        }
        long addr = Inode.readBlockAddr(inode, inodeOffset, store, fileOffset);
        int offset = (int)(fileOffset % 8192L);
        if (8192 - offset < sublen) {
            sublen = 8192 - offset;
        }
        store.readBlockNoLock(addr, offset, os, sublen);
        return sublen;
    }

    static void append(byte[] inode, int inodeOffset, BlockStore store, StoreTransaction xa, byte[] buffer, int offset, int length) throws IOException {
        long currentLength = Inode.readLong(inode, inodeOffset);
        long newLength = currentLength + (long)length;
        Inode.writeLong(inode, inodeOffset, newLength);
        if (newLength <= 120L) {
            assert (currentLength == 0L);
            System.arraycopy(buffer, offset, inode, (int)((long)(inodeOffset + 8) + currentLength), length);
        } else if (newLength <= 3840L) {
            assert (currentLength == 0L);
            while (length > 0) {
                long miniFragAddr;
                int sublen = length;
                if (256 < sublen) {
                    sublen = 256;
                }
                if ((miniFragAddr = store.allocateMiniFragment()) == 0L) {
                    Inode.corrupted(store, L.l("{0} illegal mini fragment", (Object)store));
                }
                Inode.writeMiniFragAddr(inode, inodeOffset, store, xa, currentLength, miniFragAddr);
                Block writeBlock = store.writeMiniFragment(miniFragAddr, 0, buffer, offset, sublen);
                xa.addUpdateBlock(writeBlock);
                offset += sublen;
                length -= sublen;
                currentLength += (long)sublen;
            }
        } else {
            if (currentLength > 0L && currentLength < 3840L) {
                throw new IllegalStateException(L.l("illegal length transition {0} to {1} because mini-fragmentation must be decided initially.", (Object)currentLength, (Object)newLength));
            }
            Inode.appendBlock(inode, inodeOffset, store, xa, buffer, offset, length, currentLength);
        }
    }

    private static void appendBlock(byte[] inode, int inodeOffset, BlockStore store, StoreTransaction xa, byte[] buffer, int offset, int length, long currentLength) throws IOException {
        while (length > 0) {
            if (currentLength % 8192L != 0L) {
                int sublen;
                int blockOffset;
                long addr = Inode.readBlockAddr(inode, inodeOffset, store, currentLength);
                if (addr == 0L) {
                    Inode.corrupted(store, L.l("{0}: inode: illegal block at {1}", (Object)store, (Object)currentLength));
                }
                if (8192 - (blockOffset = (int)(currentLength % 8192L)) < (sublen = length)) {
                    sublen = 8192 - blockOffset;
                }
                Block block = store.writeBlock(addr, blockOffset, buffer, offset, sublen);
                xa.addUpdateBlock(block);
                offset += sublen;
                length -= sublen;
                currentLength += (long)sublen;
                continue;
            }
            int sublen = length;
            if (8192 < sublen) {
                sublen = 8192;
            }
            Block block = store.allocateBlock();
            long blockAddr = BlockStore.blockIdToAddress(block.getBlockId());
            block.free();
            if (blockAddr == 0L) {
                Inode.corrupted(store, L.l("{0}: illegal block", (Object)store));
            }
            Inode.writeBlockAddr(inode, inodeOffset, store, xa, currentLength, blockAddr);
            Block writeBlock = store.writeBlock(blockAddr, 0, buffer, offset, sublen);
            xa.addUpdateBlock(writeBlock);
            offset += sublen;
            length -= sublen;
            currentLength += (long)sublen;
        }
    }

    static int read(byte[] inode, int inodeOffset, BlockStore store, long fileOffset, char[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long fileLength = Inode.readLong(inode, inodeOffset);
        int charSublen = (int)(fileLength - fileOffset) / 2;
        if (bufferLength < charSublen) {
            charSublen = bufferLength;
        }
        if (charSublen <= 0) {
            return -1;
        }
        if (fileLength <= 120L) {
            int baseOffset = inodeOffset + 8 + (int)fileOffset;
            for (int i = 0; i < charSublen; ++i) {
                char ch;
                buffer[bufferOffset + i] = ch = (char)(((inode[baseOffset] & 0xFF) << 8) + (inode[baseOffset + 1] & 0xFF));
                baseOffset += 2;
            }
            return charSublen;
        }
        if (fileLength <= 3840L) {
            long fragAddr = Inode.readMiniFragAddr(inode, inodeOffset, store, fileOffset);
            int fragOffset = (int)(fileOffset % 256L);
            if (256 - fragOffset < 2 * charSublen) {
                charSublen = (256 - fragOffset) / 2;
            }
            store.readMiniFragment(fragAddr, fragOffset, buffer, bufferOffset, charSublen);
            return charSublen;
        }
        long addr = Inode.readBlockAddr(inode, inodeOffset, store, fileOffset);
        int offset = (int)(fileOffset % 8192L);
        if (8192 - offset < 2 * charSublen) {
            charSublen = (8192 - offset) / 2;
        }
        store.readBlock(addr, offset, buffer, bufferOffset, charSublen);
        return charSublen;
    }

    static void append(byte[] inode, int inodeOffset, BlockStore store, StoreTransaction xa, char[] buffer, int offset, int charLength) throws IOException {
        long currentLength = Inode.readLong(inode, inodeOffset);
        long newLength = currentLength + (long)(2 * charLength);
        Inode.writeLong(inode, inodeOffset, newLength);
        if (newLength <= 120L) {
            assert (currentLength == 0L);
            int writeOffset = (int)((long)(inodeOffset + 8) + currentLength);
            for (int i = 0; i < charLength; ++i) {
                char ch = buffer[offset + i];
                inode[writeOffset++] = (byte)(ch >> 8);
                inode[writeOffset++] = (byte)ch;
            }
        } else if (newLength <= 3840L) {
            assert (currentLength == 0L);
            while (charLength > 0) {
                long miniFragAddr;
                int sublen = 2 * charLength;
                if (256 < sublen) {
                    sublen = 256;
                }
                if ((miniFragAddr = store.allocateMiniFragment()) == 0L) {
                    Inode.corrupted(store, L.l("{0} illegal mini fragment", (Object)store));
                }
                Inode.writeMiniFragAddr(inode, inodeOffset, store, xa, currentLength, miniFragAddr);
                int charSublen = sublen / 2;
                Block writeBlock = store.writeMiniFragment(miniFragAddr, 0, buffer, offset, charSublen);
                xa.addUpdateBlock(writeBlock);
                offset += charSublen;
                charLength -= charSublen;
                currentLength += (long)sublen;
            }
        } else {
            if (currentLength > 0L && currentLength < 3840L) {
                throw new IllegalStateException(L.l("illegal length transition {0} to {1} because mini-fragmentation must be decided initially.", (Object)currentLength, (Object)newLength));
            }
            Inode.appendBlock(inode, inodeOffset, store, xa, buffer, offset, charLength, currentLength);
        }
    }

    static void appendBlock(byte[] inode, int inodeOffset, BlockStore store, StoreTransaction xa, char[] buffer, int offset, int charLength, long currentLength) throws IOException {
        while (charLength > 0) {
            Block writeBlock;
            if (currentLength % 8192L != 0L) {
                int sublen;
                int blockOffset;
                long addr = Inode.readBlockAddr(inode, inodeOffset, store, currentLength);
                if (addr == 0L) {
                    Inode.corrupted(store, store + " inode: illegal block at " + currentLength);
                }
                if (8192 - (blockOffset = (int)(currentLength % 8192L)) < (sublen = 2 * charLength)) {
                    sublen = 8192 - blockOffset;
                }
                int charSublen = sublen / 2;
                writeBlock = store.writeBlock(addr, blockOffset, buffer, offset, charSublen);
                xa.addUpdateBlock(writeBlock);
                offset += charSublen;
                charLength -= charSublen;
                currentLength += (long)sublen;
                continue;
            }
            int sublen = 2 * charLength;
            if (8192 < sublen) {
                sublen = 8192;
            }
            int charSublen = sublen / 2;
            Block block = store.allocateBlock();
            long blockAddr = BlockStore.blockIdToAddress(block.getBlockId());
            block.free();
            writeBlock = store.writeBlock(blockAddr, 0, buffer, offset, charSublen);
            xa.addUpdateBlock(writeBlock);
            Inode.writeBlockAddr(inode, inodeOffset, store, xa, currentLength, blockAddr);
            offset += charSublen;
            charLength -= charSublen;
            currentLength += (long)sublen;
        }
    }

    public OutputStream openOutputStream() {
        return new BlobOutputStream(this);
    }

    void closeOutputStream() {
        try {
            this._store.saveAllocation();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public Reader openReader() {
        return new ClobReader(this);
    }

    public Writer openWriter() {
        return new ClobWriter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        block22: {
            byte[] bytes = _freeBytes.allocate();
            if (bytes == null) {
                bytes = new byte[128];
            }
            for (int i = 0; i < 128; ++i) {
                bytes[i] = this._bytes[i];
                this._bytes[i] = 0;
            }
            try {
                long length;
                if (length <= 120L || bytes == null) {
                    return;
                }
                if (length <= 3840L) {
                    for (length = Inode.readLong(bytes, 0); length > 0L; length -= 256L) {
                        String msg;
                        long fragAddr = Inode.readMiniFragAddr(bytes, 0, this._store, length - 1L);
                        if ((fragAddr & 0xFFFFFFFFFFFFE000L) == 0L) {
                            msg = this._store + ": inode block " + Long.toHexString(length) + " has 0 fragment";
                            Inode.corrupted(this._store, msg);
                        } else if (fragAddr < 0L) {
                            msg = this._store + ": inode block " + Long.toHexString(length) + " has invalid fragment " + Long.toHexString(fragAddr);
                            Inode.corrupted(this._store, msg);
                        }
                        this._store.deleteMiniFragment(fragAddr);
                    }
                    break block22;
                }
                long indAddr = Inode.readLong(bytes, 120);
                if (114688L < length && !this.validateBlockAddr(indAddr, length, 3)) {
                    return;
                }
                while (length > 0L) {
                    block23: {
                        int blockCount;
                        block24: {
                            blockCount = (int)((length - 1L) / 8192L);
                            long blockAddr = Inode.readBlockAddr(bytes, 0, this._store, length - 1L);
                            if (!this.validateBlockAddr(blockAddr, length, 2)) break block23;
                            this._store.deallocateBlock(blockAddr);
                            int dblBlockCount = blockCount - 14 - 512;
                            if (dblBlockCount < 0 || dblBlockCount % 1024 != 0) break block24;
                            int dblIndex = 8 * (dblBlockCount / 1024 + 512);
                            blockAddr = this._store.readBlockLong(indAddr, dblIndex);
                            if (!this.validateBlockAddr(blockAddr, length, 3)) break block23;
                            this._store.deallocateBlock(blockAddr);
                        }
                        if (blockCount == 14) {
                            this._store.deallocateBlock(indAddr);
                        }
                    }
                    length -= 8192L;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                _freeBytes.free(bytes);
            }
        }
    }

    private boolean validateBlockAddr(long blockAddr, long length, int allocCode) {
        if ((blockAddr & 0x1FFFL) != 0L) {
            String msg = this._store + ": inode block len=" + Long.toHexString(length) + " has non-zero offset 0x" + Long.toHexString(blockAddr);
            log.warning(msg);
            Inode.corrupted(this._store, msg);
            return false;
        }
        if (blockAddr < 0L) {
            String msg = this._store + ": inode block " + Long.toHexString(length) + " has invalid block " + Long.toHexString(blockAddr);
            log.warning(msg);
            Inode.corrupted(this._store, msg);
            return false;
        }
        if (this._store.getAllocationByAddress(blockAddr) != allocCode) {
            String msg = this._store + ": inode block " + Long.toHexString(length) + " has invalid block code (" + this._store.getAllocationByAddress(blockAddr) + ")" + " expected (" + allocCode + ")";
            log.warning(msg);
            Inode.corrupted(this._store, msg);
            return false;
        }
        return true;
    }

    public static boolean isValid(BlockStore store, byte[] bytes, int offset) {
        try {
            long length;
            if (length < 0L || length > 2151792640L) {
                String msg = store + ": inode invalid length " + length;
                log.warning(msg);
                return false;
            }
            if (length <= 120L || bytes == null) {
                return true;
            }
            if (length <= 3840L) {
                for (length = Inode.readLong(bytes, offset); length > 0L; length -= 256L) {
                    long fragAddr = Inode.readMiniFragAddr(bytes, offset, store, length - 1L);
                    if ((fragAddr & 0xFFFFFFFFFFFFE000L) == 0L) {
                        String msg = store + ": inode block " + Long.toHexString(length) + " has 0 fragment";
                        log.warning(msg);
                        return false;
                    }
                    if (fragAddr >= 0L) continue;
                    String msg = store + ": inode block " + Long.toHexString(length) + " has invalid fragment " + Long.toHexString(fragAddr);
                    log.warning(msg);
                    return false;
                }
            } else {
                long indAddr = Inode.readLong(bytes, offset + 120);
                if (114688L < length && !Inode.isValidBlockAddr(store, indAddr, length, 3)) {
                    return false;
                }
                while (length > 0L) {
                    int dblIndex;
                    int blockCount = (int)((length - 1L) / 8192L);
                    long blockAddr = Inode.readBlockAddr(bytes, offset, store, length - 1L);
                    if (!Inode.isValidBlockAddr(store, blockAddr, length, 2)) {
                        return false;
                    }
                    int dblBlockCount = blockCount - 14 - 512;
                    if (dblBlockCount >= 0 && dblBlockCount % 1024 == 0 && !Inode.isValidBlockAddr(store, blockAddr = store.readBlockLong(indAddr, dblIndex = 8 * (dblBlockCount / 1024 + 512)), length, 3)) {
                        return false;
                    }
                    length -= 8192L;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return true;
    }

    private static boolean isValidBlockAddr(BlockStore store, long blockAddr, long length, int allocCode) {
        if ((blockAddr & 0x1FFFL) != 0L) {
            String msg = store + ": inode block " + Long.toHexString(length) + " has non-zero offset 0x" + Long.toHexString(blockAddr);
            log.warning(msg);
            return false;
        }
        if (blockAddr < 8192L) {
            String msg = store + ": inode block " + Long.toHexString(length) + " has invalid block " + Long.toHexString(blockAddr);
            log.warning(msg);
            return false;
        }
        if (store.getAllocationByAddress(blockAddr) != allocCode) {
            String msg = store + ": inode block " + Long.toHexString(length) + " has invalid block code (" + store.getAllocationByAddress(blockAddr) + ")" + " expected (" + allocCode + ")";
            log.warning(msg);
            return false;
        }
        return true;
    }

    static void clear(byte[] inode, int inodeOffset) {
        int end = inodeOffset + 128;
        while (inodeOffset < end) {
            inode[inodeOffset] = 0;
            ++inodeOffset;
        }
    }

    static long readMiniFragAddr(byte[] inode, int inodeOffset, BlockStore store, long fileOffset) throws IOException {
        long fragCount = fileOffset / 256L;
        return Inode.readLong(inode, (int)((long)(inodeOffset + 8) + 8L * fragCount));
    }

    private static void writeMiniFragAddr(byte[] inode, int offset, BlockStore store, StoreTransaction xa, long fragLength, long fragAddr) throws IOException {
        int fragCount = (int)(fragLength / 256L);
        if ((fragAddr & 0xFFFFFFFFFFFFE000L) == 0L) {
            Inode.corrupted(store, store + ": inode block " + fragLength + " has zero value " + fragAddr);
        }
        Inode.writeLong(inode, offset + (fragCount + 1) * 8, fragAddr);
    }

    static long readBlockAddr(byte[] inode, int inodeOffset, BlockStore store, long fileOffset) throws IOException {
        int blockCount = (int)(fileOffset / 8192L);
        if (fileOffset < 114688L) {
            return Inode.readLong(inode, inodeOffset + (blockCount + 1) * 8);
        }
        long indAddr = Inode.readLong(inode, inodeOffset + 120);
        if (indAddr == 0L) {
            Inode.corrupted(store, L.l("{0} null block id", (Object)store));
        }
        if (!store.isInodePtrBlock(indAddr)) {
            Inode.corrupted(store, L.l("corrupted indirect block id"));
        }
        if (fileOffset < 4308992L) {
            int blockOffset = 8 * (blockCount - 14);
            long blockAddr = store.readBlockLong(indAddr, blockOffset);
            return blockAddr;
        }
        if (fileOffset < 2151792640L) {
            int dblBlockCount = (blockCount = blockCount - 14 - 512) / 1024;
            int dblBlockIndex = 8 * (512 + dblBlockCount);
            long dblIndAddr = store.readBlockLong(indAddr, dblBlockIndex);
            if (dblIndAddr == 0L) {
                Inode.corrupted(store, L.l("null indirect block id"));
            }
            if (!store.isInodePtrBlock(dblIndAddr)) {
                Inode.corrupted(store, L.l("corrupted dbl-indirect block id"));
            }
            int blockOffset = 8 * (blockCount % 1024);
            return store.readBlockLong(dblIndAddr, blockOffset);
        }
        throw Inode.corrupted(store, L.l("{0} size over {1}M not supported", (Object)store, (Object)2052L));
    }

    private static void writeBlockAddr(byte[] inode, int inodeOffset, BlockStore store, StoreTransaction xa, long fileOffset, long blockAddr) throws IOException {
        int blockCount = (int)(fileOffset / 8192L);
        if ((blockAddr & 0xFFFFFFFFFFFFE000L) == 0L) {
            String msg = store + ": inode block " + blockCount + " writing 0 fragment";
            Inode.corrupted(store, msg);
        }
        if (fileOffset < 114688L) {
            Inode.writeLong(inode, inodeOffset + 8 * (blockCount + 1), blockAddr);
        } else if (fileOffset < 4308992L) {
            long indAddr = Inode.readLong(inode, inodeOffset + 120);
            if (indAddr == 0L) {
                Block block = store.allocateIndirectBlock();
                indAddr = BlockStore.blockIdToAddress(block.getBlockId());
                block.free();
                Inode.writeLong(inode, inodeOffset + 120, indAddr);
            }
            int blockOffset = 8 * (blockCount - 14);
            Block writeBlock = store.writeBlockLong(indAddr, blockOffset, blockAddr);
            xa.addUpdateBlock(writeBlock);
        } else if (fileOffset < 2151792640L) {
            Block writeBlock;
            int dblBlockCount;
            int dblBlockIndex;
            long dblIndAddr;
            long indAddr = Inode.readLong(inode, inodeOffset + 120);
            if (indAddr == 0L) {
                Inode.corrupted(store, L.l("{0} null block id", (Object)store));
            }
            if ((dblIndAddr = store.readBlockLong(indAddr, dblBlockIndex = 8 * (512 + (dblBlockCount = (blockCount = blockCount - 14 - 512) / 1024)))) == 0L) {
                Block block = store.allocateIndirectBlock();
                dblIndAddr = BlockStore.blockIdToAddress(block.getBlockId());
                block.free();
                writeBlock = store.writeBlockLong(indAddr, dblBlockIndex, dblIndAddr);
                xa.addUpdateBlock(writeBlock);
            }
            int blockOffset = 8 * (blockCount % 1024);
            writeBlock = store.writeBlockLong(dblIndAddr, blockOffset, blockAddr);
            xa.addUpdateBlock(writeBlock);
        } else {
            Inode.corrupted(store, L.l("{0} size over {1}M not supported", (Object)store, (Object)2052L));
        }
    }

    private static RuntimeException corrupted(BlockStore store, String msg) {
        store.fatalCorrupted(msg);
        IllegalStateException e = new IllegalStateException(msg);
        e.fillInStackTrace();
        log.log(Level.WARNING, e.toString(), e);
        throw e;
    }

    public static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    public static void writeLong(byte[] buffer, int offset, long v) {
        buffer[offset + 0] = (byte)(v >> 56);
        buffer[offset + 1] = (byte)(v >> 48);
        buffer[offset + 2] = (byte)(v >> 40);
        buffer[offset + 3] = (byte)(v >> 32);
        buffer[offset + 4] = (byte)(v >> 24);
        buffer[offset + 5] = (byte)(v >> 16);
        buffer[offset + 6] = (byte)(v >> 8);
        buffer[offset + 7] = (byte)v;
    }
}

