/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.Database;
import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.db.jdbc.CursorResultSetImpl;
import com.caucho.db.jdbc.PreparedStatementImpl;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectCursor;
import com.caucho.db.xa.DbTransaction;
import com.caucho.util.L10N;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CursorPreparedStatementImpl
extends PreparedStatementImpl
implements PreparedStatement {
    private static final L10N L = new L10N(CursorPreparedStatementImpl.class);

    CursorPreparedStatementImpl(ConnectionImpl conn, Query query) {
        super(conn, query);
    }

    public boolean execute() throws SQLException {
        Database db = this.getDatabase();
        if (db == null) {
            throw new SQLException(L.l("statement is closed"));
        }
        this.setResultSet(this.executeQuery(this.getQuery(), this.getQueryContext()));
        return true;
    }

    private ResultSet executeQuery(Query query, QueryContext queryContext) throws SQLException {
        DbTransaction xa = this.getConnectionImpl().getTransaction();
        queryContext.setNonLocking();
        SelectCursor result = query.executeCursor(queryContext, xa);
        return new CursorResultSetImpl(this, queryContext, result);
    }
}

