/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.DoubleOrder;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.IntOrder;
import com.caucho.db.sql.LongOrder;
import com.caucho.db.sql.Order;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.sql.StringOrder;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.SQLExceptionWrapper;
import java.io.InputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public abstract class Expr {
    protected static final L10N L = new L10N(Expr.class);
    public static final int UNKNOWN = -1;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    static final long COST_INVALID = 9223372036854775L;
    static final long COST_NO_TABLE = Integer.MAX_VALUE;
    static final long COST_SCAN = 1000000L;
    static final long COST_UNIQUE = 10000L;
    static final long COST_INDEX = 100L;
    static final long COST_CONSTANT = 0L;
    static final long INDEX_COST_INDEX = 100000000L;
    private static QDate _gmtDate = new QDate();

    public Expr bind(Query query) throws SQLException {
        return this;
    }

    public Class<?> getType() {
        return Object.class;
    }

    public Column.ColumnType getTypeCode() {
        return Column.ColumnType.NONE;
    }

    public int getSQLType() {
        return this.getTypeCode().getSQLType();
    }

    public boolean isLong() {
        Class<?> type = this.getType();
        return Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Date.class.equals(type);
    }

    public boolean isDouble() {
        Class<?> type = this.getType();
        return this.isLong() || Double.TYPE.isAssignableFrom(type);
    }

    public boolean isBoolean() {
        return Boolean.TYPE.equals(this.getType());
    }

    public boolean isBinaryStream(QueryContext context) {
        Class<?> type = this.getType();
        return InputStream.class.equals(type);
    }

    public boolean isParam() {
        return false;
    }

    public boolean isNullable() {
        return true;
    }

    public String getName() {
        return "";
    }

    public Table getTable() {
        return null;
    }

    public void splitAnd(ArrayList<Expr> andProduct) {
        andProduct.add(this);
    }

    public long cost(ArrayList<FromItem> fromList) {
        return this.subCost(fromList);
    }

    public long subCost(ArrayList<FromItem> fromList) {
        return 9223372036854775L;
    }

    public long indexCost(ArrayList<FromItem> costItems) {
        return this.indexSubCost(costItems);
    }

    public long indexSubCost(ArrayList<FromItem> costItems) {
        return 9223372036854775L;
    }

    public RowIterateExpr getIndexExpr(FromItem fromItem) {
        return null;
    }

    public Order createOrder(int index) {
        if (Integer.TYPE.equals(this.getType())) {
            return new IntOrder(index);
        }
        if (this.isLong()) {
            return new LongOrder(index);
        }
        if (this.isDouble()) {
            return new DoubleOrder(index);
        }
        return new StringOrder(index);
    }

    public boolean isNull(QueryContext context) throws SQLException {
        return false;
    }

    public boolean isSelect(QueryContext context) throws SQLException {
        return this.evalBoolean(context) == 1;
    }

    public int evalBoolean(QueryContext context) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String evalString(QueryContext context) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void updateString(QueryContext context, String value) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long evalLong(QueryContext context) throws SQLException {
        String strValue = this.evalString(context);
        if (strValue == null) {
            return 0L;
        }
        return Long.parseLong(strValue);
    }

    public void updateLong(QueryContext context, long value) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public double evalDouble(QueryContext context) throws SQLException {
        String strValue = this.evalString(context);
        if (strValue == null) {
            return 0.0;
        }
        return Double.parseDouble(strValue);
    }

    public void updateDouble(QueryContext context, double value) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long evalDate(QueryContext context) throws SQLException {
        String dateString = this.evalString(context);
        try {
            QDate qDate = _gmtDate;
            synchronized (qDate) {
                return _gmtDate.parseDate(dateString);
            }
        }
        catch (Exception e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    public void evalToResult(QueryContext context, SelectResult result) throws SQLException {
        String s = this.evalString(context);
        if (s == null) {
            result.writeNull();
            return;
        }
        result.writeString(s);
    }

    public InputStream evalStream(QueryContext context) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public byte[] evalBytes(QueryContext context) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int evalToBuffer(QueryContext context, byte[] buffer, int offset) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int evalToBuffer(QueryContext context, byte[] buffer, int off, Column.ColumnType columnType) throws SQLException {
        switch (columnType) {
            case INT: {
                int v = (int)this.evalLong(context);
                buffer[0] = (byte)(v >> 24);
                buffer[1] = (byte)(v >> 16);
                buffer[2] = (byte)(v >> 8);
                buffer[3] = (byte)v;
                return 4;
            }
            case LONG: 
            case DATE: {
                long v = this.evalLong(context);
                buffer[0] = (byte)(v >> 56);
                buffer[1] = (byte)(v >> 48);
                buffer[2] = (byte)(v >> 40);
                buffer[3] = (byte)(v >> 32);
                buffer[4] = (byte)(v >> 24);
                buffer[5] = (byte)(v >> 16);
                buffer[6] = (byte)(v >> 8);
                buffer[7] = (byte)v;
                return 8;
            }
            case VARCHAR: {
                String v = this.evalString(context);
                if (v == null) {
                    return -1;
                }
                int length = v.length();
                int offset = 0;
                buffer[offset++] = (byte)length;
                for (int i = 0; i < length; ++i) {
                    char ch = v.charAt(i);
                    buffer[offset++] = (byte)(ch >> 8);
                    buffer[offset++] = (byte)ch;
                }
                return offset;
            }
            case VARBINARY: {
                String v = this.evalString(context);
                if (v == null) {
                    return -1;
                }
                int length = v.length();
                int offset = 1;
                for (int i = 0; i < length; ++i) {
                    char ch = v.charAt(i);
                    if (ch < '\u0080') {
                        buffer[offset++] = (byte)(ch & 0xFF);
                        continue;
                    }
                    if (ch < '\u0800') {
                        buffer[offset++] = (byte)(192 + (ch >> 6 & 0x1F));
                        buffer[offset++] = (byte)(128 + (ch & 0x3F));
                        continue;
                    }
                    buffer[offset++] = (byte)(224 + (ch >> 12 & 0xF));
                    buffer[offset++] = (byte)(128 + (ch >> 6 & 0x3F));
                    buffer[offset++] = (byte)(128 + (ch & 0x3F));
                }
                buffer[0] = (byte)(offset - 1);
                return offset;
            }
            case BINARY: {
                return this.evalToBuffer(context, buffer, off);
            }
        }
        throw new UnsupportedOperationException(this.getClass().getName() + " unknown column: " + (Object)((Object)columnType));
    }

    public void initGroup(QueryContext context) throws SQLException {
    }

    public void evalGroup(QueryContext context) throws SQLException {
    }

    public boolean evalEqual(QueryContext context, String evalString) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean evalEqual(QueryContext context, byte[] data) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

