/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.IdExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.table.TableIterator;
import java.io.IOException;
import java.sql.SQLException;

class IdentityIndexExpr
extends RowIterateExpr {
    private IdExpr _columnExpr;
    private Expr _expr;

    IdentityIndexExpr(IdExpr index, Expr expr) {
        this._expr = expr;
        this._columnExpr = index;
        if (expr == null || index == null) {
            throw new NullPointerException();
        }
        index.getColumn();
    }

    public Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        return this;
    }

    boolean allowChildRowShift(QueryContext context, TableIterator rowIter) {
        return false;
    }

    boolean init(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.init(context);
        return true;
    }

    boolean initRow(QueryContext context, TableIterator tableIter) throws SQLException, IOException {
        long rowAddr = this.evalIndex(context);
        if (rowAddr == 0L) {
            return false;
        }
        context.unlock();
        if (!tableIter.isValidRow(rowAddr)) {
            return false;
        }
        tableIter.setRow(rowAddr);
        context.lock();
        return true;
    }

    boolean nextRow(QueryContext context, TableIterator table) {
        return false;
    }

    long evalIndex(QueryContext context) throws SQLException {
        long value = this._expr.evalLong(context);
        if (value <= 0L) {
            return 0L;
        }
        return value;
    }

    boolean nextBlock(QueryContext context, TableIterator rowIter) throws IOException, SQLException {
        context.unlock();
        return false;
    }

    public String toString() {
        return "(" + this._columnExpr + " = " + this._expr + ")";
    }
}

