/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.LeftOuterIndexExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.table.TableIterator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeftOuterJoinExpr
extends RowIterateExpr {
    private Expr _expr;
    private FromItem _table;
    private int _tableIndex;

    LeftOuterJoinExpr(FromItem table, Expr expr) {
        this._table = table;
        this._expr = expr;
    }

    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        if (!fromList.contains(this._table)) {
            return Integer.MAX_VALUE;
        }
        if (fromList.get(fromList.size() - 1) == this._table) {
            return 0L;
        }
        return 10000L;
    }

    @Override
    public RowIterateExpr getIndexExpr(FromItem fromItem) {
        if (this._table == fromItem) {
            RowIterateExpr indexExpr = this._expr.getIndexExpr(fromItem);
            if (indexExpr != null) {
                return new LeftOuterIndexExpr(indexExpr);
            }
            return this;
        }
        return null;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        FromItem[] fromItems = query.getFromItems();
        for (int i = 0; i < fromItems.length; ++i) {
            if (this._table != fromItems[i]) continue;
            this._tableIndex = i;
        }
        return this;
    }

    @Override
    boolean init(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.init(context);
        return rowIter.next();
    }

    @Override
    boolean initRow(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.init(context);
        if (!rowIter.next()) {
            return false;
        }
        rowIter.initRow();
        Expr expr = this._expr;
        do {
            if (rowIter.nextRow()) continue;
            if (rowIter.next()) {
                rowIter.initRow();
                continue;
            }
            rowIter.initNullRow();
            return true;
        } while (expr.evalBoolean(context) != 1);
        TableIterator parentIter = context.getTableIterators()[1];
        return true;
    }

    @Override
    boolean allowChildRowShift(QueryContext context, TableIterator rowIter) {
        return false;
    }

    @Override
    boolean nextRow(QueryContext context, TableIterator rowIter) throws IOException, SQLException {
        if (rowIter.isNullRow()) {
            return false;
        }
        Expr expr = this._expr;
        while (rowIter.nextRow() || rowIter.next()) {
            if (expr.evalBoolean(context) != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean nextBlock(QueryContext context, TableIterator rowIter) throws IOException {
        return false;
    }

    public String toString() {
        return "LeftOuterJoinExpr(" + this._expr + ")";
    }
}

