/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.AbstractBinaryBooleanExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;

final class LongLtExpr
extends AbstractBinaryBooleanExpr {
    private final Expr _left;
    private final Expr _right;

    LongLtExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public final Expr getLeft() {
        return this._left;
    }

    public final Expr getRight() {
        return this._right;
    }

    public Expr create(Expr left, Expr right) {
        return new LongLtExpr(left, right);
    }

    public final boolean isSelect(QueryContext context) throws SQLException {
        Expr left = this._left;
        Expr right = this._right;
        if (left.isNull(context) || right.isNull(context)) {
            return false;
        }
        return left.evalLong(context) < right.evalLong(context);
    }

    public final int evalBoolean(QueryContext context) throws SQLException {
        Expr left = this._left;
        Expr right = this._right;
        if (left.isNull(context) || right.isNull(context)) {
            return -1;
        }
        if (left.evalLong(context) < right.evalLong(context)) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "(" + this._left + " < " + this._right + ")";
    }
}

