/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringExpr
extends Expr {
    private String _value;

    StringExpr(String value) {
        this._value = value;
    }

    public String getValue() {
        return this._value;
    }

    public Class getType() {
        return String.class;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return 0L;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this._value == null;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return this._value;
    }

    @Override
    public int evalToBuffer(QueryContext context, byte[] buffer, int offset) throws SQLException {
        String v = this.evalString(context);
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            buffer[offset + i] = (byte)v.charAt(i);
        }
        return len;
    }

    @Override
    public byte[] evalBytes(QueryContext context) throws SQLException {
        String v = this.evalString(context);
        if (v == null) {
            return null;
        }
        int len = v.length();
        byte[] value = new byte[v.length()];
        for (int i = 0; i < len; ++i) {
            value[i] = (byte)v.charAt(i);
        }
        return value;
    }

    public String toString() {
        return "'" + this._value + "'";
    }
}

