/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DoubleColumn
extends Column {
    DoubleColumn(Row row, String name) {
        super(row, name);
    }

    @Override
    public Column.ColumnType getTypeCode() {
        return Column.ColumnType.DOUBLE;
    }

    @Override
    public Class<?> getJavaType() {
        return Double.TYPE;
    }

    @Override
    public int getDeclarationSize() {
        return 8;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    void setString(DbTransaction xa, byte[] block, int rowOffset, String str) {
        if (str == null) {
            this.setNull(block, rowOffset);
        } else {
            this.setDouble(xa, block, rowOffset, Double.parseDouble(str));
        }
    }

    @Override
    public String getString(long blockId, byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return null;
        }
        return String.valueOf(this.getDouble(blockId, block, rowOffset));
    }

    @Override
    void setInteger(DbTransaction xa, byte[] block, int rowOffset, int value) {
        this.setDouble(xa, block, rowOffset, value);
    }

    @Override
    public int getInteger(long blockId, byte[] block, int rowOffset) {
        return (int)this.getDouble(blockId, block, rowOffset);
    }

    @Override
    void setLong(DbTransaction xa, byte[] block, int rowOffset, long value) {
        this.setDouble(xa, block, rowOffset, value);
    }

    @Override
    public long getLong(long blockId, byte[] block, int rowOffset) {
        return (long)this.getDouble(blockId, block, rowOffset);
    }

    @Override
    void setDouble(DbTransaction xa, byte[] block, int rowOffset, double value) {
        int offset = rowOffset + this._columnOffset;
        long longValue = Double.doubleToRawLongBits(value);
        block[offset++] = (byte)(longValue >> 56);
        block[offset++] = (byte)(longValue >> 48);
        block[offset++] = (byte)(longValue >> 40);
        block[offset++] = (byte)(longValue >> 32);
        block[offset++] = (byte)(longValue >> 24);
        block[offset++] = (byte)(longValue >> 16);
        block[offset++] = (byte)(longValue >> 8);
        block[offset++] = (byte)longValue;
        this.setNonNull(block, rowOffset);
    }

    @Override
    public double getDouble(long blockId, byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return 0.0;
        }
        int offset = rowOffset + this._columnOffset;
        long longValue = 0L;
        longValue = ((long)block[offset++] & 0xFFL) << 56;
        longValue |= ((long)block[offset++] & 0xFFL) << 48;
        longValue |= ((long)block[offset++] & 0xFFL) << 40;
        longValue |= ((long)block[offset++] & 0xFFL) << 32;
        longValue |= ((long)block[offset++] & 0xFFL) << 24;
        longValue |= ((long)block[offset++] & 0xFFL) << 16;
        longValue |= ((long)block[offset++] & 0xFFL) << 8;
        return Double.longBitsToDouble(longValue |= (long)block[offset++] & 0xFFL);
    }

    @Override
    void setExpr(DbTransaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(context)) {
            this.setNull(block, rowOffset);
        } else {
            this.setDouble(xa, block, rowOffset, expr.evalDouble(context));
        }
    }

    @Override
    public void evalToResult(long blockId, byte[] block, int rowOffset, SelectResult result) {
        if (this.isNull(block, rowOffset)) {
            result.writeNull();
            return;
        }
        result.writeDouble(this.getDouble(blockId, block, rowOffset));
    }

    @Override
    int evalToBuffer(byte[] block, int rowOffset, byte[] buffer, int bufferOffset) throws SQLException {
        if (this.isNull(block, rowOffset)) {
            return 0;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = 8;
        System.arraycopy(block, startOffset, buffer, bufferOffset, len);
        return len;
    }

    @Override
    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        if (this.isNull(block1, rowOffset1) != this.isNull(block2, rowOffset2)) {
            return false;
        }
        int startOffset1 = rowOffset1 + this._columnOffset;
        int startOffset2 = rowOffset2 + this._columnOffset;
        return block1[startOffset1 + 0] == block2[startOffset2 + 0] && block1[startOffset1 + 1] == block2[startOffset2 + 1] && block1[startOffset1 + 2] == block2[startOffset2 + 2] && block1[startOffset1 + 3] == block2[startOffset2 + 3] && block1[startOffset1 + 4] == block2[startOffset2 + 4] && block1[startOffset1 + 5] == block2[startOffset2 + 5] && block1[startOffset1 + 6] == block2[startOffset2 + 6] && block1[startOffset1 + 7] == block2[startOffset2 + 7];
    }

    @Override
    public void set(DbTransaction xa, TableIterator iter, Expr expr, QueryContext context) throws SQLException {
        iter.setDirty();
        this.setDouble(iter.getTransaction(), iter.getBuffer(), iter.getRowOffset(), expr.evalDouble(context));
    }

    @Override
    void deleteIndex(DbTransaction xa, byte[] block, int rowOffset) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            index.remove(block, rowOffset + this._columnOffset, 8);
        }
    }
}

