/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.block.Block;
import com.caucho.db.table.Table;
import com.caucho.db.xa.DbTransaction;
import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.inject.Module;
import com.caucho.util.Friend;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
class TableRowAllocator
extends AbstractTaskWorker {
    private static final Logger log = Logger.getLogger(TableRowAllocator.class.getName());
    private static final int FREE_ROW_BLOCK_SIZE = 256;
    public static final long ROW_CLOCK_MIN = 1024L;
    private final Table _table;
    private final int _rowLength;
    private final int _rowsPerBlock;
    private final int _rowEnd;
    private final AtomicLongArray _insertFreeRowBlockArray = new AtomicLongArray(256);
    private final AtomicInteger _insertFreeRowBlockHead = new AtomicInteger();
    private final AtomicInteger _insertFreeRowBlockTail = new AtomicInteger();
    private long _rowTailTop = 0x200000L;
    private final AtomicLong _rowTailOffset = new AtomicLong();
    private long _rowClockTop;
    private long _rowClockOffset;
    private long _clockRowFree;
    private long _clockRowUsed;
    private long _clockBlockFree;
    private long _clockRowDeleteCount;

    TableRowAllocator(Table table) {
        this._table = table;
        this._rowsPerBlock = table.getRowsPerBlock();
        this._rowLength = table.getRowLength();
        this._rowEnd = table.getRowEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Friend(value=Table.class)
    int allocateRow(Block block, DbTransaction xa) throws IOException, SQLException, InterruptedException {
        Lock blockLock = block.getWriteLock();
        blockLock.tryLock(xa.getTimeout(), TimeUnit.MILLISECONDS);
        try {
            block.read();
            byte[] buffer = block.getBuffer();
            for (int rowOffset = 0; rowOffset < this._rowEnd; rowOffset += this._rowLength) {
                if (buffer[rowOffset] != 0) continue;
                buffer[rowOffset] = 2;
                block.setDirty(rowOffset, rowOffset + 1);
                int n = rowOffset;
                return n;
            }
        }
        finally {
            blockLock.unlock();
        }
        return -1;
    }

    @Friend(value=Table.class)
    long allocateInsertRowBlock() throws IOException {
        long blockId = this.allocateRowBlockId();
        if (blockId != 0L) {
            return blockId;
        }
        long rowTailOffset = this._rowTailOffset.get();
        blockId = this._table.firstRowBlock(rowTailOffset);
        if (blockId <= 0L) {
            Block block = this._table.allocateRow();
            blockId = block.getBlockId();
            block.free();
        }
        this._rowTailOffset.compareAndSet(rowTailOffset, blockId + 8192L);
        return blockId;
    }

    private void fillFreeRows() {
        if (this._rowTailOffset.get() < this._rowTailTop || this.isClosed()) {
            return;
        }
        while (this.scanClock()) {
            if (this.resetClock()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanClock() {
        while (!this.isClosed() && this.isFreeRowBlockIdAvailable()) {
            long clockBlockId = this._rowClockOffset;
            try {
                clockBlockId = this._table.firstRowBlock(clockBlockId);
                if (clockBlockId < 0L) {
                    this._rowClockOffset = this._rowClockTop;
                    boolean bl = true;
                    return bl;
                }
                if (!this.isRowBlockFree(clockBlockId)) continue;
                ++this._clockBlockFree;
                this.freeRowBlockId(clockBlockId);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
                clockBlockId = this._rowClockTop;
            }
            finally {
                this._rowClockOffset = clockBlockId + 8192L;
            }
        }
        return false;
    }

    private boolean resetClock() {
        long newRowCount = (this._clockRowUsed - this._clockRowFree) / (long)this._rowsPerBlock;
        long tableRowDeleteCount = this._table.getRowDeleteCount();
        long deleteRowCount = (tableRowDeleteCount - this._clockRowDeleteCount) / (long)this._rowsPerBlock;
        if (this._clockRowFree < 1024L && this._rowClockOffset > 0L) {
            newRowCount = 1024L;
        } else if (deleteRowCount < 1024L) {
            newRowCount = 1024L;
        }
        this._rowClockOffset = 0L;
        this._rowClockTop = this._rowTailOffset.get();
        this._clockRowUsed = 0L;
        this._clockRowFree = 0L;
        this._clockRowDeleteCount = tableRowDeleteCount;
        if (newRowCount > 0L) {
            this._rowTailTop = this._rowTailOffset.get() + newRowCount * (long)this._rowLength;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRowBlockFree(long blockId) throws IOException {
        if (this.isClosed()) {
            return false;
        }
        Block block = this._table.readBlock(blockId);
        try {
            byte[] buffer = block.getBuffer();
            boolean isFree = false;
            for (int rowOffset = 0; rowOffset < this._rowEnd; rowOffset += this._rowLength) {
                if (buffer[rowOffset] == 0) {
                    isFree = true;
                    ++this._clockRowFree;
                    continue;
                }
                ++this._clockRowUsed;
            }
            boolean bl = isFree;
            return bl;
        }
        finally {
            block.free();
        }
    }

    private boolean isFreeRowBlockIdAvailable() {
        int tail;
        int head = this._insertFreeRowBlockHead.get();
        return (head + 1) % 256 != (tail = this._insertFreeRowBlockTail.get());
    }

    private long allocateRowBlockId() {
        int head;
        int tail;
        long blockId;
        do {
            tail = this._insertFreeRowBlockTail.get();
            head = this._insertFreeRowBlockHead.get();
            if (head == tail) {
                this.wake();
                return 0L;
            }
            blockId = this._insertFreeRowBlockArray.getAndSet(tail, 0L);
            int nextTail = (tail + 1) % 256;
            this._insertFreeRowBlockTail.compareAndSet(tail, nextTail);
        } while (blockId <= 0L);
        int size = (head - tail + 256) % 256;
        if (2 * size < 256) {
            this.wake();
        }
        return blockId;
    }

    @Friend(value=Table.class)
    void freeRowBlockId(long blockId) {
        int head;
        do {
            int tail;
            int nextHead;
            if ((nextHead = ((head = this._insertFreeRowBlockHead.get()) + 1) % 256) == (tail = this._insertFreeRowBlockTail.get())) {
                return;
            }
            this._insertFreeRowBlockHead.compareAndSet(head, nextHead);
        } while (!this._insertFreeRowBlockArray.compareAndSet(head, 0L, blockId));
    }

    public long runTask() {
        this.fillFreeRows();
        return -1L;
    }
}

