/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.distcache.jcache;

import com.caucho.distcache.jcache.CacheBuilderImpl;
import com.caucho.server.distcache.CacheManagerImpl;
import com.caucho.transaction.UserTransactionProxy;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheManager;
import javax.cache.OptionalFeature;
import javax.cache.Status;
import javax.transaction.UserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManagerFacade
implements CacheManager {
    private CacheManagerImpl _manager;
    private ConcurrentHashMap<String, Cache<?, ?>> _cacheMap = new ConcurrentHashMap();

    public CacheManagerFacade(String name, ClassLoader loader, CacheManagerImpl manager) {
        this._manager = manager;
    }

    @Override
    public String getName() {
        return this._manager.getName();
    }

    public String getGuid() {
        return this._manager.getGuid();
    }

    @Override
    public <K, V> CacheBuilder<K, V> createCacheBuilder(String cacheName) {
        return new CacheBuilderImpl(cacheName, this);
    }

    void addCache(String name, Cache<?, ?> cache) {
        this._cacheMap.putIfAbsent(name, cache);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name) {
        return this._cacheMap.get(name);
    }

    public Set<Cache<?, ?>> getCaches() {
        return new HashSet(this._cacheMap.values());
    }

    @Override
    public Status getStatus() {
        if (this._manager != null) {
            return Status.STARTED;
        }
        return Status.STOPPED;
    }

    @Override
    public UserTransaction getUserTransaction() {
        return UserTransactionProxy.getCurrent();
    }

    @Override
    public boolean isSupported(OptionalFeature optionalFeature) {
        return false;
    }

    @Override
    public boolean removeCache(String cacheName) throws IllegalStateException {
        return this._cacheMap.remove(cacheName) != null;
    }

    @Override
    public void shutdown() {
        this._manager = null;
    }

    @Override
    public <T> T unwrap(Class<T> cl) {
        return null;
    }

    public void close() {
        this.shutdown();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "," + this.getGuid() + "]";
    }
}

