/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.embeddable;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.manager.EjbEnvironmentListener;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.env.jpa.ListenerPersistenceEnvironment;
import com.caucho.inject.Module;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.ContextImpl;
import com.caucho.naming.InitialContextFactoryImpl;
import com.caucho.server.e_app.EnterpriseApplication;
import com.caucho.server.webbeans.ResinCdiProducer;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class EJBContainerImpl
extends EJBContainer {
    private static final Logger log = Logger.getLogger(EJBContainerImpl.class.getName());
    public static final String CONFIG_FILE = "caucho.ejb.embed.config.file";
    private Context _context;
    private ClassLoader _parentClassLoader;
    private EnvironmentClassLoader _classLoader;
    private InjectManager _injectManager;
    private EnterpriseApplication _application;
    private ArrayList<Path> _moduleRoots;
    private Map<?, ?> _properties;

    public EJBContainerImpl() throws EJBException {
        this(null, new HashMap());
    }

    public EJBContainerImpl(String name, Map<?, ?> properties) throws EJBException {
        this.preInit(name);
        this._properties = properties;
    }

    void addModule(Path path) {
        if (this._moduleRoots == null) {
            this._moduleRoots = new ArrayList();
        }
        this._moduleRoots.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preInit(String name) {
        if (this._application != null) {
            return;
        }
        Thread thread = Thread.currentThread();
        this._parentClassLoader = thread.getContextClassLoader();
        this._application = EnterpriseApplication.create(name);
        this._classLoader = this._application.getClassLoader();
        this._injectManager = InjectManager.create(this._classLoader);
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Environment.init();
            Environment.addChildLoaderListener(new ListenerPersistenceEnvironment());
            Environment.addChildLoaderListener(new EjbEnvironmentListener());
            this._injectManager.addManagedBeanDiscover(this._injectManager.createManagedBean(ResinCdiProducer.class));
            Class<?> resinValidatorClass = ResinCdiProducer.createResinValidatorProducer();
            if (this._injectManager != null && resinValidatorClass != null) {
                this._injectManager.addManagedBeanDiscover(this._injectManager.createManagedBean(resinValidatorClass));
            }
            AbstractModel model = InitialContextFactoryImpl.createRoot();
            this._context = new ContextImpl(model, null);
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            try {
                thread.setContextClassLoader(this._classLoader);
                this.configure();
                if (this._moduleRoots != null) {
                    for (Path path : this._moduleRoots) {
                        this._classLoader.addURL(new URL(path.getURL()));
                    }
                    EjbManager manager = EjbManager.getCurrent();
                    manager.setGlobalClassLoader(this._parentClassLoader);
                    manager.setScannableRoots(this._moduleRoots);
                }
                this._classLoader.addScanRoot();
                this._application.start();
            }
            catch (MalformedURLException e) {
                log.log(Level.FINE, e.toString(), e);
                Object var6_7 = null;
                thread.setContextClassLoader(oldLoader);
            }
            Object var6_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private void configure() {
        String configFile = (String)this._properties.get(CONFIG_FILE);
        if (configFile == null) {
            configFile = System.getProperty(CONFIG_FILE);
        }
        if (configFile == null) {
            return;
        }
        Path path = Vfs.lookup(configFile);
        Config config = new Config();
        EnvironmentConfig configItem = new EnvironmentConfig();
        try {
            config.configure((Object)configItem, path);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    @Override
    public void close() {
        this._classLoader.destroy();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._application.getName() + "]";
    }

    class EnvironmentConfig
    implements EnvironmentBean {
        EnvironmentConfig() {
        }

        public ClassLoader getClassLoader() {
            return EJBContainerImpl.this._classLoader;
        }
    }
}

