/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.CandiEnhancedBean;
import com.caucho.config.gen.LifecycleAspectBeanFactory;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.gen.SessionGenerator;
import com.caucho.ejb.gen.SingletonAspectBeanFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.Singleton;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class SingletonGenerator<X>
extends SessionGenerator<X> {
    private final AspectBeanFactory<X> _aspectBeanFactory;
    private final AspectBeanFactory<X> _lifecycleAspectFactory;

    public SingletonGenerator(String ejbName, AnnotatedType<X> ejbClass, ArrayList<AnnotatedType<? super X>> localApi, AnnotatedType<X> localBean, ArrayList<AnnotatedType<? super X>> remoteApi) {
        super(ejbName, ejbClass, localApi, localBean, remoteApi, Singleton.class.getSimpleName());
        InjectManager manager = InjectManager.create();
        this._aspectBeanFactory = new SingletonAspectBeanFactory(manager, this.getBeanType());
        this._lifecycleAspectFactory = new LifecycleAspectBeanFactory<X>(this._aspectBeanFactory, manager, this.getBeanType());
    }

    @Override
    protected AspectBeanFactory<X> getAspectBeanFactory() {
        return this._aspectBeanFactory;
    }

    @Override
    protected AspectBeanFactory<X> getLifecycleAspectFactory() {
        return this._lifecycleAspectFactory;
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    protected boolean isTimerSupported() {
        return true;
    }

    public String getContextClassName() {
        return this.getClassName();
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public String getViewClassName() {
        return "SingletonView";
    }

    @Override
    public String getBeanClassName() {
        return "Bean";
    }

    @Override
    protected AnnotatedType<? super X> introspectLocalDefault() {
        return this.getBeanType();
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        this.generateTopComment(out);
        out.println();
        out.println("package " + this.getPackageName() + ";");
        out.println();
        out.println("import com.caucho.config.*;");
        out.println("import com.caucho.ejb.*;");
        out.println("import com.caucho.ejb.session.*;");
        out.println();
        out.println("import javax.ejb.*;");
        out.println("import javax.transaction.*;");
        out.println("import javax.enterprise.context.spi.CreationalContext;");
        this.generateClassHeader(out);
        out.println("{");
        out.pushDepth();
        this.generateClassStaticFields(out);
        this.generateClassContent(out);
        this.generateDependency(out);
        out.popDepth();
        out.println("}");
    }

    private void generateClassHeader(JavaWriter out) throws IOException {
        out.println();
        out.println("public class " + this.getClassName() + "<T>");
        if (this.hasNoInterfaceView()) {
            out.println("  extends " + this.getBeanType().getJavaClass().getName());
        }
        out.print("  implements SessionProxyFactory<T>");
        out.print(",\n    " + CandiEnhancedBean.class.getName());
        for (AnnotatedType apiType : this.getLocalApi()) {
            out.print(",\n    ");
            out.printType(apiType.getBaseType());
        }
        for (AnnotatedType apiType : this.getRemoteApi()) {
            out.print(",\n    ");
            out.printType(apiType.getBaseType());
        }
        out.println();
    }

    @Override
    protected void generateClassContent(JavaWriter out) throws IOException {
        out.println("private transient SingletonContext _context;");
        out.println("private transient SingletonManager _manager;");
        String beanClassName = this.getBeanType().getJavaClass().getName();
        out.println("private " + beanClassName + " _bean;");
        out.println("private transient boolean _isValid;");
        out.println("private transient boolean _isActive;");
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.generateConstructor(out);
        this.generateProxyFactory(out);
        this.generateContentImpl(out, map);
    }

    @Override
    protected void generateInjectContent(JavaWriter out, HashMap<String, Object> map) throws IOException {
        String beanClassName = this.getBeanType().getJavaClass().getName();
        out.println("_bean = (" + beanClassName + ") _manager.newInstance(parentEnv);");
        super.generateInjectContent(out, map);
    }

    private void generateConstructor(JavaWriter out) throws IOException {
        out.println();
        out.print("public " + this.getClassName() + "(SingletonManager manager");
        out.println(", SingletonContext context)");
        out.println("{");
        out.pushDepth();
        out.println("_manager = manager;");
        out.popDepth();
        out.println("}");
        out.println();
        out.print("private ");
        out.println(this.getClassName() + "(SingletonManager manager" + ", com.caucho.config.inject.CreationalContextImpl<T> env)");
        out.println("{");
        out.pushDepth();
        out.println("_manager = manager;");
        out.println("_isValid = true;");
        this.generateContextObjectConstructor(out);
        out.popDepth();
        out.println("}");
    }

    private void generateProxyFactory(JavaWriter out) throws IOException {
        out.println();
        out.println("@Override");
        out.println("public T __caucho_createProxy(com.caucho.config.inject.CreationalContextImpl<T> env)");
        out.println("{");
        out.println("  return (T) new " + this.getClassName() + "(_manager, env);");
        out.println("}");
        out.println();
        out.println("@Override");
        out.println("public void __caucho_destroy()");
        out.println("{");
        out.println("}");
    }
}

