/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.message;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionTargetBuilder;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.gen.MessageGenerator;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.message.CauchoMessageEndpoint;
import com.caucho.ejb.message.MessageDrivenContextImpl;
import com.caucho.ejb.server.AbstractContext;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.inject.Module;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class MessageManager<X>
extends AbstractEjbBeanManager<X>
implements MessageEndpointFactory {
    private static final L10N L = new L10N(MessageManager.class);
    protected static final Logger log = Logger.getLogger(MessageManager.class.getName());
    private ResourceAdapter _ra;
    private ActivationSpec _activationSpec;
    private MessageDrivenContext _context;
    private EjbLazyGenerator<X> _lazyGenerator;
    private Class<X> _proxyImplClass;
    private InjectionTargetBuilder<X> _builder;
    private Method _ejbCreate;

    public MessageManager(EjbManager ejbContainer, String ejbName, String moduleName, AnnotatedType<X> rawAnnType, AnnotatedType<X> annotatedType, EjbLazyGenerator<X> lazyGenerator) {
        super(ejbContainer, ejbName, moduleName, rawAnnType, annotatedType);
        InjectManager webBeans = InjectManager.create();
        UserTransaction ut = webBeans.getReference(UserTransaction.class, new Annotation[0]);
        this._lazyGenerator = lazyGenerator;
        this._context = new MessageDrivenContextImpl(this, ut);
    }

    @Override
    protected String getType() {
        return "message:";
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this._activationSpec = activationSpec;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        this._ra = ra;
    }

    @Override
    public ArrayList<AnnotatedType<? super X>> getLocalApi() {
        return new ArrayList<AnnotatedType<? super X>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            super.init();
            if (this._activationSpec == null) {
                throw this.error(L.l("ActivationSpec is missing from message-driven bean '{0}'.", (Object)this.getEJBName()));
            }
            if (this._ra == null) {
                throw this.error(L.l("ResourceAdapter is missing from message-driven bean '{0}'.", (Object)this.getEJBName()));
            }
            this.bindContext();
            Object var4_3 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    @Override
    public void bind() {
        block7: {
            try {
                boolean isAutoCompile = true;
                if (this._proxyImplClass != null) break block7;
                BeanGenerator<X> beanGen = this.createBeanGenerator();
                String fullClassName = beanGen.getFullClassName();
                JavaClassGenerator javaGen = this._lazyGenerator.getJavaClassGenerator();
                if (javaGen.preload(fullClassName) == null && isAutoCompile) {
                    beanGen.introspect();
                    javaGen.generate(beanGen);
                }
                javaGen.compilePendingJava();
                this._proxyImplClass = javaGen.loadClass(fullClassName);
                InjectManager cdiManager = InjectManager.create(this.getClassLoader());
                ReflectionAnnotatedType<X> annType = ReflectionAnnotatedFactory.introspectType(this._proxyImplClass);
                this._builder = new InjectionTargetBuilder<X>(cdiManager, annType, null);
                try {
                    Class<X> beanClass = this._proxyImplClass;
                    if (beanClass == null) {
                        beanClass = this.getAnnotatedType().getJavaClass();
                    }
                    if (beanClass != null) {
                        this._ejbCreate = beanClass.getMethod("ejbCreate", new Class[0]);
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
    }

    protected BeanGenerator<X> createBeanGenerator() {
        AnnotatedType ejbClass = this.getAnnotatedType();
        return new MessageGenerator(this.getEJBName(), ejbClass);
    }

    @Override
    protected void bindContext() {
        super.bindContext();
        InjectManager manager = InjectManager.create();
        BeanBuilder<?> factory = manager.createBeanFactory(this._context.getClass());
        manager.addBeanDiscover(factory.singleton(this._context));
    }

    @Override
    public boolean start() throws Exception {
        if (!super.start()) {
            return false;
        }
        this._ra.endpointActivation(this, this._activationSpec);
        return true;
    }

    public MessageDrivenContext getMessageContext() {
        return this._context;
    }

    void generate() throws Exception {
    }

    @Override
    public AbstractContext getContext(Object obj, boolean foo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        return this.createEndpoint(xaResource, 0L);
    }

    @Override
    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        try {
            X listener = this.createMessageListener();
            ((CauchoMessageEndpoint)listener).__caucho_setXAResource(xaResource);
            return (MessageEndpoint)listener;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() != null) {
                throw new UnavailableException(e.getCause());
            }
            throw new UnavailableException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X createMessageListener() throws Exception {
        X x;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            OwnerCreationalContext env = new OwnerCreationalContext(null);
            X listener = this._builder.produce(env);
            this._builder.inject(listener, env);
            if (listener instanceof MessageDrivenBean) {
                MessageDrivenBean bean = (MessageDrivenBean)listener;
                bean.setMessageDrivenContext(this._context);
            }
            if (this._ejbCreate != null) {
                this._ejbCreate.invoke(listener, new Object[0]);
            }
            this._builder.postConstruct(listener);
            x = listener;
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        return x;
    }

    @Override
    public void destroy() {
        this._ra.endpointDeactivation(this, this._activationSpec);
    }

    @Override
    public <T> Object getLocalJndiProxy(Class<T> api) {
        return null;
    }

    @Override
    public <T> T getLocalProxy(Class<T> api) {
        return null;
    }

    @Override
    public <T> T getRemoteObject(Class<T> api, String protocol) {
        return null;
    }
}

