/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.j2ee.BeanNameLiteral;
import com.caucho.config.reflect.AnnotatedMethodImpl;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.config.reflect.BaseType;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.inject.ProcessSessionBeanImpl;
import com.caucho.ejb.inject.SessionRegistrationBean;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.ExtAnnotatedType;
import com.caucho.ejb.session.SessionProxyFactory;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.SessionBeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionManager<X>
extends AbstractEjbBeanManager<X> {
    private static final L10N L = new L10N(AbstractSessionManager.class);
    private static final Logger log = Logger.getLogger(AbstractSessionManager.class.getName());
    private EjbLazyGenerator<X> _lazyGenerator;
    private Class<?> _proxyImplClass;
    private HashMap<Class<?>, AbstractSessionContext<X, ?>> _contextMap = new HashMap();
    private InjectManager _injectManager;
    private Bean<X> _bean;
    private String[] _declaredRoles;

    public AbstractSessionManager(EjbManager manager, String ejbName, String moduleName, AnnotatedType<X> rawAnnType, AnnotatedType<X> annotatedType, EjbLazyGenerator<X> lazyGenerator) {
        super(manager, ejbName, moduleName, rawAnnType, annotatedType);
        this._lazyGenerator = lazyGenerator;
        DeclareRoles declareRoles = annotatedType.getJavaClass().getAnnotation(DeclareRoles.class);
        RolesAllowed rolesAllowed = annotatedType.getJavaClass().getAnnotation(RolesAllowed.class);
        if (declareRoles != null && rolesAllowed != null) {
            this._declaredRoles = new String[declareRoles.value().length + rolesAllowed.value().length];
            System.arraycopy(declareRoles.value(), 0, this._declaredRoles, 0, declareRoles.value().length);
            System.arraycopy(rolesAllowed.value(), 0, this._declaredRoles, declareRoles.value().length, rolesAllowed.value().length);
        } else if (declareRoles != null) {
            this._declaredRoles = declareRoles.value();
        } else if (rolesAllowed != null) {
            this._declaredRoles = rolesAllowed.value();
        }
    }

    @Override
    protected String getType() {
        return "session:";
    }

    @Override
    public Bean<X> getDeployBean() {
        return this._bean;
    }

    public Class<?> getProxyImplClass() {
        return this._proxyImplClass;
    }

    @Override
    public InjectManager getInjectManager() {
        return this._injectManager;
    }

    protected EjbLazyGenerator<X> getLazyGenerator() {
        return this._lazyGenerator;
    }

    @Override
    public ArrayList<AnnotatedType<? super X>> getLocalApi() {
        return this._lazyGenerator.getLocalApi();
    }

    @Override
    public ArrayList<AnnotatedType<? super X>> getRemoteApi() {
        return this._lazyGenerator.getRemoteApi();
    }

    @Override
    public AnnotatedType<X> getLocalBean() {
        return this._lazyGenerator.getLocalBean();
    }

    protected <T> AbstractSessionContext<X, T> getSessionContext(Class<T> api) {
        return this._contextMap.get(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            super.init();
            this._injectManager = InjectManager.create();
            this.registerInjection();
            for (AnnotatedType<X> localApi : this._lazyGenerator.getLocalApi()) {
                this.createContext(localApi.getJavaClass());
            }
            AnnotatedType<X> localBean = this._lazyGenerator.getLocalBean();
            if (localBean != null) {
                this.createContext(localBean.getJavaClass());
            }
            for (AnnotatedType<X> remoteApi : this._lazyGenerator.getRemoteApi()) {
                this.createContext(remoteApi.getJavaClass());
            }
            this.bindContext();
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        this.registerCdiBeans();
        log.fine(this + " initialized");
    }

    @Override
    public void bind() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            try {
                thread.setContextClassLoader(this.getClassLoader());
                boolean isAutoCompile = true;
                if (this._proxyImplClass == null) {
                    BeanGenerator<X> beanGen = this.createBeanGenerator();
                    String fullClassName = beanGen.getFullClassName();
                    JavaClassGenerator javaGen = this.getLazyGenerator().getJavaClassGenerator();
                    if (javaGen.preload(fullClassName) == null && isAutoCompile) {
                        beanGen.introspect();
                        javaGen.generate(beanGen);
                    }
                    javaGen.compilePendingJava();
                    this._proxyImplClass = this.generateProxyClass(fullClassName, javaGen);
                }
                for (AbstractSessionContext<X, ?> cxt : this._contextMap.values()) {
                    cxt.bind();
                }
                Object var8_8 = null;
                thread.setContextClassLoader(loader);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            thread.setContextClassLoader(loader);
            throw throwable;
        }
    }

    protected BeanGenerator<X> createBeanGenerator() {
        throw new UnsupportedOperationException();
    }

    private <T> void createContext(Class<T> api) {
        if (this._contextMap.get(api) != null) {
            throw new IllegalStateException(String.valueOf(api));
        }
        AbstractSessionContext<X, T> context = this.createSessionContext(api);
        InjectManager injectManager = context.getInjectManager();
        BeanBuilder<SessionContext> factory = injectManager.createBeanFactory(SessionContext.class);
        context.setDeclaredRoles(this._declaredRoles);
        if (injectManager.getBeans((Type)((Object)SessionContext.class), new Annotation[0]).size() == 0) {
            injectManager.addBeanDiscover(factory.singleton(context));
        }
        this._contextMap.put(context.getApi(), context);
        try {
            String beanName = this.getAnnotatedType().getJavaClass().getName();
            Jndi.bindDeep("java:comp/EJBContext", context);
            Jndi.bindDeep("java:comp/" + beanName + "/ejbContext", context);
            Jndi.bindDeep("java:comp/" + beanName + "/sessionContext", context);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            TimerService timer = context.getTimerService();
            BeanBuilder<TimerService> timerBuilder = injectManager.createBeanFactory(TimerService.class);
            if (injectManager.getBeans((Type)((Object)TimerService.class), new Annotation[0]).size() == 0) {
                injectManager.addBeanDiscover(timerBuilder.singleton(timer));
            }
        }
        catch (Exception e) {
            log.log(Level.ALL, e.toString(), e);
        }
    }

    private Class<?> generateProxyClass(String skeletonName, JavaClassGenerator javaGen) throws ClassNotFoundException {
        Class ejbClass = this.getAnnotatedType().getJavaClass();
        Class<?> proxyImplClass = !this.isPublic(ejbClass) && ejbClass.getClassLoader() instanceof DynamicClassLoader ? javaGen.loadClassParentLoader(skeletonName, ejbClass) : javaGen.loadClass(skeletonName);
        try {
            Method method = proxyImplClass.getMethod("__caucho_getException", new Class[0]);
            RuntimeException exn = (RuntimeException)method.invoke(null, new Object[0]);
            if (exn != null) {
                throw exn;
            }
        }
        catch (RuntimeException exn) {
            throw exn;
        }
        catch (Exception exn) {
            throw new RuntimeException(exn);
        }
        return proxyImplClass;
    }

    private boolean isPublic(Class<?> cl) {
        if (!Modifier.isPublic(cl.getModifiers())) {
            return false;
        }
        Class<?> superClass = cl.getSuperclass();
        if (superClass != null && !Modifier.isPublic(superClass.getModifiers())) {
            return false;
        }
        for (Class<?> ifClass : cl.getInterfaces()) {
            if (Modifier.isPublic(ifClass.getModifiers())) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> T getLocalProxy(Class<T> api) {
        OwnerCreationalContext owner = new OwnerCreationalContext(null);
        return this.getSessionContext(api).createProxy(owner);
    }

    protected <T> AbstractSessionContext<X, T> createSessionContext(Class<T> api) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected <T> SessionProxyFactory<T> createProxyFactory(AbstractSessionContext<X, T> context) {
        try {
            if (this._proxyImplClass == null) {
                this.bind();
            }
            Class[] param = new Class[]{this.getClass(), this.getContextClass()};
            Constructor<?> ctor = this._proxyImplClass.getConstructor(param);
            return (SessionProxyFactory)ctor.newInstance(this, context);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(cause);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected Class<?> getContextClass() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    private void registerCdiBeans() {
        ArrayList<AnnotatedType<X>> localApiList = this.getLocalApi();
        ArrayList<AnnotatedType<X>> remoteApiList = this.getRemoteApi();
        AnnotatedType<Object> rawAnnType = this.getRawAnnotatedType();
        AnnotatedType annType = this.getAnnotatedType();
        AnnotatedType<? super X> extAnnType = this.createExternalAnnotatedType(annType, localApiList);
        InjectManager moduleBeanManager = InjectManager.create();
        ManagedBeanImpl mBean = new ManagedBeanImpl(this.getInjectManager(), this.getAnnotatedType(), true);
        mBean.introspect();
        InjectionTarget target = mBean.getInjectionTarget();
        target = moduleBeanManager.processInjectionTarget(target, this.getRawAnnotatedType());
        mBean.setInjectionTarget(target);
        Class<Object> baseApi = annType.getJavaClass();
        LinkedHashSet<Type> apiList = new LinkedHashSet<Type>();
        AnnotatedType<X> baseType = this.getLocalBean();
        if (baseType != null) {
            BaseType sourceApi = moduleBeanManager.createSourceBaseType(baseType.getBaseType());
            apiList.addAll(sourceApi.getTypeClosure(moduleBeanManager));
        }
        if (localApiList != null) {
            for (AnnotatedType<X> api : localApiList) {
                baseApi = api.getJavaClass();
                BaseType sourceApi = moduleBeanManager.createSourceBaseType(api.getJavaClass());
                apiList.addAll(sourceApi.getTypeClosure(moduleBeanManager));
            }
        }
        apiList.add((Type)((Object)Object.class));
        if (baseApi == null) {
            throw new NullPointerException();
        }
        this._bean = this.createBean(mBean, baseApi, apiList, extAnnType);
        ProcessSessionBeanImpl process = new ProcessSessionBeanImpl(moduleBeanManager, this._bean, rawAnnType, this.getEJBName(), this.getSessionBeanType());
        moduleBeanManager.addBean(this._bean, process);
        if (!moduleBeanManager.isSpecialized(annType.getJavaClass())) {
            moduleBeanManager.addProduces(this._bean, extAnnType);
        }
        for (AnnotatedType<X> localApi : this.getLocalApi()) {
            this.registerLocalSession(moduleBeanManager, localApi.getJavaClass());
        }
        for (AnnotatedType<X> remoteApi : this.getRemoteApi()) {
            this.registerLocalSession(moduleBeanManager, remoteApi.getJavaClass());
        }
        if (this.getLocalBean() != null) {
            this.registerLocalSession(moduleBeanManager, this.getLocalBean().getJavaClass());
        }
    }

    private AnnotatedType<X> createExternalAnnotatedType(AnnotatedType<X> baseType, ArrayList<AnnotatedType<? super X>> apiList) {
        ExtAnnotatedType<Object> extAnnType = new ExtAnnotatedType<Object>(baseType);
        for (AnnotatedField<X> annotatedField : baseType.getFields()) {
            if (!annotatedField.isStatic()) continue;
            extAnnType.addField(annotatedField);
        }
        for (AnnotatedMethod annotatedMethod : baseType.getMethods()) {
            AnnotatedMethod<? super X> extMethod = this.mergeMethod(annotatedMethod, apiList);
            if (extMethod != null) {
                extAnnType.addMethod(extMethod);
                continue;
            }
            if (annotatedMethod.isAnnotationPresent(Produces.class) && !baseType.isAnnotationPresent(Specializes.class)) {
                throw new ConfigException(L.l("{0}.{1} is an invalid @Produces EJB method because the method is not in a @Local interface.", (Object)annotatedMethod.getDeclaringType().getJavaClass().getName(), (Object)annotatedMethod.getJavaMember().getName()));
            }
            if (!this.isDisposes(annotatedMethod)) continue;
            throw new ConfigException(L.l("{0}.{1} is an invalid @Disposes EJB method because the method is not in a @Local interface.", (Object)annotatedMethod.getDeclaringType().getJavaClass().getName(), (Object)annotatedMethod.getJavaMember().getName()));
        }
        return extAnnType;
    }

    private boolean isDisposes(AnnotatedMethod<? super X> method) {
        for (AnnotatedParameter param : method.getParameters()) {
            if (!param.isAnnotationPresent(Disposes.class)) continue;
            return true;
        }
        return false;
    }

    private AnnotatedMethod<? super X> mergeMethod(AnnotatedMethod<? super X> method, ArrayList<AnnotatedType<? super X>> apiList) {
        if (apiList.size() == 0) {
            return method;
        }
        for (AnnotatedType<X> annotatedType : apiList) {
            AnnotatedMethod<X> apiMethod = AnnotatedTypeUtil.findMethod(annotatedType, method);
            if (apiMethod == null) continue;
            AnnotatedMethodImpl extMethod = new AnnotatedMethodImpl(apiMethod.getDeclaringType(), method, apiMethod.getJavaMember(), this.toArray(apiMethod.getAnnotations()), null);
            return extMethod;
        }
        return null;
    }

    private Annotation[] toArray(Set<Annotation> annSet) {
        Annotation[] ann = new Annotation[annSet.size()];
        annSet.toArray(ann);
        return ann;
    }

    private <T> void registerLocalSession(InjectManager beanManager, Class<T> localApi) {
        AbstractSessionContext<X, T> context = this.getSessionContext(localApi);
        BeanNameLiteral beanName = new BeanNameLiteral(this.getEJBName());
        SessionRegistrationBean<X, T> regBean = new SessionRegistrationBean<X, T>(beanManager, context, this._bean, beanName);
        beanManager.addBeanImpl(regBean, regBean.getAnnotated());
    }

    protected Bean<X> getBean() {
        return this._bean;
    }

    protected abstract <T> Bean<T> createBean(ManagedBeanImpl<X> var1, Class<T> var2, Set<Type> var3, AnnotatedType<X> var4);

    protected SessionBeanType getSessionBeanType() {
        return SessionBeanType.STATELESS;
    }

    @Override
    public void destroy() {
        for (AbstractSessionContext<X, ?> context : this._contextMap.values()) {
            try {
                context.destroy();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

