/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValueExpression
extends ValueExpression {
    protected static final Logger log = Logger.getLogger(AbstractValueExpression.class.getName());
    protected static final L10N L = new L10N(AbstractValueExpression.class);
    protected final Expr _expr;
    private final String _expressionString;

    protected AbstractValueExpression() {
        this._expr = null;
        this._expressionString = "";
    }

    protected AbstractValueExpression(Expr expr, String expressionString) {
        this._expr = expr;
        this._expressionString = expressionString;
    }

    protected AbstractValueExpression(Expr expr) {
        this._expr = expr;
        this._expressionString = this._expr != null ? this._expr.toString() : "";
    }

    @Override
    public boolean isLiteralText() {
        return this._expr.isLiteralText();
    }

    @Override
    public String getExpressionString() {
        return this._expressionString;
    }

    @Override
    public abstract Class<?> getExpectedType();

    @Override
    public Class<?> getType(ELContext context) throws PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        Object value = this.getValue(context);
        if (value == null) {
            return null;
        }
        return value.getClass();
    }

    @Override
    public Object getValue(ELContext context) throws PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        return this._expr.getValue(context);
    }

    @Override
    public boolean isReadOnly(ELContext context) throws PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        return this._expr.isReadOnly(context);
    }

    @Override
    public void setValue(ELContext context, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        this._expr.setValue(context, value);
    }

    @Override
    public int hashCode() {
        return this._expr.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractValueExpression)) {
            return false;
        }
        AbstractValueExpression expr = (AbstractValueExpression)o;
        return this._expr.equals(expr._expr);
    }

    public String toString() {
        String name = this.getClass().getName();
        int p = name.lastIndexOf(46);
        name = name.substring(p + 1);
        return name + "[" + this.getExpressionString() + "]";
    }
}

