/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.AbstractBooleanExpr;
import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;

public class NeExpr
extends AbstractBooleanExpr {
    private final Expr _left;
    private final Expr _right;

    public NeExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public boolean evalBoolean(ELContext env) throws ELException {
        Object bObj;
        Object aObj = this._left.getValue(env);
        if (aObj == (bObj = this._right.getValue(env))) {
            return false;
        }
        if (aObj == null || bObj == null) {
            return true;
        }
        Class<?> aType = aObj.getClass();
        Class<?> bType = bObj.getClass();
        if (aType == Boolean.class || bType == Boolean.class) {
            boolean b;
            boolean a = NeExpr.toBoolean(aObj, env);
            return a != (b = NeExpr.toBoolean(bObj, env));
        }
        try {
            if (aObj instanceof BigDecimal || bObj instanceof BigDecimal) {
                BigDecimal b;
                BigDecimal a = NeExpr.toBigDecimal(aObj, env);
                return !a.equals(b = NeExpr.toBigDecimal(bObj, env));
            }
            if (aType == Double.class || aType == Float.class || bType == Double.class || bType == Float.class) {
                double b;
                double a = NeExpr.toDouble(aObj, env);
                return a != (b = NeExpr.toDouble(bObj, env));
            }
            if (aType == BigInteger.class || bType == BigInteger.class) {
                BigInteger b;
                BigInteger a = NeExpr.toBigInteger(aObj, env);
                return !a.equals(b = NeExpr.toBigInteger(bObj, env));
            }
            if (aObj instanceof Number || bObj instanceof Number) {
                long b;
                long a = NeExpr.toLong(aObj, env);
                return a != (b = NeExpr.toLong(bObj, env));
            }
        }
        catch (ELException e) {
            log.finest(L.l("`{0}' in `{1}'", (Object)e.getMessage(), (Object)this.toString()));
            return true;
        }
        if (aObj instanceof String || bObj instanceof String) {
            String b;
            String a = NeExpr.toString(aObj, env);
            return !a.equals(b = NeExpr.toString(bObj, env));
        }
        return !aObj.equals(bObj);
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.NeExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof NeExpr)) {
            return false;
        }
        NeExpr expr = (NeExpr)o;
        return this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        return "(" + this._left + " ne " + this._right + ")";
    }
}

