/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.actor;

import com.caucho.env.actor.ActorProcessor;
import com.caucho.env.actor.ActorQueuePreallocApi;
import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.util.RingItem;
import com.caucho.util.RingItemFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActorQueue<T extends RingItem>
implements ActorQueuePreallocApi<T> {
    private static final Logger log = Logger.getLogger(ActorQueue.class.getName());
    private final int _size;
    private final int _mask;
    private final T[] _itemRing;
    private final ActorWorker<? super T> _firstWorker;
    private final AtomicLong _headAllocRef = new AtomicLong();
    private final AtomicLong _headRef = new AtomicLong();
    private final AtomicLong _tailRef;
    private final AtomicBoolean _isOfferWaitRef = new AtomicBoolean();

    public ActorQueue(int capacity, RingItemFactory<T> itemFactory, ActorProcessor<? super T> ... processors) {
        int i;
        int size;
        if (processors.length < 1) {
            throw new IllegalArgumentException();
        }
        for (size = 8; size < capacity; size *= 2) {
        }
        this._size = size;
        this._mask = size - 1;
        this._itemRing = this.createRing(size);
        int processorsSize = processors.length;
        for (int j = 0; j < 8; ++j) {
            for (int i2 = 0; i2 < this._size; i2 += 8) {
                int index = i2 + j;
                this._itemRing[index] = itemFactory.createItem(index);
                if (this._itemRing[index] != null) continue;
                throw new NullPointerException();
            }
        }
        ActorConsumer prevConsumer = null;
        ActorWorker firstWorker = null;
        AtomicLong[] tails = new AtomicLong[processorsSize + 1];
        tails[0] = this._headRef;
        for (i = 0; i < processorsSize; ++i) {
            tails[i + 1] = new AtomicLong();
        }
        for (i = 0; i < processorsSize; ++i) {
            AtomicBoolean isWaitRef = null;
            if (i == processorsSize - 1) {
                isWaitRef = this._isOfferWaitRef;
            }
            AtomicLong allocRef = tails[i];
            if (i == 0) {
                allocRef = this._headAllocRef;
            }
            ActorConsumer consumer = new ActorConsumer(this, this._itemRing, processors[i], allocRef, tails[i], tails[i + 1], isWaitRef);
            ActorWorker worker = new ActorWorker(consumer);
            if (prevConsumer != null) {
                prevConsumer.setNextWorker(worker);
            }
            if (firstWorker == null) {
                firstWorker = worker;
            }
            prevConsumer = consumer;
        }
        this._tailRef = tails[tails.length - 1];
        this._firstWorker = firstWorker;
    }

    private T[] createRing(int size) {
        return new RingItem[size];
    }

    @Override
    public final boolean isEmpty() {
        return this._headRef.get() == this._tailRef.get();
    }

    @Override
    public final int getSize() {
        return (int)(this._headRef.get() - this._tailRef.get() & (long)this._mask);
    }

    @Override
    public final int getAvailable() {
        return this._size - 1 - this.getSize();
    }

    @Override
    public final void wake() {
        if (this._headAllocRef.get() != this._tailRef.get() || this._isOfferWaitRef.get()) {
            this._firstWorker.wake();
        }
    }

    @Override
    public final T startOffer(boolean isWait) {
        AtomicLong headAllocRef = this._headAllocRef;
        AtomicLong tailRef = this._tailRef;
        T[] ring = this._itemRing;
        int mask = this._mask;
        while (true) {
            long headAlloc = headAllocRef.get();
            long nextHeadAlloc = headAlloc + 1L;
            int headIndex = (int)(headAlloc & (long)mask);
            T item = ring[headIndex];
            long tail = tailRef.get();
            if (nextHeadAlloc != tail + (long)this._size) {
                if (!headAllocRef.compareAndSet(headAlloc, nextHeadAlloc)) continue;
                return item;
            }
            if (headAlloc != this._headRef.get()) {
                this.finishOffer();
                this._firstWorker.wake();
            }
            if (!isWait) {
                return null;
            }
            long timeout = 100L;
            this.waitForQueue(headAlloc, tail, timeout);
        }
    }

    @Override
    public final void finishOffer(T item) {
        long nextHead;
        long index = ((RingItem)item).nextRingValue(this._size);
        if (!this._headRef.compareAndSet(index, nextHead = index + 1L)) {
            this.finishOffer();
        }
        this._firstWorker.wake();
    }

    private final boolean finishOffer() {
        int countMax;
        int retryMax;
        AtomicLong headAllocRef = this._headAllocRef;
        AtomicLong headRef = this._headRef;
        T[] ring = this._itemRing;
        int mask = this._mask;
        long index = headRef.get();
        int retryCount = retryMax = (int)((index & 0xFL) + 1L << 4);
        int count = countMax = 4;
        while (retryCount-- >= 0) {
            long headAlloc = headAllocRef.get();
            long head = headRef.get();
            if (head == headAlloc) {
                return head != index;
            }
            if (((RingItem)ring[(int)(head & (long)mask)]).getRingValue() != head) continue;
            long nextHead = head + 1L;
            if (headRef.compareAndSet(head, nextHead) && count-- <= 0) {
                return true;
            }
            retryCount = retryMax;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueue(long headAlloc, long tail, long timeout) {
        this._firstWorker.wake();
        timeout = Math.min(100L, timeout);
        if (this._headAllocRef.get() == headAlloc && this._tailRef.get() == tail) {
            AtomicBoolean atomicBoolean = this._isOfferWaitRef;
            synchronized (atomicBoolean) {
                this._isOfferWaitRef.set(true);
                if (this._headAllocRef.get() == headAlloc && this._tailRef.get() == tail) {
                    try {
                        this._isOfferWaitRef.wait(timeout);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private T get(int index) {
        return this._itemRing[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeOfferQueue() {
        if (this._isOfferWaitRef.compareAndSet(true, false)) {
            AtomicBoolean atomicBoolean = this._isOfferWaitRef;
            synchronized (atomicBoolean) {
                this._isOfferWaitRef.notifyAll();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._firstWorker + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActorWorker<T extends RingItem>
    extends AbstractTaskWorker {
        private final ActorConsumer<T> _consumer;

        ActorWorker(ActorConsumer<T> consumer) {
            this._consumer = consumer;
        }

        @Override
        protected String getThreadName() {
            return ((ActorConsumer)this._consumer)._processor.getThreadName();
        }

        @Override
        public final long runTask() {
            ((ActorConsumer)this._consumer).consumeAll();
            return 0L;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._consumer + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActorConsumer<T extends RingItem> {
        private final ActorQueue<T> _queue;
        private final T[] _itemRing;
        private final int _mask;
        private final int _tailChunk;
        private final ActorProcessor<? super T> _processor;
        private final AtomicLong _headAllocRef;
        private final AtomicLong _headRef;
        private final AtomicLong _tailRef;
        private ActorWorker<T> _nextWorker;
        private final AtomicBoolean _isWaitRef;

        ActorConsumer(ActorQueue<T> queue, T[] ring, ActorProcessor<? super T> processor, AtomicLong headAllocRef, AtomicLong headRef, AtomicLong tailRef, AtomicBoolean isWaitRef) {
            int tailChunk;
            this._queue = queue;
            this._itemRing = ring;
            int size = this._itemRing.length;
            this._mask = size - 1;
            this._tailChunk = tailChunk = Math.min(32, Math.max(1, size >> 3));
            this._processor = processor;
            this._headAllocRef = headAllocRef;
            this._headRef = headRef;
            this._tailRef = tailRef;
            this._headAllocRef.set(size);
            this._headRef.set(size);
            this._tailRef.set(size);
            this._isWaitRef = isWaitRef;
        }

        void setNextWorker(ActorWorker<T> nextWorker) {
            this._nextWorker = nextWorker;
        }

        private final void consumeAll() {
            AtomicLong headAllocRef = this._headAllocRef;
            AtomicLong tailRef = this._tailRef;
            ActorWorker<T> nextWorker = this._nextWorker;
            do {
                try {
                    this.doConsume();
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                if (nextWorker != null) {
                    nextWorker.wake();
                }
                ((ActorQueue)this._queue).finishOffer();
                this.wakeQueue();
            } while (headAllocRef.get() != tailRef.get());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void doConsume() throws Exception {
            AtomicLong headRef = this._headRef;
            AtomicLong tailRef = this._tailRef;
            T[] itemRing = this._itemRing;
            int mask = this._mask;
            int tailChunk = this._tailChunk;
            long head = headRef.get();
            long tail = tailRef.get();
            long nextTailEnd = ActorConsumer.nextTailEnd(head, tail, tailChunk);
            ActorProcessor<T> processor = this._processor;
            try {
                while (true) {
                    if (tail != nextTailEnd) {
                        T item = itemRing[(int)(tail & (long)mask)];
                        ++tail;
                        processor.process(item);
                        continue;
                    }
                    tailRef.set(tail);
                    head = headRef.get();
                    if (head == tail) {
                        Object var15_11 = null;
                        tailRef.set(tail);
                        break;
                    }
                    nextTailEnd = ActorConsumer.nextTailEnd(head, tail, tailChunk);
                }
            }
            catch (Throwable throwable) {
                Object var15_12 = null;
                tailRef.set(tail);
                processor.onProcessComplete();
                throw throwable;
            }
            processor.onProcessComplete();
        }

        private T get(int index) {
            return this._itemRing[index];
        }

        private static long nextTailEnd(long head, long tail, int tailChunk) {
            long nextTail = tail + (long)tailChunk;
            return Math.min(head, nextTail);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeOfferWait(AtomicBoolean isWaitRef) {
            AtomicBoolean atomicBoolean = isWaitRef;
            synchronized (atomicBoolean) {
                if (isWaitRef.compareAndSet(true, false)) {
                    isWaitRef.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeQueue() {
            AtomicBoolean isWaitRef = this._isWaitRef;
            if (isWaitRef == null) {
                return;
            }
            if (isWaitRef.get()) {
                AtomicBoolean atomicBoolean = isWaitRef;
                synchronized (atomicBoolean) {
                    isWaitRef.set(false);
                    isWaitRef.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forceWakeQueue() {
            AtomicBoolean isWaitRef = this._isWaitRef;
            if (isWaitRef == null) {
                return;
            }
            AtomicBoolean atomicBoolean = isWaitRef;
            synchronized (atomicBoolean) {
                isWaitRef.set(false);
                isWaitRef.notifyAll();
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._processor + "]";
        }
    }
}

