/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployControllerApi;
import com.caucho.env.deploy.DeployMode;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployGenerator<E extends DeployControllerApi<?>>
implements Dependency,
EnvironmentListener {
    private static final Logger log = Logger.getLogger(DeployGenerator.class.getName());
    private DeployContainer<E> _container;
    private ClassLoader _parentClassLoader;
    private DeployMode _startupMode = DeployMode.AUTOMATIC;
    private DeployMode _redeployMode = DeployMode.AUTOMATIC;
    private Throwable _configException;
    private final Lifecycle _lifecycle = new Lifecycle(this.getLog());

    public DeployGenerator(DeployContainer<E> container) {
        this._parentClassLoader = Thread.currentThread().getContextClassLoader();
        this._container = container;
        this._lifecycle.setName(this.toString());
        this._lifecycle.setLevel(Level.FINEST);
    }

    public DeployContainer<E> getDeployContainer() {
        return this._container;
    }

    public ClassLoader getParentClassLoader() {
        return this._parentClassLoader;
    }

    @Configurable
    public void setStartupMode(DeployMode mode) throws ConfigException {
        this._startupMode = mode;
    }

    public DeployMode getStartupMode() throws ConfigException {
        return this._startupMode;
    }

    public void setRedeployMode(DeployMode mode) throws ConfigException {
        this._redeployMode = mode;
    }

    public DeployMode getRedeployMode() throws ConfigException {
        return this._redeployMode;
    }

    @PostConstruct
    public final void init() throws ConfigException {
        try {
            this.initImpl();
        }
        catch (RuntimeException ex) {
            this._configException = ex;
            throw ex;
        }
        this._lifecycle.setName(this.toString());
    }

    protected void initImpl() {
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean logModified(Logger log) {
        return false;
    }

    public String getState() {
        return this._lifecycle.getStateName();
    }

    public final void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (!this._lifecycle.toActive()) {
            return;
        }
        this.startImpl();
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    protected void startImpl() {
        Environment.addEnvironmentListener(this);
    }

    public void updateIfModified() {
    }

    public void update() {
    }

    protected void fillDeployedNames(Set<String> names) {
    }

    protected void generateController(String name, ArrayList<E> controllers) {
    }

    protected void mergeController(E controller, String name) {
    }

    protected Logger getLog() {
        return log;
    }

    public final void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        this.stopImpl();
    }

    protected void stopImpl() {
    }

    public Throwable getConfigException() {
        return this._configException;
    }

    public final void destroy() {
        try {
            this.stop();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this.destroyImpl();
    }

    protected void destroyImpl() {
        this._container.remove(this);
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }

    public String toString() {
        String name = this.getClass().getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            name = name.substring(p + 1);
        }
        return name + "[]";
    }
}

