/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.jpa;

import com.caucho.amber.manager.AmberPersistenceProvider;
import com.caucho.boot.ResinBootAgent;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ConfigProgram;
import com.caucho.env.jpa.EntityManagerFactoryProxy;
import com.caucho.env.jpa.EntityManagerJtaProxy;
import com.caucho.env.jpa.PersistenceManager;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitManager
implements PersistenceUnitInfo {
    private static final L10N L = new L10N(PersistenceUnitManager.class);
    private static final Logger log = Logger.getLogger(PersistenceUnitManager.class.getName());
    private final PersistenceManager _persistenceManager;
    private final String _name;
    private URL _root;
    private String _version = "2.0";
    private Class<?> _providerClass;
    private ArrayList<String> _managedClasses = new ArrayList();
    private boolean _isExcludeUnlistedClasses;
    private ArrayList<String> _mappingFiles = new ArrayList();
    private ArrayList<URL> _jarFiles = new ArrayList();
    private PersistenceUnitTransactionType _transactionType = PersistenceUnitTransactionType.JTA;
    private SharedCacheMode _sharedCacheMode = SharedCacheMode.UNSPECIFIED;
    private ValidationMode _validationMode = ValidationMode.NONE;
    private String _jtaDataSourceName;
    private DataSource _jtaDataSourceValue;
    private String _nonJtaDataSourceName;
    private DataSource _nonJtaDataSourceValue;
    private Properties _properties = new Properties();
    private String _location;
    private ConfigProgram _persistenceXmlProgram;
    private ArrayList<ConfigProgram> _overridePrograms = new ArrayList();
    private final Lifecycle _lifecycle;
    private final EntityManagerFactoryProxy _entityManagerFactoryProxy;
    private final EntityManagerJtaProxy _entityManagerJtaProxy;
    private RuntimeException _delegateException;
    private EntityManagerFactory _emfDelegate;

    PersistenceUnitManager(PersistenceManager manager, String name, PersistenceUnitTransactionType transactionType) {
        this._persistenceManager = manager;
        this._name = name;
        this._lifecycle = new Lifecycle(log, "PersistenceUnit[" + name + "]");
        this._entityManagerFactoryProxy = new EntityManagerFactoryProxy(this);
        this._transactionType = transactionType;
        this._entityManagerJtaProxy = transactionType == PersistenceUnitTransactionType.JTA ? new EntityManagerJtaProxy(this) : null;
    }

    public String getName() {
        return this._name;
    }

    public void setConfigLocation(String location) {
        if (this._location == null) {
            this._location = location;
        }
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public URL getRoot() {
        return this._root;
    }

    public void setRoot(URL url) {
        if (this._root == null) {
            this._root = url;
        } else if (!this._root.equals(url)) {
            throw new ConfigException(L.l("persistence-unit '{0}' may not change its root URL from '{1}' to '{2}'", (Object)this._name, (Object)this._root, (Object)url));
        }
    }

    public void setDescription(String description) {
    }

    public Class<?> getProvider() {
        return this._providerClass;
    }

    public void setProvider(Class<PersistenceProvider> cl) {
        Config.validate(cl, PersistenceProvider.class);
        this._providerClass = cl;
    }

    public void addClass(String className) {
        this._managedClasses.add(className);
    }

    public void setExcludeUnlistedClasses(boolean isExclude) {
        this._isExcludeUnlistedClasses = isExclude;
    }

    public void addMappingFile(String fileName) {
        this._mappingFiles.add(fileName);
    }

    public void addJarFile(String jarFile) {
        boolean isMatch = false;
        String classPath = Environment.getLocalClassPath();
        for (String pathName : classPath.split("[" + File.pathSeparatorChar + "]")) {
            if (!pathName.endsWith(jarFile)) continue;
            Path path = Vfs.lookup(pathName);
            try {
                URL url = new URL(path.getURL());
                isMatch = true;
                if (this._jarFiles.contains(url)) continue;
                this._jarFiles.add(url);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        if (!isMatch) {
            throw new ConfigException(L.l("jar-file {0} was not found on the classpath.", (Object)jarFile));
        }
    }

    public void setSharedCacheMode(String mode) {
        if ("ALL".equals(mode)) {
            this._sharedCacheMode = SharedCacheMode.ALL;
        } else if ("NONE".equals(mode)) {
            this._sharedCacheMode = SharedCacheMode.NONE;
        } else if ("ENABLE_SELECTIVE".equals(mode)) {
            this._sharedCacheMode = SharedCacheMode.ENABLE_SELECTIVE;
        } else if ("DISABLE_SELECTIVE".equals(mode)) {
            this._sharedCacheMode = SharedCacheMode.DISABLE_SELECTIVE;
        } else if ("UNSPECIFIED".equals(mode)) {
            this._sharedCacheMode = SharedCacheMode.UNSPECIFIED;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown JPA shared-cache-mode.", (Object)mode));
        }
    }

    public void setValidationMode(String mode) {
        if ("AUTO".equals(mode)) {
            this._validationMode = ValidationMode.AUTO;
        } else if ("CALLBACK".equals(mode)) {
            this._validationMode = ValidationMode.CALLBACK;
        } else if ("NONE".equals(mode)) {
            this._validationMode = ValidationMode.NONE;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown JPA validation-mode.", (Object)mode));
        }
    }

    public void setJtaDataSource(String name) {
        this._jtaDataSourceName = name;
    }

    public void setJtaDataSourceValue(DataSource dataSource) {
        this._jtaDataSourceValue = dataSource;
    }

    public void setNonJtaDataSource(String name) {
        this._nonJtaDataSourceName = name;
    }

    public void setNonJtaDataSourceValue(DataSource dataSource) {
        this._nonJtaDataSourceValue = dataSource;
    }

    public PropertiesConfig createProperties() {
        return new PropertiesConfig();
    }

    void setPersistenceXmlProgram(ConfigProgram program) {
        this._persistenceXmlProgram = program;
    }

    void addOverrideProgram(ConfigProgram program) {
        this._overridePrograms.add(program);
    }

    public EntityManagerFactory getEntityManagerFactoryDelegate() {
        this.start();
        if (this._emfDelegate == null) {
            throw new IllegalStateException(L.l("{0} does not have a valid delegate.", (Object)this));
        }
        return this._emfDelegate;
    }

    EntityManagerFactory getEntityManagerFactoryProxy() {
        return this._entityManagerFactoryProxy;
    }

    EntityManager getEntityManagerJtaProxy() {
        return this._entityManagerJtaProxy;
    }

    void start() {
        if (!this._lifecycle.toActive()) {
            if (this._delegateException != null) {
                throw this._delegateException;
            }
            return;
        }
        try {
            for (ConfigProgram program : this._persistenceManager.getPersistenceUnitDefaults()) {
                program.configure(this);
            }
            if (this._persistenceXmlProgram != null) {
                this._persistenceXmlProgram.configure(this);
            }
            for (ConfigProgram program : this._overridePrograms) {
                program.configure(this);
            }
            this.createDelegate();
            if (this._entityManagerJtaProxy != null) {
                this._entityManagerJtaProxy.init();
            }
        }
        catch (RuntimeException e) {
            this._delegateException = e;
            throw e;
        }
    }

    private void addDefaultProperty(String name, String value) {
        if (this._properties.get(name) == null) {
            this._properties.put(name, value);
        }
    }

    private void createDelegate() {
        Class<Object> cl = this.getProvider();
        if (cl == null) {
            cl = this._persistenceManager.getServiceProvider();
        }
        if (cl == null) {
            cl = AmberPersistenceProvider.class;
        }
        this.addProviderDefaultProperties(cl);
        if (log.isLoggable(Level.CONFIG)) {
            log.config("JPA PersistenceUnit[" + this.getName() + "] handled by " + cl.getName());
        }
        try {
            PersistenceProvider provider = (PersistenceProvider)cl.newInstance();
            Map map = null;
            this._emfDelegate = provider.createContainerEntityManagerFactory(this, map);
            if (log.isLoggable(Level.FINE)) {
                log.fine("JPA PersistenceUnit[" + this.getName() + "] EMF delegate is " + this._emfDelegate);
            }
            if (this._emfDelegate == null) {
                throw new IllegalStateException(L.l("{0} did not return an EntityManagerFactory", (Object)provider));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private void addProviderDefaultProperties(Class<?> cl) {
        if (cl == null) {
            return;
        }
        String className = cl.getName();
        if ("org.eclipse.persistence.jpa.PersistenceProvider".equals(className)) {
            this.addDefaultProperty("eclipselink.target-server", "org.eclipse.persistence.platform.server.resin.ResinPlatform");
        } else if ("org.hibernate.ejb.HibernatePersistence".equals(className)) {
            this.addDefaultProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.ResinTransactionManagerLookup");
        }
    }

    boolean isOpen() {
        return this._lifecycle.isActive();
    }

    void close() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._entityManagerFactoryProxy.closeImpl();
        EntityManagerFactory emfDelegate = this._emfDelegate;
        this._emfDelegate = null;
        if (emfDelegate != null) {
            emfDelegate.close();
        }
    }

    @Override
    public String getPersistenceUnitName() {
        return this._name;
    }

    @Override
    public String getPersistenceXMLSchemaVersion() {
        return this._version;
    }

    @Override
    public URL getPersistenceUnitRootUrl() {
        return this._root;
    }

    @Override
    public String getPersistenceProviderClassName() {
        if (this._providerClass != null) {
            return this._providerClass.getName();
        }
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._persistenceManager.getClassLoader();
    }

    @Override
    public List<String> getManagedClassNames() {
        return this._managedClasses;
    }

    @Override
    public boolean excludeUnlistedClasses() {
        return this._isExcludeUnlistedClasses;
    }

    @Override
    public List<URL> getJarFileUrls() {
        return this._jarFiles;
    }

    @Override
    public List<String> getMappingFileNames() {
        return this._mappingFiles;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this._sharedCacheMode;
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this._transactionType;
    }

    @Override
    public ValidationMode getValidationMode() {
        return this._validationMode;
    }

    @Override
    public DataSource getJtaDataSource() {
        if (this._jtaDataSourceValue != null) {
            return this._jtaDataSourceValue;
        }
        if (this._jtaDataSourceName != null) {
            this._jtaDataSourceValue = this.loadDataSource(this._jtaDataSourceName);
            return this._jtaDataSourceValue;
        }
        return null;
    }

    @Override
    public DataSource getNonJtaDataSource() {
        if (this._nonJtaDataSourceValue != null) {
            return this._nonJtaDataSourceValue;
        }
        if (this._nonJtaDataSourceName != null) {
            this._nonJtaDataSourceValue = this.loadDataSource(this._nonJtaDataSourceName);
            return this._nonJtaDataSourceValue;
        }
        return null;
    }

    @Override
    public Properties getProperties() {
        return this._properties;
    }

    @Override
    public void addTransformer(ClassTransformer transformer) {
        EnvironmentClassLoader loader = this._persistenceManager.getClassLoader();
        TransformerAdapter adapter = new TransformerAdapter(transformer);
        boolean isRootTransform = false;
        Instrumentation inst = ResinBootAgent.getInstrumentation();
        if (inst != null) {
            DynamicClassLoader parent = null;
            if (loader.getParent() instanceof DynamicClassLoader) {
                parent = (DynamicClassLoader)loader.getParent();
            }
            if (parent == null || parent.isRoot()) {
                inst.addTransformer(adapter);
                isRootTransform = true;
            }
        }
        if (!isRootTransform) {
            loader.addTransformer(adapter);
        }
    }

    @Override
    public ClassLoader getNewTempClassLoader() {
        EnvironmentClassLoader loader = this._persistenceManager.getClassLoader();
        return loader.getNewTempClassLoader();
    }

    private DataSource loadDataSource(String name) {
        if (name == null) {
            return null;
        }
        Named named = Names.create(name);
        InjectManager beanManager = InjectManager.create();
        Set beans = beanManager.getBeans((Type)((Object)DataSource.class), named);
        if (beans != null && beans.size() > 0) {
            return (DataSource)beanManager.getReference(beanManager.resolve(beans));
        }
        Object value = Jndi.lookup(name);
        if (value instanceof DataSource) {
            return (DataSource)value;
        }
        throw new ConfigException(L.l("{0}: name '{1}' is an unknown or unconfigured JDBC DataSource with value {2}.", (Object)this, (Object)name, value));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "," + this._emfDelegate + "]";
    }

    public static class TransformerAdapter
    implements ClassFileTransformer {
        private ClassTransformer _transformer;

        TransformerAdapter(ClassTransformer transformer) {
            this._transformer = transformer;
        }

        public byte[] transform(ClassLoader loader, String className, Class redefineClass, ProtectionDomain domain, byte[] classFileBuffer) throws IllegalClassFormatException {
            return this._transformer.transform(loader, className, redefineClass, domain, classFileBuffer);
        }
    }

    public static class PropertyConfig {
        private String _name;
        private String _value;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public String getValue() {
            return this._value;
        }
    }

    public class PropertiesConfig {
        public void addProperty(PropertyConfig prop) {
            PersistenceUnitManager.this._properties.put(prop.getName(), prop.getValue());
        }
    }
}

