/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.config.ConfigException;
import com.caucho.env.meter.AbstractMeter;
import com.caucho.jmx.Jmx;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class JmxAttributeMeter
extends AbstractMeter {
    private static final Logger log = Logger.getLogger(JmxAttributeMeter.class.getName());
    private MBeanServer _server;
    private ObjectName _objectName;
    private String _attribute;
    private boolean _isOptional;
    private double _lastSample;
    private double _value;

    public JmxAttributeMeter(String name, String objectName, String attribute, boolean isOptional) {
        super(name);
        try {
            this._objectName = new ObjectName(objectName);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        this._attribute = attribute;
        this._isOptional = isOptional;
        this._server = Jmx.getGlobalMBeanServer();
    }

    public void sample() {
        try {
            Object value = this._server.getAttribute(this._objectName, this._attribute);
            if (value == null) {
                this._value = 0.0;
                return;
            }
            this._value = ((Number)value).doubleValue();
        }
        catch (Exception e) {
            if (this.isOptional() && e instanceof InstanceNotFoundException) {
                log.log(Level.FINEST, e.toString(), e);
            } else {
                log.log(Level.FINE, e.toString(), e);
            }
            this._value = 0.0;
        }
    }

    public double calculate() {
        return this._value;
    }

    public double peek() {
        return this._value;
    }

    public boolean isOptional() {
        return this._isOptional;
    }

    public void setOptional(boolean optional) {
        this._isOptional = optional;
    }
}

