/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.TimeSensor;
import com.caucho.util.CurrentTime;
import java.util.concurrent.atomic.AtomicLong;

public final class TimeRangeMeter
extends AbstractMeter
implements TimeSensor {
    private final double _scale;
    private final AtomicLong _activeCount = new AtomicLong();
    private final AtomicLong _count = new AtomicLong();
    private final AtomicLong _time = new AtomicLong();
    private final AtomicLong _timeMax = new AtomicLong();
    private final AtomicLong _lastAvgCount = new AtomicLong();
    private final AtomicLong _lastAvgTime = new AtomicLong();
    private final AtomicLong _lastCount = new AtomicLong();
    private double _value;

    public TimeRangeMeter(String name) {
        super(name);
        this._scale = 1.0;
    }

    public AbstractMeter createCount(String name) {
        return new TimeRangeCountProbe(name);
    }

    public AbstractMeter createActiveCount(String name) {
        return new TimeRangeActiveCountProbe(name);
    }

    public AbstractMeter createMax(String name) {
        return new TimeRangeMaxProbe(name);
    }

    public final long start() {
        long startTime = CurrentTime.getCurrentTime();
        this._activeCount.incrementAndGet();
        return startTime;
    }

    public final void add(long startTime) {
        this._activeCount.decrementAndGet();
        long time = CurrentTime.getCurrentTime() - startTime;
        this._count.incrementAndGet();
        this._time.addAndGet(time);
        long max = this._timeMax.get();
        while (max < time) {
            this._timeMax.compareAndSet(max, time);
            max = this._timeMax.get();
        }
    }

    public final void sample() {
        long count = this._count.get();
        long lastCount = this._lastAvgCount.getAndSet(count);
        long time = this._time.get();
        long lastTime = this._lastAvgTime.getAndSet(time);
        this._value = count == lastCount ? 0.0 : this._scale * (double)(time - lastTime) / (double)(count - lastCount);
    }

    public final double calculate() {
        return this._value;
    }

    public final double sampleCount() {
        long count = this._count.get();
        long lastCount = this._lastCount.getAndSet(count);
        return count - lastCount;
    }

    public final double sampleMax() {
        long max = this._timeMax.getAndSet(0L);
        return this._scale * (double)max;
    }

    class TimeRangeMaxProbe
    extends AbstractMeter {
        private double _value;

        TimeRangeMaxProbe(String name) {
            super(name);
        }

        public void sample() {
            this._value = TimeRangeMeter.this.sampleMax();
        }

        public double calculate() {
            return this._value;
        }
    }

    class TimeRangeActiveCountProbe
    extends AbstractMeter {
        private double _value;

        TimeRangeActiveCountProbe(String name) {
            super(name);
        }

        public void sample() {
            this._value = TimeRangeMeter.this._activeCount.get();
        }

        public double calculate() {
            return this._value;
        }
    }

    class TimeRangeCountProbe
    extends AbstractMeter {
        private double _value;

        TimeRangeCountProbe(String name) {
            super(name);
        }

        public void sample() {
            this._value = TimeRangeMeter.this.sampleCount();
        }

        public double calculate() {
            return this._value;
        }
    }
}

