/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.repository;

import com.caucho.env.repository.LocalRepositoryService;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.LocalRepositoryMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalRepositoryAdmin
extends AbstractManagedObject
implements LocalRepositoryMXBean {
    private LocalRepositoryService _service;

    LocalRepositoryAdmin(LocalRepositoryService service) {
        this._service = service;
        this.registerSelf();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getRootHash() {
        return this._service.getRepositorySpi().getRepositoryRootHash();
    }

    @Override
    public Map<String, Map<String, String>> getTagMap() {
        Map<String, RepositoryTagEntry> tagMap = this._service.getRepositorySpi().getTagMap();
        TreeMap<String, Map<String, String>> resultMap = new TreeMap<String, Map<String, String>>();
        ArrayList<String> tags = new ArrayList<String>(tagMap.keySet());
        Collections.sort(tags);
        for (String tag : tags) {
            RepositoryTagEntry tagEntry = tagMap.get(tag);
            TreeMap<String, String> entryMap = new TreeMap<String, String>();
            resultMap.put(tag, entryMap);
            entryMap.put("root", tagEntry.getRoot());
            ArrayList<String> names = new ArrayList<String>(tagEntry.getAttributeMap().keySet());
            Collections.sort(names);
            for (String name : names) {
                entryMap.put(name, tagEntry.getAttributeMap().get(name));
            }
        }
        return resultMap;
    }
}

