/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.shutdown;

import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.warning.WarningService;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShutdownSystem
extends AbstractResinSubSystem {
    public static final int START_PRIORITY = 1;
    private static final Logger log = Logger.getLogger(ShutdownSystem.class.getName());
    private static final L10N L = new L10N(ShutdownSystem.class);
    private static final AtomicReference<ShutdownSystem> _activeService = new AtomicReference();
    private long _shutdownWaitMax = 120000L;
    private boolean _isShutdownOnOutOfMemory = true;
    private WeakReference<ResinSystem> _resinSystemRef;
    private WarningService _warningService;
    private Lifecycle _lifecycle = new Lifecycle();
    private FailSafeHaltThread _failSafeHaltThread;
    private FailSafeMemoryFreeThread _failSafeMemoryFreeThread;
    private ShutdownThread _shutdownThread;
    private boolean _isEmbedded;
    private AtomicReference<ExitCode> _exitCode = new AtomicReference();
    private ArrayList<Runnable> _memoryFreeTasks = new ArrayList();

    private ShutdownSystem(boolean isEmbedded) {
        this._isEmbedded = isEmbedded;
        this._resinSystemRef = new WeakReference<ResinSystem>(ResinSystem.getCurrent());
        this._warningService = ResinSystem.getCurrentService(WarningService.class);
        if (this._warningService == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1}", (Object)ShutdownSystem.class.getSimpleName(), (Object)WarningService.class.getSimpleName()));
        }
    }

    public static ShutdownSystem createAndAddService() {
        return ShutdownSystem.createAndAddService(CurrentTime.isTest());
    }

    public static ShutdownSystem createAndAddService(boolean isEmbedded) {
        ResinSystem system = ShutdownSystem.preCreate(ShutdownSystem.class);
        ShutdownSystem service = new ShutdownSystem(isEmbedded);
        system.addService(ShutdownSystem.class, service);
        return service;
    }

    public static ShutdownSystem getCurrent() {
        return ResinSystem.getCurrentService(ShutdownSystem.class);
    }

    public long getShutdownWaitMax() {
        return this._shutdownWaitMax;
    }

    public void setShutdownWaitTime(long shutdownTime) {
        this._shutdownWaitMax = shutdownTime;
    }

    public void setShutdownOnOutOfMemory(boolean isShutdown) {
        this._isShutdownOnOutOfMemory = isShutdown;
    }

    public boolean isShutdownOnOutOfMemory() {
        return this._isShutdownOnOutOfMemory;
    }

    public LifecycleState getLifecycleState() {
        return this._lifecycle.getState();
    }

    public ExitCode getExitCode() {
        return this._exitCode.get();
    }

    public void addMemoryFreeTask(Runnable task) {
        this._memoryFreeTasks.add(task);
    }

    public static void shutdownOutOfMemory(String msg) {
        ShutdownSystem.freeMemoryBuffers();
        ShutdownSystem shutdown = _activeService.get();
        if (shutdown != null && !shutdown.isShutdownOnOutOfMemory()) {
            System.err.println(msg);
            return;
        }
        ShutdownSystem.shutdownActive(ExitCode.MEMORY, msg);
    }

    private static void freeMemoryBuffers() {
        TempBuffer.clearFreeLists();
    }

    public static void startFailsafe(String msg) {
        ShutdownSystem shutdown = _activeService.get();
        if (shutdown != null) {
            shutdown.startFailSafeShutdown(msg);
            return;
        }
        shutdown = ShutdownSystem.getCurrent();
        if (shutdown != null) {
            shutdown.startFailSafeShutdown(msg);
            return;
        }
        log.warning("ShutdownService is not active: failsafe: " + msg);
        System.out.println("ShutdownService is not active: failsafe: " + msg);
    }

    public static void shutdownActive(ExitCode exitCode, String msg) {
        ShutdownSystem shutdown = _activeService.get();
        if (shutdown != null) {
            shutdown.shutdown(exitCode, msg);
            return;
        }
        shutdown = ShutdownSystem.getCurrent();
        if (shutdown != null) {
            shutdown.shutdown(exitCode, msg);
            return;
        }
        log.warning("ShutdownService is not active");
        System.out.println("ShutdownService is not active");
    }

    public void shutdown(ExitCode exitCode, String msg) {
        this.startFailSafeShutdown(msg);
        ShutdownThread shutdownThread = this._shutdownThread;
        if (shutdownThread != null) {
            shutdownThread.startShutdown(exitCode);
            if (!this._isEmbedded) {
                this.waitForShutdown();
                System.out.println("Shutdown timeout");
                System.exit(exitCode.ordinal());
            }
        } else {
            this.shutdownImpl(exitCode);
        }
    }

    public void startFailSafeShutdown(String msg) {
        this.startFailSafeShutdown(msg, this._shutdownWaitMax);
    }

    public void startFailSafeShutdown(String msg, long period) {
        FailSafeMemoryFreeThread memoryFreeThread;
        FailSafeHaltThread haltThread = this._failSafeHaltThread;
        if (haltThread != null) {
            haltThread.startShutdown(period);
        }
        if ((memoryFreeThread = this._failSafeMemoryFreeThread) != null) {
            memoryFreeThread.startShutdown();
        }
        try {
            this._warningService.sendWarning((Object)this, "Shutdown: " + msg);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownImpl(ExitCode exitCode) {
        FailSafeHaltThread haltThread = this._failSafeHaltThread;
        if (haltThread != null) {
            haltThread.startShutdown();
        }
        if (exitCode == null) {
            exitCode = ExitCode.FAIL_SAFE_HALT;
        }
        this._exitCode.compareAndSet(null, exitCode);
        try {
            try {
                block10: {
                    try {
                        ResinSystem resinSystem = (ResinSystem)this._resinSystemRef.get();
                        if (resinSystem == null) break block10;
                        resinSystem.destroy();
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        Object var5_6 = null;
                        this._resinSystemRef = null;
                    }
                }
                Object var5_5 = null;
                this._resinSystemRef = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this._resinSystemRef = null;
                throw throwable;
            }
            Object var7_9 = null;
            this._lifecycle.toDestroy();
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this._lifecycle.toDestroy();
            System.err.println("\nShutdown Resin reason: " + (Object)((Object)exitCode) + "\n");
            log.warning("Shutdown Resin reason: " + (Object)((Object)exitCode));
            if (!this._isEmbedded) {
                System.exit(exitCode.ordinal());
            }
            throw throwable;
        }
        System.err.println("\nShutdown Resin reason: " + (Object)((Object)exitCode) + "\n");
        log.warning("Shutdown Resin reason: " + (Object)((Object)exitCode));
        if (!this._isEmbedded) {
            System.exit(exitCode.ordinal());
        }
    }

    private ResinSystem getResinSystem() {
        WeakReference<ResinSystem> resinSystemRef = this._resinSystemRef;
        if (resinSystemRef != null) {
            return (ResinSystem)resinSystemRef.get();
        }
        return null;
    }

    public void dumpThreads() {
    }

    public int getStartPriority() {
        return 1;
    }

    public void start() {
        this._lifecycle.toActive();
        this._exitCode.set(null);
        if (!this._isEmbedded) {
            _activeService.set(this);
        }
        if (!CurrentTime.isTest() && !this._isEmbedded) {
            this._failSafeHaltThread = new FailSafeHaltThread();
            this._failSafeHaltThread.start();
            this._failSafeMemoryFreeThread = new FailSafeMemoryFreeThread();
            this._failSafeMemoryFreeThread.start();
        }
        if (!this._isEmbedded) {
            this._shutdownThread = new ShutdownThread();
            this._shutdownThread.setDaemon(true);
            this._shutdownThread.start();
        }
    }

    public void stop() {
        ShutdownThread shutdownThread;
        FailSafeMemoryFreeThread memoryFreeThread;
        this._lifecycle.toDestroy();
        _activeService.set(null);
        FailSafeHaltThread failSafeThread = this._failSafeHaltThread;
        if (failSafeThread != null) {
            failSafeThread.wake();
        }
        if ((memoryFreeThread = this._failSafeMemoryFreeThread) != null) {
            memoryFreeThread.startShutdown();
        }
        if ((shutdownThread = this._shutdownThread) != null) {
            shutdownThread.wake();
        }
    }

    public void destroy() {
        this._lifecycle.toDestroy();
    }

    private void waitForShutdown() {
        this.waitForShutdown(-1L);
    }

    private void waitForShutdown(long period) {
        long now;
        if (period <= 0L) {
            period = this._shutdownWaitMax;
        }
        long expire = System.currentTimeMillis() + period;
        while ((now = System.currentTimeMillis()) < expire) {
            try {
                Thread.interrupted();
                Thread.sleep(expire - now);
            }
            catch (Exception e) {}
        }
    }

    public String toString() {
        ResinSystem resinSystem = this.getResinSystem();
        if (resinSystem != null) {
            return this.getClass().getSimpleName() + "[id=" + resinSystem.getId() + "]";
        }
        return this.getClass().getSimpleName() + "[closed]";
    }

    class FailSafeHaltThread
    extends Thread {
        private volatile boolean _isShutdown;
        private volatile long _period = -1L;

        FailSafeHaltThread() {
            this.setName("resin-fail-safe-halt");
            this.setDaemon(true);
        }

        void startShutdown() {
            this.startShutdown(-1L);
        }

        void startShutdown(long period) {
            this._isShutdown = true;
            this._period = period;
            this.wake();
        }

        void wake() {
            LockSupport.unpark(this);
        }

        public void run() {
            while (!this._isShutdown && ShutdownSystem.this._lifecycle.isActive()) {
                try {
                    Thread.interrupted();
                    LockSupport.park();
                }
                catch (Exception exception) {}
            }
            if (!ShutdownSystem.this._lifecycle.isActive()) {
                return;
            }
            ShutdownSystem.this.waitForShutdown(this._period);
            if (ShutdownSystem.this._lifecycle.isActive()) {
                Runtime.getRuntime().halt(ExitCode.FAIL_SAFE_HALT.ordinal());
            }
        }
    }

    class FailSafeMemoryFreeThread
    extends Thread {
        private volatile boolean _isShutdown;

        FailSafeMemoryFreeThread() {
            this.setName("resin-fail-safe-memory-free");
            this.setDaemon(true);
        }

        void startShutdown() {
            this._isShutdown = true;
            LockSupport.unpark(this);
        }

        public void run() {
            while (!this._isShutdown && ShutdownSystem.this._lifecycle.isActive()) {
                try {
                    Thread.interrupted();
                    LockSupport.park();
                }
                catch (Exception e) {}
            }
            for (int i = 0; i < ShutdownSystem.this._memoryFreeTasks.size(); ++i) {
                Runnable task = (Runnable)ShutdownSystem.this._memoryFreeTasks.get(i);
                try {
                    task.run();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!ShutdownSystem.this._lifecycle.isActive()) {
                return;
            }
        }
    }

    class ShutdownThread
    extends Thread {
        private AtomicReference<ExitCode> _shutdownExitCode = new AtomicReference();

        ShutdownThread() {
            this.setName("resin-shutdown");
            this.setDaemon(true);
        }

        void startShutdown(ExitCode exitCode) {
            this._shutdownExitCode.compareAndSet(null, exitCode);
            this.wake();
        }

        void wake() {
            LockSupport.unpark(this);
        }

        public void run() {
            while (this._shutdownExitCode.get() == null && ShutdownSystem.this._lifecycle.isActive() && _activeService.get() == ShutdownSystem.this) {
                try {
                    Thread.interrupted();
                    LockSupport.park();
                }
                catch (Exception e) {}
            }
            ExitCode exitCode = this._shutdownExitCode.get();
            if (exitCode != null) {
                ShutdownSystem.this.shutdownImpl(exitCode);
            }
        }
    }
}

