/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread2;

import com.caucho.env.thread.TaskWorker;
import com.caucho.env.warning.WarningService;
import com.caucho.loader.Environment;
import com.caucho.util.CurrentTime;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTaskWorker2
implements Runnable,
TaskWorker,
Closeable {
    private static Logger _log;
    private static final int TASK_PARK = 0;
    private static final int TASK_SLEEP = 1;
    private static final int TASK_READY = 2;
    private static final long PERMANENT_TIMEOUT = 30000L;
    private static final AtomicLong _idGen;
    private final AtomicInteger _taskState = new AtomicInteger();
    private final AtomicBoolean _isActive = new AtomicBoolean();
    private final WeakReference<ClassLoader> _classLoaderRef;
    private String _threadName;
    private long _workerIdleTimeout = 500L;
    private boolean _isClosed;
    private volatile Thread _thread;

    protected AbstractTaskWorker2(ClassLoader classLoader) {
        this._classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        Environment.addWeakCloseListener(this, classLoader);
    }

    protected boolean isPermanent() {
        return false;
    }

    protected void setWorkerIdleTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        this._workerIdleTimeout = timeout;
    }

    public final boolean isTaskActive() {
        return this._isActive.get();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    protected ClassLoader getClassLoader() {
        return (ClassLoader)this._classLoaderRef.get();
    }

    public abstract long runTask();

    public void close() {
        this._isClosed = true;
        this.wake();
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public final void wake() {
        Thread thread;
        int oldState = this._taskState.getAndSet(2);
        if (this._isActive.compareAndSet(false, true)) {
            this.startWorkerThread();
        }
        if (oldState == 0 && (thread = this._thread) != null) {
            this.unpark(thread);
        }
    }

    protected abstract void startWorkerThread();

    protected void unpark(Thread thread) {
        LockSupport.unpark(thread);
    }

    protected String getThreadName() {
        if (this._threadName == null) {
            this._threadName = this.toString() + "-" + _idGen.incrementAndGet();
        }
        return this._threadName;
    }

    protected void onThreadStart() {
    }

    protected void onThreadComplete() {
    }

    private long getIdleTimeout() {
        if (this.isPermanent()) {
            return 30000L;
        }
        return this._workerIdleTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        Thread thread = Thread.currentThread();
        String oldName = thread.getName();
        try {
            try {
                this._thread = thread;
                thread.setContextClassLoader(this.getClassLoader());
                thread.setName(this.getThreadName());
                this.onThreadStart();
                long now = this.getCurrentTimeActual();
                long idleTimeout = this.getIdleTimeout();
                long expires = idleTimeout > 0L ? now + idleTimeout : 0L;
                boolean isExpireRetry = false;
                do {
                    isExpireRetry = false;
                    while (this._taskState.getAndSet(1) == 2 && !this.isClosed()) {
                        thread.setContextClassLoader(this.getClassLoader());
                        isExpireRetry = false;
                        long delta = this.runTask();
                        now = this.getCurrentTimeActual();
                        if (delta > 0L) {
                            expires = now + delta;
                            isExpireRetry = true;
                            continue;
                        }
                        if (idleTimeout > 0L) {
                            expires = now + idleTimeout;
                            continue;
                        }
                        expires = 0L;
                    }
                    if (this.isClosed()) {
                        Object var13_9 = null;
                        this._thread = null;
                        this._isActive.set(false);
                        this.onThreadComplete();
                        if (this._taskState.get() == 2) {
                            this.wake();
                        }
                        thread.setName(oldName);
                        return;
                    }
                    if (expires > 0L && this._taskState.compareAndSet(1, 0)) {
                        Thread.interrupted();
                        LockSupport.parkUntil(expires);
                    }
                    if (!this.isPermanent() && !isExpireRetry) continue;
                    expires = this.getCurrentTimeActual() + idleTimeout;
                    this._taskState.set(2);
                } while (this._taskState.get() == 2 || this.isPermanent() || isExpireRetry || this.getCurrentTimeActual() < expires);
            }
            catch (Throwable e) {
                System.out.println("EXN: " + e);
                WarningService.sendCurrentWarning((Object)this, e);
                this.log().log(Level.WARNING, e.toString(), e);
                Object var13_11 = null;
                this._thread = null;
                this._isActive.set(false);
                this.onThreadComplete();
                if (this._taskState.get() == 2) {
                    this.wake();
                }
                thread.setName(oldName);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            this._thread = null;
            this._isActive.set(false);
            this.onThreadComplete();
            if (this._taskState.get() == 2) {
                this.wake();
            }
            thread.setName(oldName);
            throw throwable;
        }
        Object var13_10 = null;
        this._thread = null;
        this._isActive.set(false);
        this.onThreadComplete();
        if (this._taskState.get() == 2) {
            this.wake();
        }
        thread.setName(oldName);
    }

    protected long getCurrentTimeActual() {
        return CurrentTime.getCurrentTimeActual();
    }

    private Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(AbstractTaskWorker2.class.getName());
        }
        return _log;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static {
        _idGen = new AtomicLong();
    }
}

