/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread2;

import com.caucho.env.health.HealthSystemFacade;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.env.thread2.AbstractThreadLauncher2;
import com.caucho.env.thread2.ResinThread2;
import com.caucho.env.thread2.ThreadPool2;
import com.caucho.inject.Module;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;

@Module
class ThreadLauncher2
extends AbstractThreadLauncher2 {
    private static final Logger log = Logger.getLogger(ThreadLauncher2.class.getName());
    public static final String THREAD_FULL_EVENT = "caucho.thread.pool.full";
    public static final String THREAD_CREATE_THROTTLE_EVENT = "caucho.thread.pool.throttle";
    private final ThreadPool2 _pool;

    ThreadLauncher2(ThreadPool2 pool) {
        super(ClassLoader.getSystemClassLoader());
        this._pool = pool;
    }

    public final boolean isPermanent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void startWorkerThread() {
        boolean isValid = false;
        try {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("resin-thread-launcher2");
            thread.start();
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (isValid) throw throwable;
            ShutdownSystem.shutdownActive(ExitCode.THREAD, "Cannot create ThreadPool thread.");
            throw throwable;
        }
    }

    protected long getCurrentTimeActual() {
        return System.currentTimeMillis();
    }

    protected void launchChildThread(int id) {
        try {
            ResinThread2 poolThread = new ResinThread2(id, this._pool, this);
            poolThread.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
            String msg = "Resin exiting because of failed thread";
            ShutdownSystem.shutdownActive(ExitCode.THREAD, msg);
        }
    }

    protected void unpark(Thread thread) {
        LockSupport.unpark(thread);
    }

    protected void onThreadMax() {
        HealthSystemFacade.fireEvent(THREAD_FULL_EVENT, "threads=" + this.getThreadCount());
    }

    protected void onThrottle(String msg) {
        log.warning(msg);
        HealthSystemFacade.fireEvent(THREAD_CREATE_THROTTLE_EVENT, msg);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._pool + "]";
    }
}

