/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread2;

import com.caucho.env.health.HealthSystemFacade;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.env.thread2.AbstractTaskWorker2;
import com.caucho.env.thread2.ResinThread2;
import com.caucho.env.thread2.ThreadLauncher2;
import com.caucho.env.thread2.ThreadTaskRing2;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.CurrentTime;
import com.caucho.util.Friend;
import com.caucho.util.L10N;
import com.caucho.util.RingValueQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPool2
implements Executor {
    private static final L10N L = new L10N(ThreadPool2.class);
    private static final Logger log = Logger.getLogger(ThreadPool2.class.getName());
    public static final String THREAD_FULL_EVENT = "caucho.thread.schedule.full";
    private static final long MAX_EXPIRE = 0x3FFFFFFFFFFFFFFFL;
    private static final long PRIORITY_TIMEOUT = 10L;
    private static final int PRIORITY_IDLE_MIN = 2;
    private static final int THREAD_IDLE_MIN = 16;
    private static final int THREAD_IDLE_MAX = 1024;
    private static final int THREAD_THROTTLE_LIMIT = 100;
    private static final long THREAD_THROTTLE_SLEEP = 10L;
    private static final AtomicReference<ThreadPool2> _globalThreadPool = new AtomicReference();
    private final String _name;
    private final ThreadLauncher2 _launcher;
    private final Lifecycle _lifecycle = new Lifecycle();
    private final ThreadScheduleWorker _scheduleWorker = new ThreadScheduleWorker();
    private int _idleMin = 16;
    private int _idleMax = 1024;
    private int _priorityIdleMin = 2;
    private final AtomicLong _resetCount = new AtomicLong();
    private final AtomicLong _overflowCount = new AtomicLong();
    private final RingValueQueue<ResinThread2> _idleThreadRing = new RingValueQueue(8192);
    private final ThreadTaskRing2 _taskQueue = new ThreadTaskRing2();
    private final ThreadTaskRing2 _priorityQueue = new ThreadTaskRing2();
    private final RingValueQueue<Thread> _unparkQueue = new RingValueQueue(1024);
    private int _waitCount;

    public ThreadPool2() {
        this("system");
    }

    public ThreadPool2(String name) {
        this._name = name;
        this._launcher = new ThreadLauncher2(this);
        this._launcher.setIdleMax(1026);
        this._launcher.setIdleMin(18);
        this._launcher.setThrottleLimit(100);
        this._launcher.setThrottleSleepTime(10L);
        this.init();
    }

    public static ThreadPool2 getCurrent() {
        ThreadPool2 threadPool = _globalThreadPool.get();
        if (threadPool != null) {
            throw new IllegalStateException();
        }
        return threadPool;
    }

    protected void setAsGlobal(ThreadPool2 pool) {
        _globalThreadPool.set(pool);
    }

    public void setThreadMax(int max) {
        this._launcher.setThreadMax(max);
    }

    public int getThreadMax() {
        return this._launcher.getThreadMax();
    }

    public void setIdleMin(int min) {
        if (min < 1) {
            throw new IllegalArgumentException(L.l("idle-min must be greater than zero."));
        }
        if (this._idleMax <= min) {
            throw new IllegalArgumentException(L.l("idle-min '{0}' must be less than idle-max '{1}'.", min, this._idleMax));
        }
        this._idleMin = min;
        this._launcher.setIdleMin(this._idleMin + this._priorityIdleMin);
    }

    public int getIdleMin() {
        return this._idleMin;
    }

    public int getIdleMax() {
        return this._idleMax;
    }

    public void setIdleMax(int idleMax) {
        if (idleMax <= this._idleMin) {
            throw new IllegalArgumentException(L.l("idle-max '{0}' must be greater than idle-min '{1}'.", idleMax, this._idleMin));
        }
        this._launcher.setIdleMax(this._idleMax + this._priorityIdleMin);
    }

    public void setPriorityIdleMin(int min) {
        if (min < 0) {
            throw new IllegalArgumentException(L.l("priority-idle-min '{0}' must be greater than zero.", min));
        }
        this._priorityIdleMin = min;
        this._launcher.setIdleMax(this._idleMax + this._priorityIdleMin);
        this._launcher.setIdleMin(this._idleMin + this._priorityIdleMin);
    }

    public int getPriorityIdleMin() {
        return this._priorityIdleMin;
    }

    public void setIdleTimeout(long timeout) {
        this._launcher.setIdleTimeout(timeout);
    }

    public long getIdleTimeout() {
        return this._launcher.getIdleTimeout();
    }

    public void setThrottlePeriod(long period) {
        this._launcher.setThrottlePeriod(period);
    }

    public void setThrottleLimit(int limit) {
        this._launcher.setThrottleLimit(limit);
    }

    public void setThrottleSleepTime(long period) {
        this._launcher.setThrottleSleepTime(period);
    }

    public int getThreadCount() {
        return this._launcher.getThreadCount();
    }

    public int getThreadActiveCount() {
        return this.getThreadCount() - this.getThreadIdleCount();
    }

    public int getThreadStartingCount() {
        return this._launcher.getStartingCount();
    }

    public int getThreadIdleCount() {
        return this._launcher.getIdleCount();
    }

    public int getThreadWaitCount() {
        return this._waitCount;
    }

    public int getFreeThreadCount() {
        return this.getThreadMax() - this.getThreadCount() - this._launcher.getStartingCount();
    }

    public long getThreadCreateCountTotal() {
        return this._launcher.getCreateCountTotal();
    }

    public long getThreadOverflowCountTotal() {
        return this._overflowCount.get();
    }

    public int getThreadPriorityQueueSize() {
        return this._priorityQueue.getSize();
    }

    public int getThreadTaskQueueSize() {
        return this._taskQueue.getSize();
    }

    private void init() {
        this.update();
    }

    private void update() {
        this._launcher.update();
    }

    public void start() {
        this._launcher.start();
    }

    public void execute(Runnable task) {
        this.schedule(task);
    }

    public boolean schedule(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = true;
        boolean isWake = true;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue, isWake);
    }

    public boolean schedule(Runnable task, ClassLoader loader) {
        boolean isPriority = false;
        boolean isQueue = true;
        boolean isWake = true;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue, isWake);
    }

    public boolean schedule(Runnable task, long timeout) {
        long expire = timeout < 0L || 0x3FFFFFFFFFFFFFFFL < timeout ? 0x3FFFFFFFFFFFFFFFL : CurrentTime.getCurrentTimeActual() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = true;
        boolean isWake = true;
        return this.scheduleImpl(task, loader, expire, isPriority, isQueue, isWake);
    }

    public void schedulePriority(Runnable task) {
        boolean isWake;
        boolean isQueue;
        boolean isPriority;
        long expire;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!this.scheduleImpl(task, loader, expire = CurrentTime.getCurrentTimeActual() + 10L, isPriority = true, isQueue = true, isWake = true)) {
            String msg = this + " unable to schedule priority thread " + task + " pri-min=" + this.getPriorityIdleMin() + " thread=" + this.getThreadCount() + " idle=" + this.getThreadIdleCount() + " starting=" + this.getThreadStartingCount() + " max=" + this.getThreadMax();
            log.warning(msg);
            OverflowThread item = new OverflowThread(task);
            item.start();
            HealthSystemFacade.fireEvent(THREAD_FULL_EVENT, msg);
        }
    }

    public boolean start(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = false;
        boolean isWake = true;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue, isWake);
    }

    public boolean start(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : CurrentTime.getCurrentTimeActual() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = false;
        boolean isWake = true;
        return this.scheduleImpl(task, loader, expire, isPriority, isQueue, isWake);
    }

    public void startPriority(Runnable task) {
        boolean isWake;
        boolean isQueue;
        boolean isPriority;
        long expire;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!this.scheduleImpl(task, loader, expire = CurrentTime.getCurrentTimeActual() + 10L, isPriority = true, isQueue = true, isWake = true)) {
            String msg = this + " unable to start priority thread " + task + " pri-min=" + this.getPriorityIdleMin() + " thread=" + this.getThreadCount() + " idle=" + this.getThreadIdleCount() + " starting=" + this.getThreadStartingCount() + " max=" + this.getThreadMax();
            log.warning(msg);
            HealthSystemFacade.fireEvent(THREAD_FULL_EVENT, msg);
            OverflowThread item = new OverflowThread(task);
            item.start();
        }
    }

    public boolean startPriority(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : CurrentTime.getCurrentTimeActual() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = true;
        boolean isQueue = false;
        boolean isWake = true;
        return this.scheduleImpl(task, loader, expire, isPriority, isQueue, isWake);
    }

    public boolean submitNoWake(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = true;
        boolean isWake = false;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue, isWake);
    }

    public boolean submitNoWake(Runnable task, ClassLoader loader) {
        boolean isPriority = false;
        boolean isQueue = true;
        boolean isWake = false;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue, isWake);
    }

    protected boolean scheduleImpl(Runnable task, ClassLoader loader, long expireTime, boolean isPriority, boolean isQueueIfFull, boolean isWakeScheduler) {
        if (isPriority) {
            if (!this._priorityQueue.offer(task, loader)) {
                System.out.println("PRIORITY_FULL");
                return false;
            }
        } else if (!this._taskQueue.offer(task, loader)) {
            System.out.println("TASK_FULL");
            return false;
        }
        if (isWakeScheduler) {
            this.wakeScheduler();
        }
        return true;
    }

    @Friend(value=ResinThread2.class)
    boolean execute(ResinThread2 thread) {
        if (this._priorityQueue.takeAndSchedule(thread)) {
            return true;
        }
        if (this.getPriorityIdleMin() < this._launcher.getIdleCount() && this._taskQueue.takeAndSchedule(thread)) {
            return true;
        }
        if (!this._idleThreadRing.put(thread)) {
            System.out.println("NOFREE: " + thread);
        }
        if (!this._priorityQueue.isEmpty() || !this._taskQueue.isEmpty()) {
            this.wakeScheduler();
        }
        return false;
    }

    public void wakeScheduler() {
        this._scheduleWorker.wake();
    }

    public final void scheduleUnpark(Thread thread) {
        LockSupport.unpark(thread);
    }

    boolean isActive() {
        return this._lifecycle.isActive();
    }

    public void reset() {
        this._resetCount.incrementAndGet();
    }

    public void closeEnvironment(ClassLoader env) {
        this.reset();
    }

    public void clearIdleThreads() {
        ResinThread2 thread;
        while ((thread = this._idleThreadRing.poll()) != null) {
            thread.close();
        }
    }

    public void close() {
        if (this == _globalThreadPool.get()) {
            throw new IllegalStateException(L.l("Cannot close global thread pool"));
        }
        this._lifecycle.toDestroy();
        this._launcher.close();
        this._scheduleWorker.close();
        this.clearIdleThreads();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }

    class ThreadScheduleWorker
    extends AbstractTaskWorker2 {
        ThreadScheduleWorker() {
            super(ThreadScheduleWorker.class.getClassLoader());
        }

        public boolean isPermanent() {
            return true;
        }

        public long runTask() {
            int loopCount = 2;
            for (int i = 0; i <= loopCount; ++i) {
                while (this.invoke()) {
                    i = -1;
                }
            }
            return 1000L;
        }

        private boolean invoke() {
            boolean isInvoke = false;
            if (this.invokePriorityQueue()) {
                isInvoke = true;
            } else if (this.invokeIdleQueue()) {
                isInvoke = true;
            }
            if (this.invokeUnpark()) {
                isInvoke = true;
            }
            return isInvoke;
        }

        private boolean invokeUnpark() {
            Thread thread = (Thread)ThreadPool2.this._unparkQueue.poll();
            if (thread != null) {
                LockSupport.unpark(thread);
                return true;
            }
            return false;
        }

        private boolean invokePriorityQueue() {
            if (ThreadPool2.this._priorityQueue.isEmpty()) {
                return false;
            }
            ResinThread2 thread = (ResinThread2)ThreadPool2.this._idleThreadRing.poll();
            if (thread == null) {
                ThreadPool2.this._launcher.wake();
                return true;
            }
            if (ThreadPool2.this._priorityQueue.takeAndSchedule(thread)) {
                thread.unpark();
                return true;
            }
            ThreadPool2.this._idleThreadRing.put(thread);
            return false;
        }

        private boolean invokeIdleQueue() {
            if (ThreadPool2.this._taskQueue.isEmpty()) {
                return false;
            }
            if (ThreadPool2.this._launcher.getIdleCount() <= ThreadPool2.this.getPriorityIdleMin()) {
                ThreadPool2.this._launcher.wake();
                return true;
            }
            ResinThread2 thread = (ResinThread2)ThreadPool2.this._idleThreadRing.poll();
            if (thread == null) {
                ThreadPool2.this._launcher.wake();
                return true;
            }
            if (ThreadPool2.this._taskQueue.takeAndSchedule(thread)) {
                thread.unpark();
                return true;
            }
            ThreadPool2.this._idleThreadRing.put(thread);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void startWorkerThread() {
            boolean isValid = false;
            try {
                Thread thread = new Thread(this);
                thread.setDaemon(true);
                thread.setName("resin-thread-scheduler");
                thread.start();
                return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (isValid) throw throwable;
                ShutdownSystem.shutdownActive(ExitCode.THREAD, "Cannot create ThreadPool thread.");
                throw throwable;
            }
        }

        protected void unpark(Thread thread) {
            LockSupport.unpark(thread);
        }
    }

    final class OverflowThread
    extends Thread {
        private Runnable _task;
        private ClassLoader _loader;

        OverflowThread(Runnable task) {
            super("resin-overflow-" + task.getClass().getSimpleName());
            this.setDaemon(true);
            this._task = task;
            this._loader = Thread.currentThread().getContextClassLoader();
        }

        public void run() {
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(this._loader);
            try {
                ThreadPool2.this._overflowCount.incrementAndGet();
                this._task.run();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

