/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import java.io.IOException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.transaction.UserTransaction;

public class TransactionFilter
implements Filter {
    private UserTransaction _userTransaction;

    public void init(FilterConfig config) throws ServletException {
        try {
            InitialContext ic = new InitialContext();
            this._userTransaction = (UserTransaction)ic.lookup("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            throw new ServletException(e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        try {
            this._userTransaction.begin();
            nextFilter.doFilter(request, response);
            this._userTransaction.commit();
        }
        catch (ServletException e) {
            this.rollback();
            throw e;
        }
        catch (IOException e) {
            this.rollback();
            throw e;
        }
        catch (RuntimeException e) {
            this.rollback();
            throw e;
        }
        catch (Throwable e) {
            this.rollback();
            throw new ServletException(e);
        }
    }

    private void rollback() throws ServletException {
        try {
            this._userTransaction.rollback();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
    }
}

