/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.Actor;
import com.caucho.bam.actor.ActorHolder;
import com.caucho.bam.broker.AbstractManagedBroker;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.mailbox.MultiworkerMailbox;
import com.caucho.bam.mailbox.PassthroughMailbox;
import com.caucho.bam.manager.BamManager;
import com.caucho.bam.manager.SimpleBamManager;
import com.caucho.bam.packet.Message;
import com.caucho.bam.packet.MessageError;
import com.caucho.bam.packet.Packet;
import com.caucho.bam.packet.Query;
import com.caucho.bam.packet.QueryError;
import com.caucho.bam.packet.QueryResult;
import com.caucho.bam.proxy.ProxyActor;
import com.caucho.config.inject.InjectManager;
import com.caucho.env.service.AfterResinStartListener;
import com.caucho.env.service.ResinSystem;
import com.caucho.hemp.broker.DomainManager;
import com.caucho.hemp.broker.HempBrokerManager;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.remote.BamService;
import com.caucho.server.admin.AdminService;
import com.caucho.util.Base64;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HempBroker
extends AbstractManagedBroker {
    private static final Logger log = Logger.getLogger(HempBroker.class.getName());
    private static final L10N L = new L10N(HempBroker.class);
    private static final EnvironmentLocal<HempBroker> _localBroker = new EnvironmentLocal();
    private final AtomicLong _addressGenerator = new AtomicLong(CurrentTime.getCurrentTime());
    private HempBrokerManager _manager;
    private DomainManager _domainManager;
    private BamManager _bamManager;
    private final ConcurrentHashMap<String, WeakReference<Mailbox>> _actorStreamMap = new ConcurrentHashMap();
    private final HashMap<String, Mailbox> _actorMap = new HashMap();
    private final Map<String, WeakReference<Mailbox>> _actorCache = Collections.synchronizedMap(new HashMap());
    private String _domain = "localhost";
    private String _managerAddress = "localhost";
    private ArrayList<String> _aliasList = new ArrayList();
    private ArrayList<Packet> _startupPacketList = new ArrayList();
    private ResinSystem _resinSystem;
    private volatile boolean _isClosed;

    public HempBroker(HempBrokerManager manager) {
        this._resinSystem = manager.getResinSystem();
        this._manager = manager;
        this._bamManager = new SimpleBamManager(this);
        Environment.addCloseListener(this);
        if (_localBroker.getLevel() == null) {
            _localBroker.set(this);
        }
        if (this._resinSystem != null) {
            this._resinSystem.addListener(new AfterStartListener(this));
        }
    }

    public HempBroker(HempBrokerManager manager, String domain) {
        this(manager);
        this._domain = domain;
        this._managerAddress = domain;
    }

    public static HempBroker getCurrent() {
        return _localBroker.get();
    }

    public BamManager getBamManager() {
        return this._bamManager;
    }

    public void setDomainManager(DomainManager domainManager) {
        this._domainManager = domainManager;
    }

    @Override
    public boolean isClosed() {
        return this._isClosed;
    }

    public void addAlias(String domain) {
        this._aliasList.add(domain);
    }

    public void afterStart() {
        this.deliverStartupPackets();
        ArrayList<Packet> deadPackets = new ArrayList<Packet>(this._startupPacketList);
        this._startupPacketList.clear();
        for (Packet packet : deadPackets) {
            packet.dispatch(this, this);
        }
    }

    protected String generateAddress(String uid, String resource) {
        StringBuilder sb = new StringBuilder();
        if (uid == null) {
            uid = "anonymous";
        }
        if (uid.indexOf(64) > 0) {
            sb.append(uid);
        } else {
            sb.append(uid).append('@').append(this.getDomain());
        }
        sb.append("/");
        if (resource != null) {
            sb.append(resource);
        } else {
            Base64.encode(sb, this._addressGenerator.incrementAndGet());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMailbox(String address, Mailbox mailbox) {
        AbstractMap abstractMap = this._actorMap;
        synchronized (abstractMap) {
            Mailbox oldMailbox = this._actorMap.get(address);
            if (oldMailbox != null) {
                throw new IllegalStateException(L.l("duplicated address='{0}' is not allowed", (Object)address));
            }
            this._actorMap.put(address, mailbox);
        }
        abstractMap = this._actorStreamMap;
        synchronized (abstractMap) {
            WeakReference<Mailbox> oldRef = this._actorStreamMap.get(address);
            if (oldRef != null && oldRef.get() != null) {
                throw new IllegalStateException(L.l("duplicated address='{0}' is not allowed", (Object)address));
            }
            this._actorStreamMap.put(address, new WeakReference<Mailbox>(mailbox));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " addMailbox address=" + address + " " + mailbox);
        }
        if (this.isBeforeActive()) {
            this.deliverStartupPackets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMailbox(Mailbox mailbox) {
        String address = mailbox.getAddress();
        AbstractMap abstractMap = this._actorMap;
        synchronized (abstractMap) {
            this._actorMap.remove(address);
        }
        abstractMap = this._actorStreamMap;
        synchronized (abstractMap) {
            this._actorStreamMap.remove(address);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " removeActor address=" + address + " " + mailbox);
        }
    }

    protected String getManagerAddress() {
        return this._managerAddress;
    }

    protected String getDomain() {
        return this._domain;
    }

    @Override
    public String getAddress() {
        return this._domain;
    }

    private boolean isBeforeActive() {
        if (this._resinSystem != null) {
            return this._resinSystem.isBeforeActive();
        }
        return false;
    }

    @Override
    public void message(String to, String from, Serializable payload) {
        Mailbox mailbox = this.getMailbox(to);
        if (mailbox != null) {
            mailbox.message(to, from, payload);
            return;
        }
        if (!this.isBeforeActive() || !this.addStartupPacket(new Message(to, from, payload))) {
            super.message(to, from, payload);
        }
    }

    @Override
    public void messageError(String to, String from, Serializable payload, BamError error) {
        Mailbox mailbox = this.getMailbox(to);
        if (mailbox != null) {
            mailbox.messageError(to, from, payload, error);
            return;
        }
        if (!this.isBeforeActive() || !this.addStartupPacket(new MessageError(to, from, payload, error))) {
            super.messageError(to, from, payload, error);
        }
    }

    @Override
    public void query(long id, String to, String from, Serializable payload) {
        Mailbox mailbox = this.getMailbox(to);
        if (mailbox != null) {
            mailbox.query(id, to, from, payload);
            return;
        }
        if (!this.isBeforeActive() || !this.addStartupPacket(new Query(id, to, from, payload))) {
            super.query(id, to, from, payload);
        }
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable payload) {
        Mailbox mailbox = this.getMailbox(to);
        if (mailbox != null) {
            mailbox.queryResult(id, to, from, payload);
            return;
        }
        if (!this.isBeforeActive() || !this.addStartupPacket(new QueryResult(id, to, from, payload))) {
            super.queryResult(id, to, from, payload);
        }
    }

    @Override
    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        Mailbox mailbox = this.getMailbox(to);
        if (mailbox != null) {
            mailbox.queryError(id, to, from, payload, error);
            return;
        }
        if (!this.isBeforeActive() || !this.addStartupPacket(new QueryError(id, to, from, payload, error))) {
            super.queryError(id, to, from, payload, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addStartupPacket(Packet packet) {
        ArrayList<Packet> arrayList = this._startupPacketList;
        synchronized (arrayList) {
            this._startupPacketList.add(packet);
        }
        this.deliverStartupPackets();
        return true;
    }

    private void deliverStartupPackets() {
        Packet packet;
        while ((packet = this.extractStartupPacket()) != null) {
            Mailbox mailbox = this.getMailbox(packet.getTo());
            if (mailbox != null) {
                packet.dispatch(mailbox, this);
                continue;
            }
            log.warning(this + " failed to find mailbox " + packet.getTo() + " for " + packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet extractStartupPacket() {
        ArrayList<Packet> arrayList = this._startupPacketList;
        synchronized (arrayList) {
            int size = this._startupPacketList.size();
            for (int i = 0; i < size; ++i) {
                Packet packet = this._startupPacketList.get(i);
                Mailbox mailbox = this.getMailbox(packet.getTo());
                if (mailbox == null) continue;
                this._startupPacketList.remove(i);
                return packet;
            }
        }
        return null;
    }

    @Override
    public Mailbox getMailbox(String address) {
        Mailbox mailbox;
        if (address == null) {
            return null;
        }
        WeakReference<Mailbox> ref = this._actorStreamMap.get(address);
        if (ref != null && (mailbox = (Mailbox)ref.get()) != null) {
            return mailbox;
        }
        if (address.endsWith("@")) {
            address = address + this.getDomain();
        }
        return this.putActorStream(address, this.findDomain(address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mailbox putActorStream(String address, Mailbox actorStream) {
        if (actorStream == null) {
            return null;
        }
        ConcurrentHashMap<String, WeakReference<Mailbox>> concurrentHashMap = this._actorStreamMap;
        synchronized (concurrentHashMap) {
            WeakReference<Mailbox> ref = this._actorStreamMap.get(address);
            if (ref != null) {
                return (Mailbox)ref.get();
            }
            this._actorStreamMap.put(address, new WeakReference<Mailbox>(actorStream));
            return actorStream;
        }
    }

    private Mailbox findDomain(String domain) {
        if (domain == null) {
            return null;
        }
        if ("local".equals(domain)) {
            return this.getBrokerMailbox();
        }
        Broker broker = null;
        if (this._manager != null) {
            broker = this._manager.findBroker(domain);
        }
        if (broker == this) {
            return null;
        }
        Mailbox stream = null;
        if (this._domainManager != null) {
            stream = this._domainManager.findDomain(domain);
        }
        return stream;
    }

    protected boolean startActorFromManager(String address) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeActor(String address) {
        int p = address.indexOf(47);
        if (p > 0) {
            String owner = address.substring(0, p);
            Object actor = null;
        }
        this._actorCache.remove(address);
        ConcurrentHashMap<String, WeakReference<Mailbox>> concurrentHashMap = this._actorStreamMap;
        synchronized (concurrentHashMap) {
            this._actorStreamMap.remove(address);
        }
    }

    public void addStartupActor(Bean bean, String name, int threadMax) {
        ActorStartup startup = new ActorStartup(bean, name, threadMax);
        Environment.addEnvironmentListener(startup);
    }

    private void startActor(Bean<?> bean, String name, int threadMax) {
        InjectManager beanManager = InjectManager.getCurrent();
        Object beanInstance = beanManager.getReference(bean);
        String address = this.createAddress(name, bean);
        Actor actor = this.createActor(beanInstance, address);
        Mailbox mailbox = threadMax > 0 ? new MultiworkerMailbox(address, actor, this, threadMax) : new PassthroughMailbox(address, actor, this);
        this.addMailbox(address, mailbox);
        Environment.addCloseListener(new ActorClose(mailbox));
    }

    private Actor createActor(Object instance, String address) {
        if (instance instanceof ActorHolder) {
            ActorHolder actor = (ActorHolder)instance;
            actor.setAddress(address);
            actor.setBroker(this);
            return actor.getActor();
        }
        ProxyActor<Object> proxyActor = new ProxyActor<Object>(instance, address, this);
        return proxyActor;
    }

    private String createAddress(String address, Bean<?> bean) {
        if (address == null || "".equals(address)) {
            address = bean.getName();
        }
        if (address == null || "".equals(address)) {
            address = bean.getBeanClass().getSimpleName();
        }
        if (address.indexOf(64) < 0) {
            address = address + '@' + this.getAddress();
        } else if (address.endsWith("@")) {
            address = address.substring(0, address.length() - 1);
        }
        return address;
    }

    private void startActor(Bean bean, AdminService bamService) {
        InjectManager beanManager = InjectManager.getCurrent();
        ActorHolder actor = (ActorHolder)beanManager.getReference(bean);
        actor.setBroker(this);
        String address = bamService.name();
        if (address == null || "".equals(address)) {
            address = bean.getName();
        }
        if (address == null || "".equals(address)) {
            address = bean.getBeanClass().getSimpleName();
        }
        actor.setAddress(address);
        int threadMax = bamService.threadMax();
        ActorHolder bamActor = actor;
        MultiworkerMailbox mailbox = null;
        if (threadMax > 0) {
            Actor actorStream = bamActor.getActor();
            mailbox = new MultiworkerMailbox(address, actorStream, this, threadMax);
            bamActor.setMailbox(mailbox);
        }
        this.addMailbox(address, mailbox);
        Environment.addCloseListener(new ActorClose(mailbox));
    }

    @Override
    public void close() {
        this._isClosed = true;
        this._manager.removeBroker(this._domain);
        for (String alias : this._aliasList) {
            this._manager.removeBroker(alias);
        }
        ArrayList<Mailbox> mailboxes = new ArrayList<Mailbox>(this._actorMap.values());
        this._actorMap.clear();
        this._actorCache.clear();
        this._actorStreamMap.clear();
        for (Mailbox mailbox : mailboxes) {
            try {
                mailbox.close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private String getAddress(ActorHolder actor, Annotation[] annList) {
        String address;
        BamService bamAnn = this.findActor(annList);
        String name = "";
        if (bamAnn != null) {
            name = bamAnn.name();
        }
        if (name == null || "".equals(name)) {
            name = actor.getAddress();
        }
        if (name == null || "".equals(name)) {
            name = actor.getClass().getSimpleName();
        }
        if ((address = name).indexOf(64) < 0 && address.indexOf(47) < 0) {
            address = name + "@" + this.getAddress();
        }
        return address;
    }

    private int getThreadMax(Annotation[] annList) {
        BamService bamAnn = this.findActor(annList);
        if (bamAnn != null) {
            return bamAnn.threadMax();
        }
        return 1;
    }

    private BamService findActor(Annotation[] annList) {
        for (Annotation ann : annList) {
            if (!ann.annotationType().equals(BamService.class)) continue;
            return (BamService)ann;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._domain + "]";
    }

    static class AfterStartListener
    implements AfterResinStartListener {
        private WeakReference<HempBroker> _brokerRef;

        AfterStartListener(HempBroker broker) {
            this._brokerRef = new WeakReference<HempBroker>(broker);
        }

        public void afterStart() {
            HempBroker broker = (HempBroker)this._brokerRef.get();
            if (broker != null) {
                broker.afterStart();
            }
        }
    }

    public class ActorClose {
        private Mailbox _actor;

        ActorClose(Mailbox actor) {
            this._actor = actor;
        }

        public void close() {
            HempBroker.this.removeMailbox(this._actor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ActorStartup
    implements EnvironmentListener {
        private Bean<?> _bean;
        private String _name;
        private int _threadMax;

        ActorStartup(Bean<?> bean, String name, int threadMax) {
            this._bean = bean;
            this._name = name;
            this._threadMax = threadMax;
        }

        Bean<?> getBean() {
            return this._bean;
        }

        String getName() {
            return this._name;
        }

        int getThreadMax() {
            return this._threadMax;
        }

        @Override
        public void environmentConfigure(EnvironmentClassLoader loader) {
        }

        @Override
        public void environmentBind(EnvironmentClassLoader loader) {
        }

        @Override
        public void environmentStart(EnvironmentClassLoader loader) {
            HempBroker.this.startActor(this._bean, this._name, this._threadMax);
        }

        @Override
        public void environmentStop(EnvironmentClassLoader loader) {
        }
    }
}

