/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.services;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class MailService {
    private static final L10N L = new L10N(MailService.class);
    private static final Logger log = Logger.getLogger(MailService.class.getName());
    private ArrayList<Address> _toList = new ArrayList();
    private Address[] _to;
    private ArrayList<Address> _fromList = new ArrayList();
    private Address[] _from;
    private String _subject = "Resin MailService messages";
    private Properties _properties = new Properties();
    private Session _session;
    private Transport _smtp;

    public void setSession(Session session) {
        this._session = session;
    }

    public Session getSession() {
        return this._session;
    }

    public void addTo(Address address) {
        this._toList.add(address);
    }

    public Address[] getToAddresses() {
        return this._to;
    }

    public void addFrom(Address address) {
        this._fromList.add(address);
    }

    public Address[] getFromAddresses() {
        return this._from;
    }

    public void setProperty(String key, String value) {
        this._properties.put(key, value);
    }

    public void setProperties(Properties props) {
        this._properties.putAll((Map<?, ?>)props);
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public void send(String body) {
        this.send(this._subject, body);
    }

    public void send(String subject, String body) {
        try {
            MimeMessage msg = new MimeMessage(this.getSession());
            if (this._from.length > 0) {
                msg.addFrom(this._from);
            }
            msg.addRecipients(Message.RecipientType.TO, this._to);
            if (subject != null) {
                msg.setSubject(subject);
            }
            msg.setContent((Object)body, "text/plain");
            this.send((Message)msg);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendWithAttachment(String subject, String textBody, String attachmentType, String attachmentName, InputStream is) {
        try {
            int len;
            MimeMessage msg = new MimeMessage(this.getSession());
            if (this._from.length > 0) {
                msg.addFrom(this._from);
            }
            msg.addRecipients(Message.RecipientType.TO, this._to);
            if (subject != null) {
                msg.setSubject(subject);
            }
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart textBodyPart = new MimeBodyPart();
            textBodyPart.setText(textBody);
            multipart.addBodyPart((BodyPart)textBodyPart);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            TempBuffer tb = TempBuffer.allocate();
            byte[] buffer = tb.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) >= 0) {
                bos.write(buffer, 0, len);
            }
            bos.close();
            byte[] content = bos.toByteArray();
            TempBuffer.free(tb);
            ByteArrayDataSource dataSource = new ByteArrayDataSource(content, attachmentType);
            MimeBodyPart pdfBodyPart = new MimeBodyPart();
            pdfBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
            pdfBodyPart.setFileName(attachmentName);
            multipart.addBodyPart((BodyPart)pdfBodyPart);
            msg.setContent((Multipart)multipart);
            this.send((Message)msg);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void send(Message message) {
        Transport smtp = null;
        try {
            smtp = this._session.getTransport("smtp");
            smtp.connect();
            Transport.send((Message)message, (Address[])this._to);
            log.fine(this + " sent mail to " + this._to[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (smtp != null) {
                    smtp.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    public void init() {
        if (this._toList.size() == 0) {
            throw new ConfigException(L.l("mail service requires at least one 'to' address"));
        }
        this._to = new Address[this._toList.size()];
        this._toList.toArray(this._to);
        this._from = new Address[this._fromList.size()];
        this._fromList.toArray(this._from);
        try {
            if (this._session == null) {
                this._session = Session.getInstance((Properties)this._properties);
            }
            Transport smtp = this._session.getTransport("smtp");
            smtp.close();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this._toList;
    }
}

