/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.BamError;
import com.caucho.bam.stream.MessageStream;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2StreamingInput;
import com.caucho.hmtp.HmtpPacketType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmtpReader {
    private static final Logger log = Logger.getLogger(HmtpReader.class.getName());
    private String _id;
    private InputStream _is;
    private Hessian2StreamingInput _in;
    private Hessian2Input _hIn;
    private int _addressCacheIndex;
    private String[] _addressCacheRing = new String[256];

    public HmtpReader() {
        this._hIn = new Hessian2Input();
    }

    public HmtpReader(InputStream is) {
        this();
        this.init(is);
    }

    public void setId(String id) {
        this._id = id;
    }

    public void init(InputStream is) {
        this._hIn.reset();
    }

    public boolean isDataAvailable() {
        return this._in != null && this._in.isDataAvailable();
    }

    public boolean readPacket(InputStream is, MessageStream actorStream) throws IOException {
        if (actorStream == null) {
            throw new IllegalStateException("HmtpReader.readPacket requires a valid ActorStream for callbacks");
        }
        Hessian2Input hIn = this._hIn;
        hIn.initPacket(is);
        int type = hIn.readInt();
        String to = this.readAddress(hIn);
        String from = this.readAddress(hIn);
        switch (HmtpPacketType.TYPES[type]) {
            case MESSAGE: {
                Serializable value = (Serializable)hIn.readObject();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " message " + value + " {to:" + to + ", from:" + from + "}");
                }
                actorStream.message(to, from, value);
                break;
            }
            case MESSAGE_ERROR: {
                Serializable value = (Serializable)hIn.readObject();
                BamError error = (BamError)hIn.readObject();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " messageError " + error + " " + value + " {to:" + to + ", from:" + from + "}");
                }
                actorStream.messageError(to, from, value, error);
                break;
            }
            case QUERY: {
                long id = hIn.readLong();
                Serializable value = (Serializable)hIn.readObject();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " query " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.query(id, to, from, value);
                break;
            }
            case QUERY_RESULT: {
                long id = hIn.readLong();
                Serializable value = (Serializable)hIn.readObject();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " queryResult " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.queryResult(id, to, from, value);
                break;
            }
            case QUERY_ERROR: {
                long id = hIn.readLong();
                Serializable value = (Serializable)hIn.readObject();
                BamError error = (BamError)hIn.readObject();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " queryError " + error + " " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.queryError(id, to, from, value, error);
                break;
            }
            default: {
                throw new UnsupportedOperationException("ERROR: " + (Object)((Object)HmtpPacketType.TYPES[type]));
            }
        }
        return true;
    }

    private String readAddress(Hessian2Input hIn) throws IOException {
        Object value = hIn.readObject();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String address;
            this._addressCacheRing[this._addressCacheIndex] = address = (String)value;
            this._addressCacheIndex = (this._addressCacheIndex + 1) % this._addressCacheRing.length;
            return address;
        }
        if (value instanceof Integer) {
            int index = (Integer)value;
            return this._addressCacheRing[index];
        }
        throw new IllegalStateException(String.valueOf(value));
    }

    public void close() {
        try {
            Hessian2StreamingInput in = this._in;
            this._in = null;
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public String toString() {
        if (this._id != null) {
            return this.getClass().getSimpleName() + "[" + this._id + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._is + "]";
    }
}

