/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.broker.Broker;
import com.caucho.hmtp.HmtpReader;
import com.caucho.hmtp.HmtpWebSocketContextWriter;
import com.caucho.websocket.AbstractWebSocketListener;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.InputStream;

public class HmtpWebSocketListener
extends AbstractWebSocketListener {
    private Broker _broker;
    private HmtpReader _hIn;
    private HmtpWebSocketContextWriter _hOut;

    public HmtpWebSocketListener(Broker broker) {
        if (broker == null) {
            throw new IllegalArgumentException();
        }
        this._broker = broker;
    }

    HmtpWebSocketContextWriter getOutboundStream() {
        return this._hOut;
    }

    String getAddress() {
        return "hmtp@" + this._broker.getAddress();
    }

    public void onStart(WebSocketContext context) {
        this._hOut = new HmtpWebSocketContextWriter(context);
        this._hIn = new HmtpReader();
    }

    public void onReadBinary(WebSocketContext context, InputStream is) throws IOException {
        this._hIn.readPacket(is, this._broker);
    }

    public void onDisconnect(WebSocketContext context) {
        this._hOut = null;
        this._hIn = null;
    }

    boolean isClosed() {
        return this._hOut == null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._broker + "]";
    }
}

