/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.log;

import com.caucho.http.log.AbstractErrorLog;
import com.caucho.util.CharBuffer;
import com.caucho.util.CompileException;
import com.caucho.util.CurrentTime;
import com.caucho.util.ExceptionWrapper;
import com.caucho.util.QDate;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ErrorLog
extends AbstractErrorLog {
    public void log(String message, HttpServletRequest request, HttpServletResponse response, ServletContext application) throws IOException {
        WriteStream logStream = this.getLogStream();
        if (logStream == null) {
            return;
        }
        CharBuffer cb = CharBuffer.allocate();
        QDate.formatLocal(cb, CurrentTime.getCurrentTime(), "[%Y/%m/%d %H:%M:%S] ");
        cb.append(message);
        logStream.log(cb.close());
        logStream.flush();
    }

    public void log(String message, Throwable e, HttpServletRequest request, HttpServletResponse response, ServletContext application) throws IOException {
        WriteStream logStream = this.getLogStream();
        if (logStream == null) {
            return;
        }
        Throwable t = e;
        while (t != null) {
            e = t;
            if (e instanceof ServletException) {
                t = ((ServletException)e).getRootCause();
                continue;
            }
            if (e instanceof ExceptionWrapper) {
                t = ((ExceptionWrapper)((Object)e)).getRootCause();
                continue;
            }
            t = null;
        }
        CharBuffer cb = CharBuffer.allocate();
        QDate.formatLocal(cb, CurrentTime.getCurrentTime(), "[%Y/%m/%d %H:%M:%S] ");
        cb.append(message);
        logStream.log(cb.close());
        if (e != null && !(e instanceof CompileException)) {
            logStream.log(e);
        }
        logStream.flush();
    }

    public void destroy() throws IOException {
    }
}

