/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.config.ConfigException;
import com.caucho.java.AbstractJavaCompiler;
import com.caucho.java.JavaCompileException;
import com.caucho.java.JavaCompilerUtil;
import com.caucho.java.JavacErrorParser;
import com.caucho.java.LineMap;
import com.caucho.loader.ClassLoaderContext;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.NonScanDynamicClassLoader;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class InternalCompilerTools
extends AbstractJavaCompiler {
    private static final Logger log = Logger.getLogger(InternalCompilerTools.class.getName());
    private static boolean _hasCompiler;
    private static DynamicClassLoader _internalLoader;
    Process _process;
    String _userPrefix;
    boolean _isDead;

    public InternalCompilerTools(JavaCompilerUtil compiler) {
        super(compiler);
    }

    protected void compileInt(String[] path, LineMap lineMap) throws IOException, JavaCompileException {
        this.executeInt(path, lineMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInt(String[] path, LineMap lineMap) throws JavaCompileException, IOException {
        MemoryStream tempStream = new MemoryStream();
        WriteStream error = new WriteStream(tempStream);
        try {
            String encoding;
            ArrayList<String> argList = new ArrayList<String>();
            argList.add("-d");
            argList.add(this._compiler.getClassDirName());
            if (this._compiler.getEncoding() != null && (encoding = Encoding.getJavaName(this._compiler.getEncoding())) != null && !encoding.equals("ISO8859_1")) {
                argList.add("-encoding");
                argList.add(this._compiler.getEncoding());
            }
            argList.add("-classpath");
            argList.add(this._compiler.getClassPath());
            ArrayList<String> args = this._compiler.getArgs();
            if (args != null) {
                argList.addAll(args);
            }
            for (int i = 0; i < path.length; ++i) {
                Path javaPath = this._compiler.getSourceDir().lookup(path[i]);
                argList.add(javaPath.getNativePath());
            }
            if (log.isLoggable(Level.FINER)) {
                CharBuffer msg = new CharBuffer();
                msg.append("javac(int)");
                for (int i = 0; i < argList.size(); ++i) {
                    if (((String)argList.get(i)).equals("-classpath") && !log.isLoggable(Level.FINEST)) {
                        ++i;
                        continue;
                    }
                    msg.append(" ");
                    msg.append((String)argList.get(i));
                }
                log.finer(msg.toString());
            }
            String[] argArray = argList.toArray(new String[argList.size()]);
            int status = -1;
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            NonScanDynamicClassLoader env = new NonScanDynamicClassLoader(ClassLoader.getSystemClassLoader());
            Path javaHome = Vfs.lookup(System.getProperty("java.home"));
            Path jar = javaHome.lookup("./lib/tools.jar");
            if (jar.canRead()) {
                env.addJar(jar);
            }
            if ((jar = javaHome.lookup("../lib/tools.jar")).canRead()) {
                env.addJar(jar);
            }
            try {
                Iterator<JavaCompiler> iter;
                thread.setContextClassLoader(env);
                JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
                if (javac == null && (iter = ServiceLoader.load(JavaCompiler.class).iterator()).hasNext()) {
                    javac = iter.next();
                }
                if (javac == null) {
                    throw new ConfigException(L.l("javac compiler is not available in {0}. Check that you are using the JDK, not the JRE.", (Object)(System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version"))));
                }
                status = javac.run(null, error, error, argArray);
                error.close();
                tempStream.close();
                Object var17_20 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            ReadStream read = tempStream.openReadAndSaveBuffer();
            JavacErrorParser parser = new JavacErrorParser(this, path[0], this._compiler.getEncoding());
            String errors = parser.parseErrors(read, lineMap);
            read.close();
            if (errors != null) {
                errors = errors.trim();
            }
            if (log.isLoggable(Level.FINE)) {
                int ch;
                read = tempStream.openReadAndSaveBuffer();
                CharBuffer cb = new CharBuffer();
                while ((ch = read.read()) >= 0) {
                    cb.append((char)ch);
                }
                read.close();
                log.fine(cb.toString());
            } else if (status == 0 && errors != null && !errors.equals("")) {
                final String msg = errors;
                new ClassLoaderContext(this._compiler.getClassLoader()){

                    public void run() {
                        log.warning(msg);
                    }
                };
            }
            if (status != 0) {
                throw new JavaCompileException(errors);
            }
            Object var20_25 = null;
            tempStream.destroy();
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            tempStream.destroy();
            throw throwable;
        }
    }
}

