/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.program;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ConfigProgram;
import com.caucho.jca.ra.ResourceAdapterController;
import com.caucho.jca.ra.ResourceArchive;
import com.caucho.jca.ra.ResourceArchiveManager;
import com.caucho.util.L10N;
import javax.enterprise.context.spi.CreationalContext;
import javax.resource.spi.ResourceAdapterAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAdapterAssociationProgram
extends ConfigProgram {
    private static final L10N L = new L10N(ResourceAdapterAssociationProgram.class);
    private final ResourceAdapterController _raController;

    public ResourceAdapterAssociationProgram(Class cl) {
        ResourceArchive ra = ResourceArchiveManager.findResourceArchive(cl.getName());
        if (ra == null) {
            throw new ConfigException(L.l("'{0}' does not have a defined resource-adapter.  Check the rar or META-INF/resin-ra.xml files", (Object)cl.getName()));
        }
        InjectManager webBeans = InjectManager.create();
        this._raController = webBeans.getReference(ResourceAdapterController.class, Names.create(ra.getResourceAdapterClass().getName()));
        if (this._raController == null) {
            throw new ConfigException(L.l("'{0}' does not have a configured resource-adapter for '{1}'.", (Object)ra.getResourceAdapterClass().getName(), (Object)cl.getName()));
        }
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) {
        try {
            ResourceAdapterAssociation association = (ResourceAdapterAssociation)bean;
            association.setResourceAdapter(this._raController.getResourceAdapter());
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

