/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.ra;

import com.caucho.config.program.ConfigProgram;
import com.caucho.jca.cfg.ResourceConfig;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDefault {
    private static final L10N L = new L10N(ResourceDefault.class);
    private static final Logger log = Logger.getLogger(ResourceDefault.class.getName());
    private static EnvironmentLocal<ArrayList<ResourceConfig>> _localConfig = new EnvironmentLocal();
    private ResourceConfig _config = new ResourceConfig();

    public void addBuilderProgram(ConfigProgram program) {
        this._config.addBuilderProgram(program);
    }

    @PostConstruct
    public void init() {
        ArrayList<ResourceConfig> defaultList = _localConfig.getLevel();
        if (defaultList == null) {
            defaultList = new ArrayList();
            _localConfig.set(defaultList);
        }
        defaultList.add(this._config);
    }

    public static ArrayList<ResourceConfig> getDefaultList() {
        return ResourceDefault.getDefaultList(Thread.currentThread().getContextClassLoader());
    }

    public static ArrayList<ResourceConfig> getDefaultList(ClassLoader loader) {
        ArrayList<ResourceConfig> defaultList = new ArrayList<ResourceConfig>();
        ResourceDefault.getDefaultList(defaultList, loader);
        return defaultList;
    }

    private static void getDefaultList(ArrayList<ResourceConfig> list, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ResourceDefault.getDefaultList(list, loader.getParent());
                ArrayList<ResourceConfig> defaultList = _localConfig.getLevel(loader);
                if (defaultList != null) {
                    list.addAll(defaultList);
                }
            }
            loader = loader.getParent();
        }
    }
}

