/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.ra;

import com.caucho.env.thread.ThreadPool;
import com.caucho.inject.Module;
import com.caucho.jca.ra.WorkThread;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.ArrayList;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;

@Module
public class WorkManagerImpl
implements WorkManager {
    private static final L10N L = new L10N(WorkManagerImpl.class);
    private ArrayList<Work> _activeTasks = new ArrayList();
    private volatile boolean _isClosed;

    WorkManagerImpl() {
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener) throws WorkException {
        WorkManagerImpl workManagerImpl;
        boolean isStart = false;
        try {
            WorkException exn = null;
            WorkManagerImpl workManagerImpl2 = this;
            synchronized (workManagerImpl2) {
                if (this._isClosed) {
                    exn = new WorkException(L.l("Work task can't be started from closed context."));
                } else if (this._activeTasks.contains(work)) {
                    exn = new WorkException(L.l("Reentrant Work tasks are not allowed."));
                } else {
                    isStart = true;
                    this._activeTasks.add(work);
                }
            }
            if (listener != null) {
                if (isStart) {
                    listener.workAccepted(new WorkEvent(this, 1, work, null, 0L));
                } else {
                    listener.workRejected(new WorkEvent(this, 2, work, exn, 0L));
                }
            }
            if (exn != null) {
                throw exn;
            }
            if (listener != null) {
                listener.workStarted(new WorkEvent(this, 3, work, null, 0L));
            }
            work.run();
            if (listener != null) {
                listener.workCompleted(new WorkEvent(this, 4, work, null, 0L));
            }
            Object var11_9 = null;
            workManagerImpl = this;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            WorkManagerImpl workManagerImpl3 = this;
            synchronized (workManagerImpl3) {
                this._activeTasks.remove(work);
            }
            throw throwable;
        }
        synchronized (workManagerImpl) {
            this._activeTasks.remove(work);
        }
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener) throws WorkException {
        long start = CurrentTime.getCurrentTime();
        this.startWork(work, startTimeout, context, listener, true);
        return CurrentTime.getCurrentTime() - start;
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener) throws WorkException {
        this.startWork(work, startTimeout, context, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long startWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener, boolean waitForStart) throws WorkException {
        WorkManagerImpl workManagerImpl;
        boolean isStart = false;
        WorkException exn = null;
        try {
            WorkManagerImpl workManagerImpl2 = this;
            synchronized (workManagerImpl2) {
                if (this._isClosed) {
                    exn = new WorkException(L.l("Work task can't be started from closed context."));
                } else if (this._activeTasks.contains(work)) {
                    exn = new WorkException(L.l("Reentrant Work tasks are not allowed."));
                } else {
                    this._activeTasks.add(work);
                }
            }
            if (exn != null) {
                if (listener != null) {
                    listener.workRejected(new WorkEvent(this, 2, work, exn, 0L));
                }
                throw exn;
            }
            if (listener != null) {
                listener.workAccepted(new WorkEvent(this, 1, work, null, 0L));
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            WorkThread workThread = new WorkThread(this, work, loader, listener);
            if (listener != null) {
                listener.workStarted(new WorkEvent(this, 3, work, null, 0L));
            }
            isStart = waitForStart ? ThreadPool.getThreadPool().start(workThread, startTimeout) : ThreadPool.getThreadPool().schedule((Runnable)workThread, startTimeout);
            Object var12_11 = null;
            workManagerImpl = this;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            WorkManagerImpl workManagerImpl3 = this;
            synchronized (workManagerImpl3) {
                if (!isStart) {
                    this._activeTasks.remove(work);
                }
            }
            throw throwable;
        }
        synchronized (workManagerImpl) {
            if (!isStart) {
                this._activeTasks.remove(work);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeWork(Work work) {
        WorkManagerImpl workManagerImpl = this;
        synchronized (workManagerImpl) {
            this._activeTasks.remove(work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        WorkManagerImpl workManagerImpl = this;
        synchronized (workManagerImpl) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        ArrayList<Work> activeTasks = new ArrayList<Work>();
        WorkManagerImpl workManagerImpl2 = this;
        synchronized (workManagerImpl2) {
            activeTasks.addAll(this._activeTasks);
        }
        for (int i = 0; i < activeTasks.size(); ++i) {
            ((Work)activeTasks.get(i)).release();
        }
    }
}

