/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.file;

import com.caucho.config.ConfigException;
import com.caucho.db.jdbc.DataSourceImpl;
import com.caucho.env.service.RootDirectorySystem;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.jms.file.FileQueueImpl;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.FileQueueStoreMXBean;
import com.caucho.server.cluster.ServletService;
import com.caucho.util.FreeList;
import com.caucho.util.JdbcUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileQueueStore {
    private static final L10N L = new L10N(FileQueueStore.class);
    private static final Logger log = Logger.getLogger(FileQueueStore.class.getName());
    private static final EnvironmentLocal<FileQueueStore> _localStore = new EnvironmentLocal();
    private static final int START_LIMIT = 8192;
    private FreeList<StoreConnection> _freeList = new FreeList(32);
    private DataSource _db;
    private String _queueTable;
    private String _messageTable;
    private FileQueueStoreAdmin _admin;

    public FileQueueStore(Path path, String serverId, ClassLoader loader) {
        this(path, serverId, loader, false);
    }

    private FileQueueStore(Path path, String serverId, ClassLoader loader, boolean isServer) {
        this.init(path, serverId, loader, isServer);
    }

    public FileQueueStore(Path path, String serverId) {
        this(path, serverId, Thread.currentThread().getContextClassLoader(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileQueueStore create() {
        ServletService server = ServletService.getCurrent();
        if (server == null) {
            throw new IllegalStateException(L.l("FileQueueStore requires an active Resin instance"));
        }
        EnvironmentClassLoader loader = server.getClassLoader();
        EnvironmentLocal<FileQueueStore> environmentLocal = _localStore;
        synchronized (environmentLocal) {
            FileQueueStore store = _localStore.getLevel(loader);
            if (store == null) {
                Path path = RootDirectorySystem.getCurrentDataDirectory();
                String serverId = server.getServerId();
                store = new FileQueueStore(path, serverId, loader, true);
                _localStore.set(store, loader);
            }
            return store;
        }
    }

    private void init(Path path, String serverId, ClassLoader loader, boolean isServer) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (serverId == null) {
            throw new NullPointerException();
        }
        try {
            path.mkdirs();
        }
        catch (IOException e) {
            log.log(Level.ALL, e.toString(), e);
        }
        if (!path.isDirectory()) {
            throw new ConfigException(L.l("FileQueue requires a valid persistent directory {0}.", (Object)path.getURL()));
        }
        if ("".equals(serverId)) {
            serverId = "default";
        }
        this._queueTable = FileQueueStore.escapeName("jms_queue_" + serverId);
        this._messageTable = FileQueueStore.escapeName("jms_message_" + serverId);
        Environment.addCloseListener(this, loader);
        try {
            DataSourceImpl db = new DataSourceImpl(path);
            db.setRemoveOnError(true);
            db.init();
            this._db = db;
            Connection conn = this._db.getConnection();
            this.initDatabase(conn);
            conn.close();
            if (isServer) {
                this._admin = new FileQueueStoreAdmin();
            }
        }
        catch (SQLException e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long send(byte[] queueHash, String msgId, Serializable payload, int priority, long expireTime) {
        StoreConnection conn = null;
        try {
            long l;
            try {
                ResultSet rs;
                TempOutputStream os = new TempOutputStream();
                Hessian2Output out = new Hessian2Output(os);
                out.writeObject(payload);
                out.close();
                conn = this.getConnection();
                PreparedStatement sendStmt = conn.prepareSend();
                sendStmt.setBytes(1, queueHash);
                sendStmt.setString(2, msgId);
                sendStmt.setBinaryStream(3, os.openInputStream(), 0);
                sendStmt.setInt(4, priority);
                sendStmt.setLong(5, expireTime);
                sendStmt.executeUpdate();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " send " + payload);
                }
                if (!(rs = sendStmt.getGeneratedKeys()).next()) {
                    throw new IllegalStateException();
                }
                long id = rs.getLong(1);
                rs.close();
                l = id;
                Object var17_15 = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.freeConnection(conn, true);
            return l;
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            this.freeConnection(conn, true);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean receiveStart(byte[] queueHash, FileQueueImpl<?> fileQueue) {
        StoreConnection conn = null;
        boolean isValid = false;
        try {
            boolean bl;
            try {
                conn = this.getConnection();
                PreparedStatement receiveStartStmt = conn.prepareReceiveStart();
                receiveStartStmt.setBytes(1, queueHash);
                ResultSet rs = receiveStartStmt.executeQuery();
                int count = 0;
                while (rs.next()) {
                    ++count;
                    long id = rs.getLong(1);
                    String msgId = rs.getString(2);
                    int priority = rs.getInt(3);
                    long expire = rs.getLong(4);
                    fileQueue.addEntry(id, msgId, -1L, priority, expire, null);
                }
                rs.close();
                isValid = true;
                bl = count < 8192;
                Object var15_15 = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.freeConnection(conn, isValid);
            return bl;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.freeConnection(conn, isValid);
            throw throwable;
        }
    }

    public Serializable readMessage(long id) {
        ResultSet rs;
        boolean isValid;
        StoreConnection conn;
        block7: {
            conn = null;
            isValid = false;
            conn = this.getConnection();
            PreparedStatement readStmt = conn.prepareRead();
            readStmt.setLong(1, id);
            rs = readStmt.executeQuery();
            if (!rs.next()) break block7;
            Serializable payload = null;
            InputStream is = rs.getBinaryStream(1);
            if (is != null) {
                Hessian2Input in = new Hessian2Input(is);
                payload = (Serializable)in.readObject();
                in.close();
                is.close();
            }
            Serializable serializable = payload;
            Object var11_11 = null;
            this.freeConnection(conn, isValid);
            return serializable;
        }
        try {
            try {
                rs.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object var11_12 = null;
            this.freeConnection(conn, isValid);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.freeConnection(conn, isValid);
            throw throwable;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable receive(byte[] queueHash) {
        StoreConnection conn = null;
        boolean isValid = false;
        try {
            try {
                conn = this.getConnection();
                PreparedStatement receiveStmt = conn.prepareReceive();
                receiveStmt.setBytes(1, queueHash);
                ResultSet rs = receiveStmt.executeQuery();
                if (rs.next()) {
                    long id = rs.getLong(1);
                    rs.close();
                    PreparedStatement deleteStmt = conn.prepareDelete();
                    deleteStmt.setLong(1, id);
                    deleteStmt.executeUpdate();
                    Serializable serializable = null;
                    Object var11_10 = null;
                    this.freeConnection(conn, isValid);
                    return serializable;
                }
                Object var11_11 = null;
                this.freeConnection(conn, isValid);
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.freeConnection(conn, isValid);
            throw throwable;
        }
    }

    void delete(long id) {
        StoreConnection conn = null;
        boolean isValid = false;
        try {
            try {
                conn = this.getConnection();
                PreparedStatement deleteStmt = conn.prepareDelete();
                deleteStmt.setLong(1, id);
                deleteStmt.executeUpdate();
                isValid = true;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object var7_7 = null;
            this.freeConnection(conn, isValid);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.freeConnection(conn, isValid);
            throw throwable;
        }
    }

    private void initDatabase(Connection conn) throws SQLException {
        String sql = "select id, priority, payload, is_valid from " + this._messageTable + " where 1=0";
        Statement stmt = conn.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            rs.close();
            return;
        }
        catch (SQLException e) {
            log.finer(e.toString());
            try {
                stmt.executeUpdate("drop table " + this._queueTable);
            }
            catch (SQLException e2) {
                log.finer(e2.toString());
            }
            try {
                stmt.executeUpdate("drop table " + this._messageTable);
            }
            catch (SQLException e3) {
                log.finer(e3.toString());
            }
            sql = "create table " + this._queueTable + " (" + "  id bigint primary key auto_increment," + "  name varchar(128)" + ")";
            stmt.executeUpdate(sql);
            sql = "create table " + this._messageTable + " (" + "  id identity primary key," + "  queue_id binary(32)," + "  priority integer," + "  expire datetime," + "  msg_id varchar(64)," + "  payload blob," + "  is_valid bit" + ")";
            stmt.executeUpdate(sql);
            return;
        }
    }

    public int getMessageCount() {
        int n;
        Connection conn;
        block5: {
            conn = null;
            conn = this._db.getConnection();
            String sql = "select count(*) from " + this._messageTable;
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            Object var7_8 = null;
            JdbcUtil.close(conn);
            return n2;
        }
        try {
            n = -1;
            Object var7_9 = null;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                JdbcUtil.close(conn);
                throw throwable;
            }
        }
        JdbcUtil.close(conn);
        return n;
    }

    public void close() {
        if (this._admin != null) {
            this._admin.close();
        }
    }

    private StoreConnection getConnection() throws SQLException {
        StoreConnection storeConn = this._freeList.allocate();
        if (storeConn != null) {
            return storeConn;
        }
        Connection conn = this._db.getConnection();
        return new StoreConnection(conn);
    }

    private void freeConnection(StoreConnection conn, boolean isValid) {
        if (conn != null) {
            if (isValid) {
                this._freeList.free(conn);
            } else {
                conn.close();
            }
        }
    }

    private static String escapeName(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '0' || ch == '_') {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._messageTable + "]";
    }

    class FileQueueStoreAdmin
    extends AbstractManagedObject
    implements FileQueueStoreMXBean {
        FileQueueStoreAdmin() {
            this.registerSelf();
        }

        public void close() {
            this.unregisterSelf();
        }

        public long getMessageCount() {
            return 0L;
        }

        public String getName() {
            return null;
        }
    }

    class StoreConnection {
        private Connection _conn;
        private PreparedStatement _sendStmt;
        private PreparedStatement _receiveStartStmt;
        private PreparedStatement _readStmt;
        private PreparedStatement _receiveStmt;
        private PreparedStatement _removeStmt;
        private PreparedStatement _deleteStmt;

        StoreConnection(Connection conn) {
            this._conn = conn;
        }

        PreparedStatement prepareSend() throws SQLException {
            if (this._sendStmt == null) {
                String sql = "insert into " + FileQueueStore.this._messageTable + " (queue_id,msg_id,payload,priority,expire,is_valid)" + " VALUES(?,?,?,?,?,1)";
                this._sendStmt = this._conn.prepareStatement(sql, 1);
            }
            return this._sendStmt;
        }

        PreparedStatement prepareReceive() throws SQLException {
            if (this._receiveStmt == null) {
                String sql = "select id,msg_id,payload from " + FileQueueStore.this._messageTable + " WHERE queue_id=? LIMIT 1";
                this._receiveStmt = this._conn.prepareStatement(sql);
            }
            return this._receiveStmt;
        }

        PreparedStatement prepareRead() throws SQLException {
            if (this._readStmt == null) {
                String sql = "select payload from " + FileQueueStore.this._messageTable + " WHERE id=?";
                this._readStmt = this._conn.prepareStatement(sql);
            }
            return this._readStmt;
        }

        PreparedStatement prepareReceiveStart() throws SQLException {
            if (this._receiveStartStmt == null) {
                String sql = "select id,msg_id,priority,expire from " + FileQueueStore.this._messageTable + " WHERE queue_id=? AND is_valid=1" + " LIMIT " + 8192;
                this._receiveStartStmt = this._conn.prepareStatement(sql);
            }
            return this._receiveStartStmt;
        }

        PreparedStatement prepareRemove() throws SQLException {
            if (this._removeStmt == null) {
                String sql = "update " + FileQueueStore.this._messageTable + " set payload=null, is_valid=0, expire=now() + 120000" + " WHERE id=?";
                this._removeStmt = this._conn.prepareStatement(sql);
            }
            return this._removeStmt;
        }

        PreparedStatement prepareDelete() throws SQLException {
            if (this._deleteStmt == null) {
                String sql = "delete from " + FileQueueStore.this._messageTable + " WHERE id=?";
                this._deleteStmt = this._conn.prepareStatement(sql);
            }
            return this._deleteStmt;
        }

        void close() {
            try {
                Connection conn = this._conn;
                this._conn = null;
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }
}

