/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.file;

import com.caucho.jms.file.FileQueueStore;
import com.caucho.jms.file.FileSubscriberQueue;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.jms.queue.MessageException;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTopicImpl<E>
extends AbstractTopic<E> {
    private HashMap<String, AbstractQueue<E>> _durableSubscriptionMap = new HashMap();
    private ArrayList<AbstractQueue<E>> _subscriptionList = new ArrayList();
    private int _id;

    public FileTopicImpl() {
        FileQueueStore.create();
    }

    protected FileTopicImpl(Path path, String name, String serverId) {
        try {
            path.mkdirs();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (serverId == null) {
            serverId = "anon";
        }
        new FileQueueStore(path, serverId);
        this.setName(name);
        this.init();
    }

    public void setPath(Path path) {
    }

    @Override
    public String getUrl() {
        return "file:name=" + this.getName();
    }

    @Override
    public void init() {
    }

    @Override
    public AbstractQueue<E> createSubscriber(String publisher, String name, boolean noLocal) {
        if (name != null) {
            AbstractQueue<E> queue = this._durableSubscriptionMap.get(name);
            if (queue == null) {
                queue = new FileSubscriberQueue(this, publisher, noLocal);
                queue.setName(this.getName() + ":sub-" + name);
                this._subscriptionList.add(queue);
                this._durableSubscriptionMap.put(name, queue);
            }
            return queue;
        }
        FileSubscriberQueue queue = new FileSubscriberQueue(this, publisher, noLocal);
        queue.setName(this.getName() + ":sub-" + this._id++);
        this._subscriptionList.add(queue);
        return queue;
    }

    @Override
    public void closeSubscriber(AbstractQueue<E> queue) {
        if (!this._durableSubscriptionMap.values().contains(queue)) {
            this._subscriptionList.remove(queue);
        }
    }

    @Override
    public void send(String msgId, E payload, int priority, long timeout, String publisher) throws MessageException {
        for (int i = 0; i < this._subscriptionList.size(); ++i) {
            this._subscriptionList.get(i).send(msgId, payload, priority, timeout, publisher);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getTopicName() + "]";
    }
}

