/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsmp;

import com.caucho.bam.BamError;
import com.caucho.bam.ProtocolException;
import com.caucho.json.JsonOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JsmpWriter {
    private static final Logger log = Logger.getLogger(JsmpWriter.class.getName());
    private JsonOutput _out = new JsonOutput();

    public void message(PrintWriter os, String to, String from, Serializable value) {
        try {
            JsonOutput out = this._out;
            if (out == null) {
                return;
            }
            out.init(os);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " message " + value + " {to:" + to + ", from:" + from + "}");
            }
            os.print("[\"message\"");
            if (to != null) {
                os.print(",\"");
                os.print(to);
                os.print("\"");
            } else {
                os.print(",null");
            }
            if (from != null) {
                os.print(",\"");
                os.print(from);
                os.print("\"");
            } else {
                os.print(",null");
            }
            os.print(",\"");
            this.writeType(os, value);
            os.print("\"");
            os.print(",");
            out.writeObject(value);
            out.flushBuffer();
            os.write("]");
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
    }

    public void messageError(PrintWriter os, String to, String from, Serializable value, BamError error) {
        try {
            JsonOutput out = this._out;
            if (out == null) {
                return;
            }
            out.init(os);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " messageError " + value + " {to:" + to + ", from:" + from + "}");
            }
            os.print("[\"message_error\",\"");
            os.print(to);
            os.write("\",\"");
            os.print(from);
            os.write("\",\"");
            this.writeType(os, value);
            os.write("\",");
            out.writeObject(value);
            out.flushBuffer();
            os.write(",");
            out.writeObject(error);
            out.flushBuffer();
            os.write("]");
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
    }

    public void query(PrintWriter os, long id, String to, String from, Serializable value) {
        try {
            JsonOutput out = this._out;
            if (out == null) {
                return;
            }
            out.init(os);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " query " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
            }
            os.print("[\"query\"");
            if (to != null) {
                os.print(",\"");
                os.print(to);
                os.print("\"");
            } else {
                os.print(",null");
            }
            if (from != null) {
                os.print(",\"");
                os.print(from);
                os.print("\"");
            } else {
                os.print(",null");
            }
            os.print(",");
            os.print(id);
            os.write(",\"");
            this.writeType(os, value);
            os.print("\",");
            out.writeObject(value);
            out.flushBuffer();
            os.print("]");
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
    }

    public void queryResult(PrintWriter os, long id, String to, String from, Serializable value) {
        try {
            JsonOutput out = this._out;
            if (out == null) {
                return;
            }
            out.init(os);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " result " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
            }
            os.print("[\"result\"");
            if (to != null) {
                os.print(",\"");
                os.print(to);
                os.print("\"");
            } else {
                os.print(",null");
            }
            if (from != null) {
                os.print(",\"");
                os.print(from);
                os.print("\"");
            } else {
                os.print(",null");
            }
            os.print(",");
            os.print(id);
            os.write(",\"");
            this.writeType(os, value);
            os.print("\",");
            out.writeObject(value);
            out.flushBuffer();
            os.print("]");
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
    }

    public void queryError(PrintWriter os, long id, String to, String from, Serializable payload, BamError error) {
        try {
            JsonOutput out = this._out;
            if (out == null) {
                return;
            }
            out.init(os);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " query_error " + error + "\n  " + payload + "\n  " + " {id: " + id + ", to:" + to + ", from:" + from + "}");
            }
            os.print("[\"query_error\"");
            if (to != null) {
                os.print(",\"");
                os.print(to);
                os.print("\"");
            } else {
                os.print(",null");
            }
            if (from != null) {
                os.print(",\"");
                os.print(from);
                os.print("\"");
            }
            os.print(",");
            os.print(id);
            os.write(",\"");
            this.writeType(os, payload);
            os.print("\",");
            out.writeObject(payload);
            out.flushBuffer();
            os.print(",");
            out.writeObject(error);
            out.flushBuffer();
            os.print("]");
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
    }

    private void writeType(PrintWriter os, Object value) throws IOException {
        if (value == null) {
            os.print("null");
            return;
        }
        Class<?> cl = value.getClass();
        if (cl == String.class) {
            os.print("String");
        } else if (cl.getName().startsWith("java.")) {
            os.print("Object\n");
        } else {
            os.print(value.getClass().getName());
        }
    }

    public void flush() throws IOException {
        JsonOutput out = this._out;
        if (out != null) {
            out.flush();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

