/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.Config;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.service.ResinSystem;
import com.caucho.java.JavaCompilerUtil;
import com.caucho.java.JavacConfig;
import com.caucho.jsp.AppDirResourceManager;
import com.caucho.jsp.AppResourceManager;
import com.caucho.jsp.JspCompilerInstance;
import com.caucho.jsp.JspGenerator;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.Page;
import com.caucho.jsp.SingleThreadWrapperPage;
import com.caucho.jsp.StaticPage;
import com.caucho.jsp.TagFileManager;
import com.caucho.jsp.TaglibManager;
import com.caucho.jsp.WrapperPage;
import com.caucho.jsp.cfg.JspConfig;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.jsp.cfg.JspTaglib;
import com.caucho.loader.CompilingLoader;
import com.caucho.loader.DirectoryLoader;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.resin.ResinEmbed;
import com.caucho.resin.WebAppEmbed;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.SingleThreadModel;
import javax.servlet.jsp.HttpJspPage;
import javax.servlet.jsp.JspPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspCompiler
implements EnvironmentBean {
    private static final L10N L = new L10N(JspCompiler.class);
    private static final Logger log = Logger.getLogger(JspCompiler.class.getName());
    private ResinSystem _system;
    private ClassLoader _loader;
    private WebApp _webApp;
    private Path _classDir;
    private Path _appDir;
    private JspResourceManager _resourceManager;
    private TaglibManager _taglibManager;
    private final TagFileManager _tagFileManager;
    private JspPropertyGroup _jspPropertyGroup;
    private boolean _isXml;
    private ArrayList<String> _preludeList = new ArrayList();
    private ArrayList<String> _codaList = new ArrayList();
    private HashSet<String> _compilingTags = new HashSet();
    private boolean _hasRecursiveCompile;
    private ArrayList<JspCompilerInstance> _pending = new ArrayList();
    private ResinEmbed _resin;

    public JspCompiler() {
        this._system = ResinSystem.getCurrent();
        if (this._system == null) {
            this._system = new ResinSystem("jsp-compiler");
        }
        this._loader = this._system.getClassLoader();
        this._tagFileManager = new TagFileManager(this);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setClassDir(Path path) {
        this._classDir = path;
    }

    public void setClassDirectory(Path path) {
        this.setClassDir(path);
    }

    public Path getClassDir() {
        if (this._classDir != null) {
            return this._classDir;
        }
        return CauchoSystem.getWorkPath();
    }

    public void setAppDir(Path path) {
        this._appDir = path;
    }

    public Path getAppDir() {
        if (this._appDir != null) {
            return this._appDir;
        }
        if (this._webApp != null) {
            return this._webApp.getRootDirectory();
        }
        return null;
    }

    public void addPrelude(String prelude) {
        this._preludeList.add(prelude);
    }

    public void addCoda(String coda) {
        this._codaList.add(coda);
    }

    public void setXml(boolean isXml) {
        this._isXml = isXml;
    }

    public boolean isXml() {
        return this._isXml;
    }

    public void setResourceManager(JspResourceManager manager) {
        this._resourceManager = manager;
    }

    public JspResourceManager getResourceManager() {
        return this._resourceManager;
    }

    public TagFileManager getTagFileManager() {
        return this._tagFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaglibManager getTaglibManager() throws JspParseException, IOException {
        JspCompiler jspCompiler = this;
        synchronized (jspCompiler) {
            if (this._taglibManager == null) {
                JspTaglib taglib;
                int i;
                JspResourceManager resourceManager;
                WebApp webApp = this.getWebApp();
                Path appDir = this.getAppDir();
                if (appDir == null && webApp != null) {
                    appDir = webApp.getRootDirectory();
                }
                if ((resourceManager = this.getResourceManager()) == null) {
                    resourceManager = webApp != null ? new AppResourceManager(webApp) : new AppDirResourceManager(appDir);
                }
                this._taglibManager = new TaglibManager(resourceManager, webApp, this._tagFileManager);
                this._taglibManager.setWebApp(webApp);
                JspConfig jspConfig = null;
                if (webApp != null) {
                    jspConfig = (JspConfig)webApp.getExtension("jsp-config");
                }
                if (jspConfig != null) {
                    ArrayList<JspTaglib> tldMapList = jspConfig.getTaglibList();
                    for (i = 0; i < tldMapList.size(); ++i) {
                        taglib = tldMapList.get(i);
                        this._taglibManager.addLocationMap(taglib.getTaglibUri(), taglib.getTaglibLocation());
                    }
                }
                if (webApp != null) {
                    ArrayList<JspTaglib> taglibs = webApp.getTaglibList();
                    for (i = 0; taglibs != null && i < taglibs.size(); ++i) {
                        taglib = taglibs.get(i);
                        this._taglibManager.addLocationMap(taglib.getTaglibUri(), taglib.getTaglibLocation());
                    }
                }
            }
        }
        return this._taglibManager;
    }

    public JspPropertyGroup createJsp() {
        if (this._jspPropertyGroup == null) {
            this._jspPropertyGroup = new JspPropertyGroup();
        }
        return this._jspPropertyGroup;
    }

    public JspPropertyGroup getJspPropertyGroup() {
        return this._jspPropertyGroup;
    }

    public WebApp createWebApp(Path rootDirectory) {
        if (this._webApp == null) {
            if (rootDirectory == null) {
                rootDirectory = this.getAppDir();
            }
            this._resin = new ResinEmbed();
            this._resin.setRootDirectory(rootDirectory.getURL());
            WebAppEmbed webAppEmbed = new WebAppEmbed();
            webAppEmbed.setRootDirectory(rootDirectory.getURL());
            webAppEmbed.setDisableStart(true);
            this._resin.addWebApp(webAppEmbed);
            this._resin.start();
            this._webApp = webAppEmbed.getWebApp();
        }
        return this._webApp;
    }

    public void setWebApp(WebApp app) {
        this._webApp = app;
        if (this._resourceManager == null) {
            this._resourceManager = new AppResourceManager(this._webApp);
        }
    }

    public ApplicationConfig createApplication() {
        return new ApplicationConfig();
    }

    public WebApp getWebApp() {
        return this._webApp;
    }

    public boolean addTag(String className) {
        if (this._compilingTags.contains(className)) {
            this._hasRecursiveCompile = true;
            return true;
        }
        this._compilingTags.add(className);
        return false;
    }

    public boolean hasRecursiveCompile() {
        return this._hasRecursiveCompile;
    }

    public static String urlToClassName(String name) {
        return JavaCompilerUtil.mangleName("jsp/" + name);
    }

    void addPending(JspCompilerInstance pending) {
        this._pending.add(pending);
    }

    void compilePending() throws Exception {
        if (this._pending.size() == 0) {
            return;
        }
        ArrayList<JspCompilerInstance> pendingList = new ArrayList<JspCompilerInstance>(this._pending);
        for (int i = 0; i < pendingList.size(); ++i) {
            JspCompilerInstance pending = pendingList.get(i);
            pending.completeTag();
        }
        this._pending.clear();
    }

    public Page compile(Path jspPath, String uri) throws Exception {
        return this.getCompilerInstance(jspPath, uri).compile();
    }

    public JspCompilerInstance getCompilerInstance(Path jspPath, String uri) throws Exception {
        return this.getCompilerInstance(jspPath, uri, null);
    }

    public void init() throws JspParseException, IOException {
        this.getTaglibManager();
    }

    public JspCompilerInstance getCompilerInstance(Path jspPath, String uri, String className) throws Exception {
        JspCompilerInstance instance = new JspCompilerInstance(this);
        instance.setJspPath(jspPath);
        instance.setURI(uri);
        instance.setClassName(className);
        instance.init();
        return instance;
    }

    public Page loadPage(String className, boolean isAutoCompile) throws Throwable {
        JspPage jspPage = (JspPage)this.loadClass(className, isAutoCompile);
        Page page = jspPage instanceof Page ? (Page)((Object)jspPage) : (jspPage instanceof SingleThreadModel ? new SingleThreadWrapperPage((HttpJspPage)jspPage) : new WrapperPage((HttpJspPage)jspPage));
        return page;
    }

    public Object loadClass(String className, boolean autoCompile) throws Throwable {
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        DynamicClassLoader jspLoader = SimpleLoader.create(parentLoader, this.getClassDir(), null);
        try {
            Class<?> cl = Class.forName(className, false, jspLoader);
            this.readSmap(parentLoader, className);
            return cl.newInstance();
        }
        catch (Throwable e) {
            if (autoCompile) {
                try {
                    String pathName = className.replace('.', '/') + ".class";
                    Path classPath = this.getClassDir().lookup(pathName);
                    classPath.remove();
                }
                catch (IOException e1) {
                    log.log(Level.FINE, e1.toString(), e1);
                }
            }
            throw e;
        }
    }

    public Page loadStatic(String className, boolean isSession) throws Exception {
        String staticName = className.replace('.', '/') + ".static";
        Path path = this.getClassDir().lookup(staticName);
        return new StaticPage(path, isSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSmap(ClassLoader loader, String className) {
        if (loader == null) {
            return;
        }
        String smapName = className.replace('.', '/') + ".java.smap";
        InputStream is = null;
        try {
            is = loader.getResourceAsStream(smapName);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void close() {
        ResinEmbed resin = this._resin;
        if (resin != null) {
            resin.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: com.caucho.jsp.JspCompiler [flags] jsp1 jsp2 ...");
            System.out.println(" -app-dir  : The directory root of the web-app.");
            System.out.println(" -class-dir: The working directory to use as output.");
            System.out.println(" -compiler: sets the javac.");
            System.out.println(" -conf: A configuration file for the compiler.");
            System.exit(1);
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            JspCompiler compiler = new JspCompiler();
            int i = compiler.configureFromArgs(args);
            ClassLoader loader = compiler.getClassLoader();
            thread.setContextClassLoader(loader);
            ArrayList<String> pendingClasses = new ArrayList<String>();
            if (i == args.length) {
                compiler.compilePath(pendingClasses, ".");
            }
            while (i < args.length) {
                String uri = args[i];
                compiler.compilePath(pendingClasses, uri);
                ++i;
            }
            String[] files = new String[pendingClasses.size()];
            pendingClasses.toArray(files);
            compiler.compileBatch(files);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int configureFromArgs(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: com.caucho.jsp.JspCompiler [flags] jsp1 jsp2 ...");
            System.out.println(" -app-dir  : The directory root of the web-app.");
            System.out.println(" -class-dir: The working directory to use as output.");
            System.out.println(" -conf: A configuration file for the compiler.");
            System.out.println(" -compiler: javac|internal|eclipse|groovyc.");
            System.exit(1);
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            Path appDir;
            WebApp webApp;
            ClassLoader loader = this.getClassLoader();
            thread.setContextClassLoader(loader);
            JspPropertyGroup jsp = this.createJsp();
            jsp.setRequireSource(false);
            int i = 0;
            boolean hasConf = false;
            while (i < args.length) {
                if (args[i].equals("-app-dir")) {
                    Path appDir2 = Vfs.lookup(args[i + 1]);
                    WebApp webApp2 = this.createWebApp(appDir2);
                    if (webApp2 != null) {
                        this.setWebApp(webApp2);
                    }
                    this.setAppDir(appDir2);
                    i += 2;
                    continue;
                }
                if (args[i].equals("-class-dir") || args[i].equals("-d")) {
                    this.setClassDirectory(Vfs.lookup(args[i + 1]));
                    i += 2;
                    continue;
                }
                if (args[i].equals("-compiler")) {
                    JavacConfig.getLocalConfig().setCompiler(args[i + 1]);
                    i += 2;
                    continue;
                }
                if (!args[i].equals("-conf")) break;
                Path path = Vfs.lookup(args[i + 1]);
                new Config().configureBean((Object)this, path);
                hasConf = true;
                i += 2;
            }
            if ((webApp = this.getWebApp()) != null && !hasConf) {
                appDir = webApp.getRootDirectory();
                EnvironmentClassLoader dynLoader = webApp.getEnvironmentClassLoader();
                dynLoader.addLoader(new CompilingLoader(dynLoader, appDir.lookup("WEB-INF/classes")));
                dynLoader.addLoader(new DirectoryLoader(dynLoader, appDir.lookup("WEB-INF/lib")));
                Path webXml = appDir.lookup("WEB-INF/web.xml");
                if (webXml.canRead()) {
                    try {
                        new Config().configureBean((Object)webApp, webXml);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            appDir = null;
            if (webApp == null && this.getAppDir() != null) {
                webApp = this.createWebApp(null);
                if (webApp != null) {
                    webApp.setRootDirectory(this.getAppDir());
                }
                this.setWebApp(webApp);
            }
            if (webApp != null) {
                webApp.setCompileContext(true);
                webApp.init();
                appDir = this.getWebApp().getRootDirectory();
                this.setClassLoader(this.getWebApp().getClassLoader());
            }
            if (appDir == null) {
                appDir = Vfs.lookup();
                if (this.getAppDir() == null && this.getWebApp() == null) {
                    System.err.println(L.l("-app-dir must be specified for JspCompiler"));
                    int n = 0;
                    return n;
                }
            }
            this.setResourceManager(new AppDirResourceManager(appDir));
            int n = i;
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compilePath(ArrayList<String> pendingClasses, String uri) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            Path path = Vfs.lookup(uri);
            if (path.isDirectory()) {
                JspCompiler.compileDirectory(path, this.getAppDir(), this, pendingClasses);
            } else {
                JspCompiler.compileJsp(path, this.getAppDir(), this, pendingClasses);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileBatch(String[] pendingClasses) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            JavaCompilerUtil javaCompiler = JavaCompilerUtil.create(this.getClassLoader());
            javaCompiler.setClassDir(this.getClassDir());
            javaCompiler.compileBatch(pendingClasses);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private static void compileDirectory(Path path, Path appDir, JspCompiler compiler, ArrayList<String> pendingClasses) throws Exception {
        if (path.isDirectory()) {
            String[] list = path.list();
            for (int i = 0; i < list.length; ++i) {
                Path subpath = path.lookup(list[i]);
                JspCompiler.compileDirectory(subpath, appDir, compiler, pendingClasses);
            }
        } else if (path.getPath().endsWith(".jsp") || path.getPath().endsWith(".jsfx") || path.getPath().endsWith(".jspx") || path.getPath().endsWith(".jsfx")) {
            JspCompiler.compileJsp(path, appDir, compiler, pendingClasses);
        }
    }

    private static void compileJsp(Path path, Path appDir, JspCompiler compiler, ArrayList<String> pendingClasses) throws Exception {
        String uri = path.getPath().substring(appDir.getPath().length());
        if (uri.endsWith("x")) {
            compiler.setXml(true);
        } else {
            compiler.setXml(false);
        }
        String className = JspCompiler.urlToClassName(uri);
        JspCompilerInstance compInst = compiler.getCompilerInstance(path, uri, className);
        JspGenerator gen = compInst.generate();
        if (!gen.isStatic()) {
            pendingClasses.add(className.replace('.', '/') + ".java");
        }
    }

    public class ApplicationConfig {
        private Path _rootDir;
        private ContainerProgram _program = new ContainerProgram();

        ApplicationConfig() {
            this._rootDir = Vfs.lookup();
        }

        public void setRootDirectory(Path path) {
            this._rootDir = path;
        }

        public void setDocumentDirectory(Path path) {
            this._rootDir = path;
        }

        public void setAppDir(Path path) {
            this._rootDir = path;
        }

        public void addBuilderProgram(ConfigProgram program) {
            this._program.addProgram(program);
        }

        @PostConstruct
        public void init() throws Exception {
            WebApp webApp = JspCompiler.this.createWebApp(this._rootDir);
            if (webApp == null) {
                throw new NullPointerException();
            }
            this._program.configure(webApp);
            Config.init(webApp);
            webApp.init();
            webApp.start();
        }
    }
}

