/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.JspCompiler;
import com.caucho.jsp.JspCompilerInstance;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.java.TagTaglib;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagInfo;

public class TagFileManager {
    static final L10N L = new L10N(TagFileManager.class);
    private static final Logger log = Log.open(TagFileManager.class);
    private JspCompiler _jspCompiler;

    public TagFileManager(JspCompiler compiler) {
        this._jspCompiler = compiler;
    }

    public TagInfo getTag(String prefix, String shortName, String location) throws JspParseException {
        if (location == null) {
            return null;
        }
        try {
            String originalLocation = location;
            if (location.startsWith("urn:jsptagdir:")) {
                location = location.substring("urn:jsptagdir:".length());
            }
            TagTaglib taglib = new TagTaglib(prefix, originalLocation);
            String uri = location;
            TagInfo tag = null;
            try {
                tag = this.getTag(uri, taglib);
                if (tag != null) {
                    return tag;
                }
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            if (!location.endsWith("/")) {
                location = location + "/";
            }
            if ((tag = this.getTag(uri = location + shortName + ".tag", taglib)) != null) {
                return tag;
            }
            uri = location + shortName + ".tagx";
            return this.getTag(uri, taglib);
        }
        catch (Exception e) {
            throw JspParseException.create(e);
        }
    }

    public TagInfo getTag(String prefix, String location) throws JspParseException {
        TagTaglib taglib = new TagTaglib(prefix, location);
        return this.getTag(location, taglib);
    }

    public TagInfo getTag(String location, TagTaglib taglib) throws JspParseException {
        JspResourceManager resourceManager = this._jspCompiler.getResourceManager();
        if (resourceManager == null) {
            return null;
        }
        Path path = resourceManager.resolvePath(location);
        return this.getTag(path, location, taglib);
    }

    public TagInfo getTag(Path path, String prefix, String location) throws JspParseException {
        TagTaglib taglib = new TagTaglib(prefix, location);
        return this.getTag(path, location, taglib);
    }

    public TagInfo getTag(Path path, String location, TagTaglib taglib) throws JspParseException {
        if (path == null || !path.canRead()) {
            return null;
        }
        try {
            if (location.endsWith(".tag")) {
                JspCompilerInstance tagCompiler = this._jspCompiler.getCompilerInstance(path, location);
                tagCompiler.setXML(false);
                return tagCompiler.compileTag(taglib);
            }
            if (location.endsWith(".tagx")) {
                JspCompilerInstance tagCompiler = this._jspCompiler.getCompilerInstance(path, location);
                tagCompiler.setXML(true);
                return tagCompiler.compileTag(taglib);
            }
            throw new JspParseException(L.l("tag file '{0}' must end with .tag or .tagx", (Object)location));
        }
        catch (Exception e) {
            throw JspParseException.create(e);
        }
    }

    public Class loadClass(String className) throws Exception {
        Path classDir = this._jspCompiler.getClassDir();
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        DynamicClassLoader jspLoader = SimpleLoader.create(parentLoader, classDir, null);
        return Class.forName(className, false, jspLoader);
    }
}

