/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.PathPatternType;
import com.caucho.jsp.JspLineParseException;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.cfg.JsfTldPreload;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.jsp.cfg.TldPreload;
import com.caucho.jsp.cfg.TldTaglib;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.ZipScanner;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TldManager {
    static final L10N L = new L10N(TldManager.class);
    private static final Logger log = Logger.getLogger(TldManager.class.getName());
    private static ArrayList<TldPreload> _cauchoTaglibs;
    private static ArrayList<TldPreload> _globalTaglibs;
    private static ArrayList<Path> _globalPaths;
    private static EnvironmentLocal<TldManager> _localManager;
    private JspResourceManager _resourceManager;
    private WebApp _webApp;
    private HashMap<Path, SoftReference<TldTaglib>> _tldMap = new HashMap();
    private JspParseException _loadAllTldException;
    private String _tldDir;
    private FileSetType _tldFileSet;
    private boolean _isFastJsf = false;
    private volatile boolean _isInit;
    private Config _config = new Config();
    private ArrayList<TldPreload> _preloadTaglibs;

    private TldManager(JspResourceManager resourceManager, WebApp app) throws JspParseException, IOException {
        JspPropertyGroup jsp;
        this._resourceManager = resourceManager;
        this._webApp = app;
        if (app != null && (jsp = app.getJsp()) != null) {
            this._tldFileSet = jsp.getTldFileSet();
        }
        this.initGlobal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TldManager create(JspResourceManager resourceManager, WebApp webApp) throws JspParseException, IOException {
        TldManager manager = null;
        ClassLoader loader = webApp != null ? webApp.getClassLoader() : Thread.currentThread().getContextClassLoader();
        EnvironmentLocal<TldManager> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            manager = _localManager.getLevel(loader);
            if (manager != null) {
                return manager;
            }
            manager = new TldManager(resourceManager, webApp);
            _localManager.set(manager, loader);
        }
        return manager;
    }

    void setWebApp(WebApp webApp) {
        this._webApp = webApp;
    }

    public String getSchema() {
        return "com/caucho/jsp/cfg/jsp-tld.rnc";
    }

    public void setTldDir(String tldDir) {
        this._tldDir = tldDir;
    }

    public void setTldFileSet(FileSetType tldFileSet) {
        this._tldFileSet = tldFileSet;
    }

    public synchronized void init() throws JspParseException, IOException {
        int i;
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        log.fine("Loading .tld files");
        String dir = this._tldDir == null ? "WEB-INF" : (this._tldDir.startsWith("/") ? this._tldDir.substring(1) : (this._tldDir.startsWith("WEB-INF") ? this._tldDir : "WEB-INF/" + this._tldDir));
        FileSetType fileSet = this._tldFileSet;
        if (fileSet == null) {
            fileSet = new FileSetType();
            fileSet.setDir(this._resourceManager.resolvePath(dir));
            fileSet.addInclude(new PathPatternType("**/*.tld"));
            fileSet.addInclude(new PathPatternType("**/*.ftld"));
            try {
                fileSet.init();
            }
            catch (Exception e) {
                log.config(e.toString());
            }
        }
        ArrayList<TldPreload> taglibs = new ArrayList<TldPreload>();
        taglibs.addAll(_globalTaglibs);
        ArrayList<Path> paths = this.getClassPath();
        for (i = 0; i < paths.size(); ++i) {
            Path subPath = paths.get(i);
            if (_globalPaths.contains(subPath)) continue;
            if (subPath instanceof JarPath) {
                this.loadJarTlds(taglibs, ((JarPath)subPath).getContainer(), "META-INF");
                continue;
            }
            if (subPath.getPath().endsWith(".jar")) {
                this.loadJarTlds(taglibs, subPath, "META-INF");
                continue;
            }
            this.loadAllTlds(taglibs, subPath.lookup("META-INF"), 64, "META-INF");
        }
        if (fileSet != null) {
            this.loadAllTlds(taglibs, fileSet);
        }
        taglibs.addAll(_cauchoTaglibs);
        this._preloadTaglibs = taglibs;
        for (i = 0; i < taglibs.size(); ++i) {
            try {
                taglibs.get(i).initListeners(this._webApp);
                continue;
            }
            catch (Exception e) {
                throw new JspParseException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initGlobal() {
        if (_globalTaglibs == null) {
            if (!CurrentTime.isTest()) {
                log.info("Loading .tld files from global classpath");
            }
            ArrayList<TldPreload> globalTaglibs = new ArrayList<TldPreload>();
            ArrayList<TldPreload> cauchoTaglibs = new ArrayList<TldPreload>();
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            ClassLoader globalLoader = TldManager.class.getClassLoader();
            thread.setContextClassLoader(globalLoader);
            try {
                ArrayList<Path> paths = this.getClassPath(globalLoader);
                _globalPaths = paths;
                this.loadClassPathTlds(globalTaglibs, paths, "");
                for (int i = globalTaglibs.size() - 1; i >= 0; --i) {
                    String tldPathName;
                    TldPreload tld = globalTaglibs.get(i);
                    if (tld.getPath() == null || tld.getPath().getPath() == null || !(tldPathName = tld.getPath().getPath()).startsWith("/com/caucho")) continue;
                    cauchoTaglibs.add(globalTaglibs.remove(i));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
            _globalTaglibs = globalTaglibs;
            _cauchoTaglibs = cauchoTaglibs;
        }
    }

    private void loadClassPathTlds(ArrayList<TldPreload> taglibs, ArrayList<Path> paths, String prefix) throws JspParseException, IOException {
        for (int i = 0; i < paths.size(); ++i) {
            Path subPath = paths.get(i);
            String pathName = subPath.getFullPath();
            if (pathName.endsWith("/jre/lib/rt.jar") || pathName.endsWith("/jre/lib/charsets.jar") || pathName.endsWith("/jre/lib/deploy.jar")) continue;
            if (subPath.getPath().endsWith(".jar")) {
                this.loadJarTlds(taglibs, subPath, prefix);
                continue;
            }
            if (prefix != null && !prefix.equals("")) {
                this.loadAllTlds(taglibs, subPath.lookup(prefix), 64, prefix);
                continue;
            }
            this.loadAllTlds(taglibs, subPath.lookup("META-INF"), 64, "META-INF");
        }
    }

    private void loadAllTlds(ArrayList<TldPreload> taglibs, FileSetType fileSet) throws JspParseException, IOException {
        for (Path path : fileSet.getPaths()) {
            if (path.getPath().startsWith(".") || !path.getPath().endsWith(".tld") && !path.getPath().endsWith(".ftld") || !path.isFile() || !path.canRead()) continue;
            try {
                TldPreload taglib = this.parseTldPreload(path);
                taglibs.add(taglib);
                if (taglib.getURI() != null || taglib.getConfigException() == null || this._loadAllTldException != null) continue;
                this._loadAllTldException = new JspLineParseException(taglib.getConfigException());
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
        }
    }

    private void loadAllTlds(ArrayList<TldPreload> taglibs, Path path, int depth, String userPath) throws JspParseException, IOException {
        if (depth < 0) {
            throw new JspParseException(L.l("max depth exceeded while reading .tld files.  Probable loop in filesystem detected at `{0}'.", (Object)path));
        }
        path.setUserPath(userPath);
        if (!path.getPath().startsWith(".")) {
            if ((path.getPath().endsWith(".tld") || path.getPath().endsWith(".ftld")) && path.isFile() && path.canRead()) {
                try {
                    TldPreload taglib = this.parseTldPreload(path);
                    taglibs.add(taglib);
                    if (taglib.getURI() == null && taglib.getConfigException() != null && this._loadAllTldException == null) {
                        this._loadAllTldException = new JspLineParseException(taglib.getConfigException());
                    }
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                }
            } else if (path.isDirectory()) {
                String[] fileNames = path.list();
                for (int i = 0; fileNames != null && i < fileNames.length; ++i) {
                    String name = fileNames[i];
                    ArrayList<Path> resources = path.getResources("./" + name);
                    for (int j = 0; resources != null && j < resources.size(); ++j) {
                        Path subpath = resources.get(j);
                        this.loadAllTlds(taglibs, subpath, depth - 1, userPath + "/" + name);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJarTlds(ArrayList<TldPreload> taglibs, Path jarBacking, String prefix) throws JspParseException, IOException {
        if (!jarBacking.canRead()) {
            return;
        }
        JarPath jar = JarPath.create(jarBacking);
        ArrayList<Path> tldPaths = new ArrayList<Path>();
        boolean isValidScan = false;
        ZipScanner scan = null;
        try {
            scan = new ZipScanner(jarBacking);
            if (scan != null && scan.open()) {
                while (scan.next()) {
                    String name = scan.getName();
                    if ((!name.startsWith(prefix) || !name.endsWith(".tld")) && !name.endsWith(".ftld")) continue;
                    tldPaths.add(jar.lookup(name));
                }
                isValidScan = true;
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, e.toString(), e);
        }
        if (!isValidScan) {
            ZipFile zipFile = jar.getJar().getZipFile();
            try {
                Enumeration<? extends ZipEntry> en = zipFile.entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(prefix) || !name.endsWith(".tld") && !name.endsWith(".ftld")) continue;
                    tldPaths.add(jar.lookup(name));
                }
            }
            finally {
                jar.getJar().closeZipFile(zipFile);
            }
        }
        for (Path path : tldPaths) {
            try {
                TldPreload taglib = this.parseTldPreload(path);
                taglibs.add(taglib);
                if (taglib.getURI() != null || taglib.getConfigException() == null || this._loadAllTldException != null) continue;
                this._loadAllTldException = new JspLineParseException(taglib.getConfigException());
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
        }
    }

    TldTaglib parseTld(String uri, String mapLocation, String location) throws JspParseException, IOException {
        this.init();
        TldTaglib taglib = null;
        TldTaglib jsfTaglib = null;
        for (int i = 0; i < this._preloadTaglibs.size(); ++i) {
            TldPreload preload = this._preloadTaglibs.get(i);
            if (!uri.equals(preload.getURI()) || mapLocation != null && !mapLocation.equals(preload.getLocation()) && !mapLocation.equals(uri)) continue;
            if (preload.isJsf()) {
                if (!this._isFastJsf) continue;
                jsfTaglib = this.parseTld(preload.getPath());
                continue;
            }
            if (taglib != null) continue;
            taglib = this.parseTld(preload.getPath());
        }
        if (jsfTaglib != null && taglib != null) {
            taglib.mergeJsf(jsfTaglib);
            return taglib;
        }
        if (taglib != null) {
            return taglib;
        }
        return this.parseTld(location);
    }

    TldTaglib parseTld(String location) throws JspParseException, IOException {
        this.init();
        TldTaglib tld = this.findTld(location);
        return tld;
    }

    private TldTaglib findTld(String location) throws JspParseException, IOException {
        Path path;
        Object is = null;
        if (location.startsWith("file:")) {
            path = this._resourceManager.resolvePath(location);
        } else {
            if (location.indexOf(58) >= 0 && !location.startsWith("file:") && location.indexOf(58) < location.indexOf(47)) {
                if (this._loadAllTldException != null) {
                    throw this._loadAllTldException;
                }
                return null;
            }
            path = location.startsWith("WEB-INF/") ? this._resourceManager.resolvePath(location) : (!location.startsWith("/") ? this._resourceManager.resolvePath("WEB-INF/" + location) : this._resourceManager.resolvePath("." + location));
        }
        path.setUserPath(location);
        JarPath jar = null;
        if (location.endsWith(".jar")) {
            path = this.findJar(location);
            if (path != null && path.exists()) {
                jar = JarPath.create(path);
                if (jar.lookup("META-INF/taglib.tld").exists()) {
                    return this.parseTld(jar.lookup("META-INF/taglib.tld"));
                }
                if (jar.lookup("meta-inf/taglib.tld").exists()) {
                    return this.parseTld(jar.lookup("meta-inf/taglib.tld"));
                }
                throw new JspParseException(L.l("can't find META-INF/taglib.tld in `{0}'", (Object)location));
            }
            throw new JspParseException(L.l("Can't find taglib `{0}'.  A taglib uri ending in *.jar must point to an actual jar or match a URI in a .tld file.", (Object)location));
        }
        if (path.exists() && path.canRead() && path.isFile()) {
            return this.parseTld(path);
        }
        if (this._loadAllTldException != null) {
            throw this._loadAllTldException;
        }
        throw new JspParseException(L.l("Can't find taglib-location `{0}'.  The taglib-location must match a tag library either:\n1) by pointing to a .tld directly, relative to the application's root directory\n2) specified in the web.xml\n3) defined in a jar's .tld in META-INF\n4) defined in a .tld in WEB-INF\n5) predefined by Resin", (Object)location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldTaglib parseTld(Path path) throws JspParseException, IOException {
        TldTaglib taglib;
        SoftReference<TldTaglib> taglibRef = this._tldMap.get(path);
        if (taglibRef != null && (taglib = taglibRef.get()) != null && !taglib.isModified()) {
            return taglib;
        }
        ReadStream is = path.openRead();
        try {
            taglib = this.parseTld(is);
            if (path instanceof JarPath) {
                taglib.setJarPath(path.lookup("/"));
            }
            this._tldMap.put(path, new SoftReference<TldTaglib>(taglib));
            TldTaglib tldTaglib = taglib;
            return tldTaglib;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldTaglib parseTld(InputStream is) throws JspParseException, IOException {
        TldTaglib taglib = new TldTaglib();
        if (is instanceof ReadStream) {
            Path path = ((ReadStream)is).getPath();
            path.setUserPath(path.getURL());
        }
        String schema = null;
        if (this._webApp.getJsp() == null || this._webApp.getJsp().isValidateTaglibSchema()) {
            schema = this.getSchema();
        }
        try {
            Config config = new Config();
            config.setEL(false);
            config.configure((Object)taglib, is, schema);
        }
        catch (ConfigException e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            taglib.setConfigException(e);
        }
        catch (Exception e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            taglib.setConfigException(e);
        }
        finally {
            is.close();
        }
        return taglib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldPreload parseTldPreload(Path path) throws JspParseException, IOException {
        ReadStream is = path.openRead();
        try {
            TldPreload taglib = this.parseTldPreload(is);
            taglib.setPath(path);
            String appDir = this._webApp.getRootDirectory().getPath();
            String tagPath = path.getPath();
            if (tagPath.startsWith(appDir)) {
                taglib.setLocation(tagPath.substring(appDir.length()));
            }
            TldPreload tldPreload = taglib;
            return tldPreload;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldPreload parseTldPreload(InputStream is) throws JspParseException, IOException {
        boolean isJsfTld = false;
        if (is instanceof ReadStream) {
            Path path = ((ReadStream)is).getPath();
            isJsfTld = path.getPath().endsWith(".ftld");
            path.setUserPath(path.getURL());
        }
        String schema = null;
        if (this._webApp.getJsp() == null || this._webApp.getJsp().isValidateTaglibSchema()) {
            schema = this.getSchema();
        }
        TldPreload taglib = isJsfTld ? new JsfTldPreload() : new TldPreload();
        try {
            this._config.configure((Object)taglib, is, schema);
        }
        catch (ConfigException e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            taglib.setConfigException(e);
        }
        catch (Exception e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            taglib.setConfigException(e);
        }
        finally {
            is.close();
        }
        return taglib;
    }

    private Path findJar(String location) {
        String sub;
        Path path = location.startsWith("file:") ? Vfs.lookup(location) : (location.startsWith("/") ? this._resourceManager.resolvePath("." + location) : this._resourceManager.resolvePath(location));
        if (path.exists()) {
            return path;
        }
        DynamicClassLoader loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        String classPath = loader.getClassPath();
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while ((tail = classPath.indexOf(sep, head)) >= 0) {
            sub = classPath.substring(head, tail);
            path = Vfs.lookup(sub);
            if (sub.endsWith(location) && path.exists()) {
                return path;
            }
            head = tail + 1;
        }
        if (classPath.length() <= head) {
            return null;
        }
        sub = classPath.substring(head);
        path = Vfs.lookup(sub);
        if (sub.endsWith(location) && path.exists()) {
            return path;
        }
        return null;
    }

    private ArrayList<Path> getClassPath() {
        return this.getClassPath(Thread.currentThread().getContextClassLoader());
    }

    private ArrayList<Path> getClassPath(ClassLoader loader) {
        String classpath = null;
        classpath = loader instanceof DynamicClassLoader ? ((DynamicClassLoader)loader).getClassPath() : CauchoSystem.getClassPath();
        return this.getClassPath(classpath);
    }

    private ArrayList<Path> getClassPath(String classpath) {
        ArrayList<Path> list = new ArrayList<Path>();
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while (head < classpath.length()) {
            Path path;
            tail = classpath.indexOf(sep, head);
            String segment = null;
            if (tail < 0) {
                segment = classpath.substring(head);
                head = classpath.length();
            } else {
                segment = classpath.substring(head, tail);
                head = tail + 1;
            }
            if (segment.equals("") || list.contains(path = Vfs.lookup(segment))) continue;
            list.add(path);
        }
        return list;
    }

    static {
        _localManager = new EnvironmentLocal();
    }
}

