/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.BodyContentImpl;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.server.http.CauchoResponse;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.FlushBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.el.ELContext;
import javax.el.ELException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ImportTag
extends BodyTagSupport
implements NameValueTag {
    private static L10N L = new L10N(ImportTag.class);
    private Expr _urlExpr;
    private Expr _contextExpr;
    private CharBuffer _query = new CharBuffer();
    private Expr _charEncodingExpr;
    private String _var;
    private String _scope;
    private String _varReader;
    private Reader _reader;

    public void setURL(Expr url) {
        this._urlExpr = url;
    }

    public void setContext(Expr context) {
        this._contextExpr = context;
    }

    public void addParam(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if (this._query.length() != 0) {
            this._query.append('&');
        }
        this._query.append(name);
        this._query.append('=');
        int len = value.length();
        block6: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '&': {
                    this._query.append("%26");
                    continue block6;
                }
                case '%': {
                    this._query.append("%25");
                    continue block6;
                }
                case '+': {
                    this._query.append("%2b");
                    continue block6;
                }
                case '=': {
                    this._query.append("%3d");
                    continue block6;
                }
                default: {
                    this._query.append(ch);
                }
            }
        }
    }

    public void setCharEncoding(Expr charEncoding) {
        this._charEncodingExpr = charEncoding;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setVarReader(String varReader) {
        this._varReader = varReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doStartTag() throws JspException {
        int body2;
        BodyContent jspWriter = null;
        this._query.clear();
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        try {
            try {
                if (this._varReader != null) {
                    jspWriter = pageContext.pushBody();
                    this.handleBody();
                    BodyContentImpl body2 = (BodyContentImpl)pageContext.getOut();
                    this._reader = body2.getReader();
                    pageContext.setAttribute(this._varReader, this._reader);
                    int n = 1;
                    Object var6_8 = null;
                    if (jspWriter == null) return n;
                    pageContext.popBody();
                    return n;
                }
                body2 = 2;
            }
            catch (JspException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JspException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (jspWriter == null) throw throwable;
            pageContext.popBody();
            throw throwable;
        }
        Object var6_9 = null;
        if (jspWriter == null) return body2;
        pageContext.popBody();
        return body2;
    }

    public int doEndTag() throws JspException {
        if (this._varReader == null) {
            try {
                BodyContent jspWriter = this.pageContext.pushBody();
                this.handleBody();
                BodyContentImpl body = (BodyContentImpl)this.pageContext.getOut();
                if (this._var != null) {
                    String value = body.getString();
                    this.pageContext.popBody();
                    CoreSetTag.setValue(this.pageContext, this._var, this._scope, value);
                } else {
                    body.writeOut(body.getEnclosingWriter());
                    this.pageContext.popBody();
                }
            }
            catch (JspException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JspException(e);
            }
        }
        return 6;
    }

    private void handleBody() throws JspException, ServletException, IOException, ELException {
        JspWriter out;
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        ELContext env = pageContext.getELContext();
        String url = this._urlExpr.evalString(env);
        if (url == null || url.equals("")) {
            throw new JspTagException(L.l("URL may not be null for `{0}'", (Object)this._urlExpr));
        }
        if (this._query != null && this._query.getLength() != 0) {
            url = url.indexOf(63) > 0 ? url + '&' + this._query : url + '?' + this._query;
        }
        if ((out = pageContext.getOut()) instanceof FlushBuffer) {
            ((FlushBuffer)((Object)out)).flushBuffer();
        } else {
            out.flush();
        }
        if (this._contextExpr != null) {
            String context = this._contextExpr.evalString(env);
            if (!url.startsWith("/")) {
                throw new JspException(L.l("URL `{0}' must start with `/' with context `{0}'", (Object)url, (Object)context));
            }
            if (context != null && context.startsWith("/")) {
                ServletContext app = pageContext.getServletContext().getContext(context);
                try {
                    RequestDispatcher disp = app.getRequestDispatcher(url);
                    if (disp == null) {
                        throw new JspException(L.l("URL `{0}' does not map to any servlet", (Object)url));
                    }
                    CauchoResponse response = (CauchoResponse)pageContext.getResponse();
                    response.getResponseStream().setEncoding(null);
                    disp.include(pageContext.getRequest(), response);
                }
                catch (FileNotFoundException e) {
                    throw new JspException(L.l("`{0}' is an unknown file or servlet.", (Object)url));
                }
            } else {
                this.handleExternalBody(context + url);
            }
            return;
        }
        int colon = url.indexOf(58);
        int slash = url.indexOf(47);
        if (slash == 0 || colon < 0 || slash < 0 || slash < colon) {
            HttpServletRequest request = pageContext.getRequest();
            try {
                RequestDispatcher disp = request.getRequestDispatcher(url);
                if (disp == null) {
                    throw new JspException(L.l("URL `{0}' does not map to any servlet", (Object)url));
                }
                CauchoResponse response = (CauchoResponse)pageContext.getResponse();
                response.getResponseStream().setEncoding(null);
                disp.include(pageContext.getRequest(), response);
            }
            catch (FileNotFoundException e) {
                throw new JspException(L.l("URL `{0}' is an unknown file or servlet.", (Object)url));
            }
        } else {
            this.handleExternalBody(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExternalBody(String url) throws JspException, ServletException, IOException, ELException {
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        ELContext env = pageContext.getELContext();
        URL netURL = new URL(url);
        URLConnection conn = netURL.openConnection();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection cfr_ignored_0 = (HttpURLConnection)conn;
            HttpURLConnection.setFollowRedirects(true);
        }
        InputStream is = conn.getInputStream();
        try {
            int ch;
            int p;
            ReadStream in = Vfs.openRead(is);
            String encoding = conn.getContentEncoding();
            String contentType = conn.getContentType();
            if (this._charEncodingExpr != null) {
                encoding = this._charEncodingExpr.evalString(env);
                if (encoding != null && !encoding.equals("")) {
                    in.setEncoding(encoding);
                }
            } else if (encoding != null) {
                in.setEncoding(encoding);
            } else if (contentType != null && (p = contentType.indexOf("charset=")) > 0) {
                CharBuffer cb = new CharBuffer();
                for (int i = p + 8; i < contentType.length(); ++i) {
                    char ch2 = contentType.charAt(i);
                    if (ch2 == '\"' || ch2 == '\'') continue;
                    if (ch2 >= 'a' && ch2 <= 'z') {
                        cb.append(ch2);
                        continue;
                    }
                    if (ch2 >= 'A' && ch2 <= 'Z') {
                        cb.append(ch2);
                        continue;
                    }
                    if (ch2 >= '0' && ch2 <= '9') {
                        cb.append(ch2);
                        continue;
                    }
                    if (ch2 != '-' && ch2 != '_') break;
                    cb.append(ch2);
                }
                encoding = cb.toString();
                in.setEncoding(encoding);
            }
            JspWriter out = pageContext.getOut();
            while ((ch = in.readChar()) >= 0) {
                out.print((char)ch);
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            is.close();
            throw throwable;
        }
        is.close();
    }
}

