/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.junit;

import com.caucho.config.inject.InjectManager;
import com.caucho.junit.ResinBeanConfiguration;
import com.caucho.resin.BeanContainerRequest;
import com.caucho.resin.ResinBeanContainer;
import java.lang.annotation.Annotation;
import java.net.URL;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResinBeanContainerRunner
extends BlockJUnit4ClassRunner {
    private Class<?> _testClass;
    private String _testClassModule;
    private ResinBeanContainer _beanContainer;
    private ResinBeanConfiguration _beanConfiguration;

    public ResinBeanContainerRunner(Class<?> testClass) throws Throwable {
        super(testClass);
        this._testClass = testClass;
        this._testClassModule = this.getTestClassModule(this._testClass);
        this._beanConfiguration = testClass.getAnnotation(ResinBeanConfiguration.class);
    }

    protected Object createTest() throws Exception {
        InjectManager manager = this.getResinContext().getInstance(InjectManager.class, new Annotation[0]);
        return manager.createTransientObject(this._testClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        ResinBeanContainer beanContainer = this.getResinContext();
        BeanContainerRequest request = beanContainer.beginRequest();
        try {
            super.runChild(method, notifier);
        }
        finally {
            request.close();
        }
    }

    protected ResinBeanContainer getResinContext() {
        if (this._beanContainer == null) {
            this._beanContainer = new ResinBeanContainer();
            this._beanContainer.setWorkDirectory(System.getProperty("java.io.tmpdir"));
            this._beanContainer.setModule(this._testClassModule);
            this.addPackageModule();
            if (this._beanConfiguration != null) {
                for (String path : this._beanConfiguration.classPath()) {
                    this._beanContainer.addClassPath(path);
                }
                for (String conf : this._beanConfiguration.beansXml()) {
                    this._beanContainer.addBeansXml(conf);
                }
            }
            this._beanContainer.start();
        }
        return this._beanContainer;
    }

    private void addPackageModule() {
        String testPackage;
        ClassLoader loader = this._testClass.getClassLoader();
        URL url = loader.getResource((testPackage = this._testClass.getPackage().getName()).replace('.', '/') + "/META-INF");
        if (url != null) {
            this._beanContainer.addPackageModule(this._testClassModule, testPackage);
        }
        if ((url = loader.getResource(testPackage.replace('.', '/') + "/beans.xml")) != null) {
            this._beanContainer.addPackageModule(this._testClassModule, testPackage);
        }
    }

    private String getTestClassModule(Class<?> testClass) {
        String testClassName = testClass.getName().replace('.', '/') + ".class";
        String packageName = Thread.currentThread().getContextClassLoader().getResource(testClassName).toString();
        if ((packageName = packageName.substring(0, packageName.indexOf(testClassName))).indexOf(33) != -1) {
            packageName = packageName.substring(packageName.indexOf(33));
        }
        packageName = packageName.substring(packageName.indexOf("file:") + 5);
        return packageName;
    }
}

