/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.JarLoader;
import com.caucho.loader.Loader;
import com.caucho.loader.PathLoader;
import com.caucho.loader.RootDynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.TempDynamicClassLoader;
import com.caucho.loader.WeakCloseListener;
import com.caucho.loader.WeakLoaderListener;
import com.caucho.loader.ZombieClassLoaderMarker;
import com.caucho.loader.enhancer.EnhancerRuntimeException;
import com.caucho.make.AlwaysModified;
import com.caucho.make.DependencyContainer;
import com.caucho.make.Make;
import com.caucho.make.MakeContainer;
import com.caucho.management.server.DynamicClassLoaderMXBean;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.TimedCache;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClassLoader
extends URLClassLoader
implements Dependency,
Make,
DynamicClassLoaderMXBean {
    private static L10N _L;
    private static Logger _log;
    private static final URL NULL_URL;
    private static final URL[] NULL_URL_ARRAY;
    private static long _globalDependencyCheckInterval;
    private static boolean _isJarCacheEnabled;
    private String _id;
    private final boolean _isVerbose;
    private int _verboseDepth;
    private ArrayList<Loader> _loaders = new ArrayList();
    private JarLoader _jarLoader;
    private PathLoader _pathLoader;
    private boolean _isDirectoryLoader;
    private ArrayList<Path> _nativePath = new ArrayList();
    private ConcurrentHashMap<String, ClassEntry> _entryCache = new ConcurrentHashMap(8);
    private TimedCache<String, URL> _resourceCache;
    private boolean _isDisableURLs;
    private DependencyContainer _dependencies = new DependencyContainer(this);
    private boolean _isEnableDependencyCheck = false;
    private MakeContainer _makeList;
    private boolean _useServletHack;
    private String[] _parentPriorityPackages;
    private String[] _priorityPackages;
    private ArrayList<ClassLoaderListener> _listeners = new ArrayList();
    private ArrayList<Permission> _permissions;
    private CodeSource _codeSource;
    private ArrayList<ClassFileTransformer> _classFileTransformerList;
    private URL[] _urls = NULL_URL_ARRAY;
    private WeakCloseListener _closeListener;
    private final Lifecycle _lifecycle = new Lifecycle();
    private ZombieClassLoaderMarker _zombieMarker;
    private boolean _hasNewLoader = true;
    private final AtomicBoolean _isScanning = new AtomicBoolean();
    private static final ListenerComparator LISTENER_SORT;

    public DynamicClassLoader(ClassLoader parent) {
        this(parent, true, false);
    }

    public DynamicClassLoader(ClassLoader parent, boolean enableDependencyCheck, boolean isRoot) {
        super(NULL_URL_ARRAY, DynamicClassLoader.getInitParent(parent, isRoot));
        parent = this.getParent();
        this._isEnableDependencyCheck = enableDependencyCheck;
        this._dependencies.setCheckInterval(_globalDependencyCheckInterval);
        if (!CurrentTime.isTest()) {
            this._dependencies.setAsync(true);
        }
        while (parent != null) {
            if (!(parent instanceof RootDynamicClassLoader) && parent instanceof DynamicClassLoader) {
                DynamicClassLoader loader = (DynamicClassLoader)parent;
                loader.init();
                this.addPermissions(loader.getPermissions());
                this._dependencies.add(loader);
                this._dependencies.setCheckInterval(loader.getDependencyCheckInterval());
                this._useServletHack = loader._useServletHack;
                break;
            }
            parent = parent.getParent();
        }
        if (System.getProperty("resin.verbose.classpath") != null) {
            this._isVerbose = true;
            int depth = 0;
            while (parent != null) {
                ++depth;
                parent = parent.getParent();
            }
            this._verboseDepth = depth;
        } else {
            this._isVerbose = false;
        }
    }

    private static ClassLoader getInitParent(ClassLoader parent, boolean isRoot) {
        if (parent == null) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        if (isRoot || parent instanceof DynamicClassLoader) {
            return parent;
        }
        return RootDynamicClassLoader.create(parent);
    }

    public static boolean isJarCacheEnabledDefault() {
        return _isJarCacheEnabled;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isJarCacheEnabled() {
        return DynamicClassLoader.isJarCacheEnabledDefault();
    }

    public static void setJarCacheEnabled(boolean isEnabled) {
        _isJarCacheEnabled = isEnabled;
    }

    private void verbose(String name, String msg) {
        if (this._isVerbose) {
            for (int i = this._verboseDepth; i > 0; --i) {
                System.err.print(' ');
            }
            System.err.println(this.toString() + " " + name + " " + msg);
        }
    }

    public static long getGlobalDependencyCheckInterval() {
        return _globalDependencyCheckInterval;
    }

    public static void setGlobalDependencyCheckInterval(long interval) {
        if (interval < 0L) {
            interval = Integer.MAX_VALUE;
        }
        _globalDependencyCheckInterval = interval;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public boolean isDirectoryLoader() {
        if (this._isDirectoryLoader) {
            return true;
        }
        ClassLoader parent = this.getParent();
        if (parent instanceof DynamicClassLoader) {
            return ((DynamicClassLoader)parent).isDirectoryLoader();
        }
        return false;
    }

    public void addLoader(Loader loader) {
        int p = this._loaders.indexOf(loader);
        if (p >= 0) {
            Loader oldLoader = this._loaders.get(p);
            if (oldLoader != loader) {
                this.addLoader(loader, p);
            }
        } else {
            this.addLoader(loader, this._loaders.size());
        }
        this._hasNewLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoader(Loader loader) {
        ArrayList<Loader> arrayList = this._loaders;
        synchronized (arrayList) {
            for (int i = this._loaders.size() - 1; i >= 0; --i) {
                if (this._loaders.get(i) != loader) continue;
                this._loaders.remove(i);
            }
        }
    }

    public void addLoader(Loader loader, int offset) {
        if (this._lifecycle.isDestroyed()) {
            throw new IllegalStateException(DynamicClassLoader.L().l("can't add loaders after initialization"));
        }
        if (DynamicClassLoader.log().isLoggable(Level.FINEST)) {
            DynamicClassLoader.log().finest(this + " adding loader " + loader);
        }
        this._loaders.add(offset, loader);
        if (loader.getClassLoader() == null) {
            loader.setLoader(this);
        } else assert (loader.getClassLoader() == this);
        if (loader instanceof Dependency) {
            this._dependencies.add((Dependency)((Object)loader));
        }
        if (loader instanceof Make) {
            if (this._makeList == null) {
                this._makeList = new MakeContainer();
            }
            this._makeList.add((Make)((Object)loader));
        }
        if (loader instanceof ClassLoaderListener) {
            this.addListener(new WeakLoaderListener((ClassLoaderListener)((Object)loader)));
        }
        if (loader.isDirectoryLoader()) {
            this._isDirectoryLoader = true;
        }
        this._hasNewLoader = true;
    }

    public ArrayList<Loader> getLoaders() {
        return this._loaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJarManifestClassPath(Path path) throws IOException {
        Path contextPath;
        Path manifestPath;
        if (path.isDirectory()) {
            manifestPath = path.lookup("META-INF/MANIFEST.MF");
            contextPath = path;
        } else {
            JarPath jar = JarPath.create(path);
            manifestPath = jar.lookup("META-INF/MANIFEST.MF");
            contextPath = path.getParent();
        }
        if (manifestPath.canRead()) {
            ReadStream is = manifestPath.openRead();
            try {
                try {
                    Manifest manifest = new Manifest(is);
                    Attributes main = manifest.getMainAttributes();
                    String classPath = main.getValue("Class-Path");
                    this.addManifestClassPath(classPath, contextPath);
                }
                catch (IOException e) {
                    DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
                    Object var9_10 = null;
                    is.close();
                    return;
                }
                Object var9_9 = null;
                is.close();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                is.close();
                throw throwable;
            }
        }
    }

    public void addManifestClassPath(String classPath, Path pwd) {
        if (classPath == null) {
            return;
        }
        String[] urls = Pattern.compile("[\\s,]+").split(classPath);
        if (urls == null || urls.length == 0) {
            return;
        }
        for (int i = 0; i < urls.length; ++i) {
            Path jar;
            String url = urls[i];
            if (url.equals("") || !(jar = pwd.lookup(url)).canRead()) continue;
            this.addJar(jar);
        }
        this._hasNewLoader = true;
    }

    public void addNative(Path path) {
        this._nativePath.add(path);
    }

    public void addJar(Path jar) {
        this.addRoot(jar);
    }

    public void addRoot(Path root) {
        if (this._lifecycle.isDestroyed()) {
            throw new IllegalStateException(DynamicClassLoader.L().l("can't add roots after closing"));
        }
        URL url = this.pathToURL(root);
        if (this.containsURL(url)) {
            DynamicClassLoader.log().finer(this + " skipping duplicate URL " + url);
            return;
        }
        if (root instanceof JarPath || root.getPath().endsWith(".jar") || root.getPath().endsWith(".zip")) {
            if (this._jarLoader == null) {
                this._jarLoader = new JarLoader(this);
                this._jarLoader.init();
            }
            this._jarLoader.addJar(root);
        } else {
            SimpleLoader loader = new SimpleLoader(this);
            loader.setPath(root);
            loader.init();
            if (!this._loaders.contains(loader)) {
                this.addLoader(loader);
            }
        }
        this.addURL(root);
    }

    public void addPathClass(String className, Path path) {
        if (this._pathLoader == null) {
            this._pathLoader = new PathLoader();
            this._loaders.add(0, this._pathLoader);
        }
        this._pathLoader.put(className, path);
    }

    public boolean addURL(Path path) {
        URL url = this.pathToURL(path);
        if (url == null) {
            return false;
        }
        if (this.containsURL(url)) {
            return false;
        }
        this.addURL(url);
        return true;
    }

    public void setDisableURLs(boolean isDisable) {
        this._isDisableURLs = isDisable;
    }

    public boolean isDisableURLs() {
        return this._isDisableURLs;
    }

    public boolean containsURL(Path path) {
        URL url = this.pathToURL(path);
        if (url == null) {
            return false;
        }
        return this.containsURL(url);
    }

    private URL pathToURL(Path path) {
        try {
            if (path.getScheme().equals("memory")) {
                return null;
            }
            if (!path.getScheme().equals("jar")) {
                if (path.getFullPath().endsWith(".jar")) {
                    path = JarPath.create(path);
                } else if (!path.getURL().endsWith("/")) {
                    path = path.lookup("./");
                }
            }
            return new URL(path.getURL());
        }
        catch (MalformedURLException e) {
            DynamicClassLoader.log().warning(e.toString());
        }
        catch (Exception e) {
            DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
        }
        return null;
    }

    @Override
    public void addURL(URL url) {
        this.addURL(this._urls.length, url);
    }

    public void addURL(int index, URL url) {
        int i;
        if (this.containsURL(url)) {
            return;
        }
        super.addURL(url);
        URL[] newURLs = new URL[this._urls.length + 1];
        for (i = 0; i < index; ++i) {
            newURLs[i] = this._urls[i];
        }
        newURLs[index] = url;
        for (i = index + 1; i < newURLs.length; ++i) {
            newURLs[i] = this._urls[i - 1];
        }
        this._urls = newURLs;
    }

    public void appendToClassPathForInstrumentation(String path) {
        this.addRoot(Vfs.lookup(path));
    }

    @Override
    public URL[] getURLs() {
        if (this.isDisableURLs()) {
            return new URL[0];
        }
        return this._urls;
    }

    protected boolean containsURL(URL url) {
        ClassLoader parent;
        if (this._urls != null) {
            for (URL testURL : this._urls) {
                if (!url.equals(testURL)) continue;
                return true;
            }
        }
        if ((parent = this.getParent()) instanceof DynamicClassLoader) {
            DynamicClassLoader dynParent = (DynamicClassLoader)parent;
            return dynParent.containsURL(url);
        }
        return false;
    }

    public void setDependencyCheckInterval(long interval) {
        this._dependencies.setCheckInterval(interval);
    }

    public long getDependencyCheckInterval() {
        if (this._dependencies != null) {
            return this._dependencies.getCheckInterval();
        }
        return 0L;
    }

    public void setEnableDependencyCheck(boolean enable) {
        this._isEnableDependencyCheck = enable;
    }

    public void addDependency(Dependency dependency) {
        if (this._dependencies != null) {
            this._dependencies.add(dependency);
        }
    }

    public void addPermission(String path, String actions) {
        this.addPermission(new FilePermission(path, actions));
    }

    public void addPermission(Permission permission) {
        if (this._permissions == null) {
            this._permissions = new ArrayList();
        }
        this._permissions.add(permission);
    }

    public ArrayList<Permission> getPermissions() {
        return this._permissions;
    }

    public void addPermissions(ArrayList<Permission> perms) {
        if (perms == null) {
            return;
        }
        if (this._permissions == null) {
            this._permissions = new ArrayList();
        }
        this._permissions.addAll(perms);
    }

    public void setServletHack(boolean servletHack) {
        this._useServletHack = servletHack;
        if (this._parentPriorityPackages == null) {
            this._parentPriorityPackages = new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(ClassLoaderListener listener) {
        ArrayList<ClassLoaderListener> listeners = this._listeners;
        if (this._lifecycle.isDestroyed() || listeners == null) {
            IllegalStateException e = new IllegalStateException(DynamicClassLoader.L().l("attempted to add listener to a closed classloader {0}", (Object)this));
            DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
            return;
        }
        WeakCloseListener closeListener = null;
        if (listeners != null && listeners.size() == 0) {
            closeListener = new WeakCloseListener(this);
        }
        if (closeListener != null) {
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof DynamicClassLoader)) continue;
                ((DynamicClassLoader)parent).addListener(closeListener);
                break;
            }
        }
        ArrayList<ClassLoaderListener> arrayList = listeners;
        synchronized (arrayList) {
            for (int i = listeners.size() - 1; i >= 0; --i) {
                ClassLoaderListener oldListener = listeners.get(i);
                if (listener == oldListener) {
                    return;
                }
                if (oldListener != null) continue;
                listeners.remove(i);
            }
            listeners.add(listener);
        }
        if (this._lifecycle.isActive()) {
            listener.classLoaderInit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(ClassLoaderListener listener) {
        ArrayList<ClassLoaderListener> listeners = this._listeners;
        if (listeners == null) {
            return;
        }
        ArrayList<ClassLoaderListener> arrayList = listeners;
        synchronized (arrayList) {
            for (int i = listeners.size() - 1; i >= 0; --i) {
                ClassLoaderListener oldListener = listeners.get(i);
                if (listener == oldListener) {
                    listeners.remove(i);
                    return;
                }
                if (oldListener != null) continue;
                listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<ClassLoaderListener> getListeners() {
        ArrayList<ClassLoaderListener> listeners = new ArrayList<ClassLoaderListener>();
        ArrayList<ClassLoaderListener> listenerList = this._listeners;
        if (listenerList != null) {
            ArrayList<ClassLoaderListener> arrayList = listenerList;
            synchronized (arrayList) {
                for (int i = 0; i < listenerList.size(); ++i) {
                    ClassLoaderListener listener = listenerList.get(i);
                    if (listener != null) {
                        listeners.add(listener);
                        continue;
                    }
                    listenerList.remove(i);
                    --i;
                }
            }
        }
        return listeners;
    }

    public final void updateScan() {
        ClassLoader parent = this.getParent();
        if (parent instanceof DynamicClassLoader) {
            DynamicClassLoader dynLoader = (DynamicClassLoader)parent;
            dynLoader.updateScan();
        }
        this.sendAddLoaderEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void sendAddLoaderEvent() {
        if (this._hasNewLoader && this._isScanning.compareAndSet(false, true)) {
            try {
                while (this._hasNewLoader) {
                    this._hasNewLoader = false;
                    this.scan();
                    this.configureEnhancerEvent();
                    this.configurePostEnhancerEvent();
                }
                Object var2_1 = null;
                this._isScanning.set(false);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this._isScanning.set(false);
                throw throwable;
            }
        }
    }

    protected void configureEnhancerEvent() {
    }

    protected void configurePostEnhancerEvent() {
    }

    public void addParentPriorityPackages(String[] pkg) {
        for (int i = 0; pkg != null && i < pkg.length; ++i) {
            this.addParentPriorityPackage(pkg[i]);
        }
    }

    public void addParentPriorityPackage(String pkg) {
        if (this._parentPriorityPackages == null) {
            this._parentPriorityPackages = new String[0];
        }
        int oldLength = this._parentPriorityPackages.length;
        String[] newPkgs = new String[oldLength + 1];
        System.arraycopy(this._parentPriorityPackages, 0, newPkgs, 0, oldLength);
        if (!pkg.endsWith(".")) {
            pkg = pkg + '.';
        }
        newPkgs[oldLength] = pkg;
        this._parentPriorityPackages = newPkgs;
    }

    public void addPriorityPackage(String pkg) {
        if (this._priorityPackages == null) {
            this._priorityPackages = new String[0];
        }
        int oldLength = this._priorityPackages.length;
        String[] newPkgs = new String[oldLength + 1];
        System.arraycopy(this._priorityPackages, 0, newPkgs, 0, oldLength);
        if (!pkg.endsWith(".")) {
            pkg = pkg + '.';
        }
        newPkgs[oldLength] = pkg;
        this._priorityPackages = newPkgs;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection perms = super.getPermissions(codeSource);
        ArrayList<Permission> permissions = this._permissions;
        int size = permissions != null ? permissions.size() : 0;
        for (int i = 0; i < size; ++i) {
            Permission permission = permissions.get(i);
            perms.add(permission);
        }
        return perms;
    }

    protected void addCodeBasePath(String path) {
    }

    public void addTransformer(ClassFileTransformer transformer) {
        if (this._classFileTransformerList == null) {
            this._classFileTransformerList = new ArrayList();
        }
        this._classFileTransformerList.add(transformer);
    }

    protected ArrayList<ClassFileTransformer> getTransformerList() {
        return this._classFileTransformerList;
    }

    public static final String getHash(ClassLoader loader) {
        if (!(loader instanceof DynamicClassLoader)) {
            return loader.getClass().getName();
        }
        DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
        return dynLoader.getHash();
    }

    public String getHash() {
        return String.valueOf(this.getHashCrc());
    }

    public long getHashCrc() {
        long crc64 = this.getParentHashCrc();
        ArrayList<Loader> loaders = this.getLoaders();
        if (loaders != null) {
            for (int i = 0; i < loaders.size(); ++i) {
                Loader loader = loaders.get(i);
                crc64 = loader.getHashCrc(crc64);
            }
        }
        return crc64;
    }

    private long getParentHashCrc() {
        ClassLoader parent = this.getParent();
        if (parent == null) {
            return 0L;
        }
        if (parent instanceof DynamicClassLoader) {
            return ((DynamicClassLoader)parent).getHashCrc();
        }
        return parent.hashCode();
    }

    public final String getClassPath() {
        ArrayList<String> list = new ArrayList<String>();
        this.buildClassPath(list);
        return DynamicClassLoader.toClassPath(list);
    }

    public final void buildClassPath(ArrayList<String> cp) {
        this.buildParentClassPath(cp);
        this.buildSelfClassPath(cp);
    }

    private void buildParentClassPath(ArrayList<String> cp) {
        ClassLoader parent = this.getParent();
        if (parent instanceof DynamicClassLoader) {
            ((DynamicClassLoader)parent).buildClassPath(cp);
        } else {
            cp.addAll(CauchoSystem.getClassPathList());
            while (parent != null) {
                if (parent instanceof URLClassLoader) {
                    URLClassLoader urlLoader = (URLClassLoader)parent;
                    for (URL url : urlLoader.getURLs()) {
                        String urlString = url.toString();
                        if (urlString.startsWith("file:")) {
                            urlString = urlString.substring("file:".length());
                        }
                        if (cp.contains(urlString)) continue;
                        cp.add(urlString);
                    }
                }
                parent = parent.getParent();
            }
        }
    }

    private void buildSelfClassPath(ArrayList<String> cp) {
        this.buildImportClassPath(cp);
        ArrayList<Loader> loaders = this.getLoaders();
        if (loaders != null) {
            for (int i = 0; i < loaders.size(); ++i) {
                Loader loader = loaders.get(i);
                loader.buildClassPath(cp);
            }
        }
    }

    protected void buildImportClassPath(ArrayList<String> sb) {
    }

    public final String getLocalClassPath() {
        ArrayList<String> cp = new ArrayList<String>();
        this.buildClassPath(cp);
        return DynamicClassLoader.toClassPath(cp);
    }

    public final String getSourcePath() {
        ArrayList<String> cp = new ArrayList<String>();
        this.buildSourcePath(cp);
        return DynamicClassLoader.toClassPath(cp);
    }

    protected final void buildSourcePath(ArrayList<String> cp) {
        ClassLoader parent = this.getParent();
        if (parent instanceof DynamicClassLoader) {
            ((DynamicClassLoader)parent).buildSourcePath(cp);
        } else {
            cp.addAll(CauchoSystem.getClassPathList());
        }
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            loader.buildSourcePath(cp);
        }
    }

    public final String getResourcePathSpecificFirst() {
        ArrayList<String> pathList = new ArrayList<String>();
        this.buildResourcePathSpecificFirst(pathList);
        StringBuilder sb = new StringBuilder();
        char sep = CauchoSystem.getPathSeparatorChar();
        if (pathList.size() == 0) {
            return "";
        }
        sb.append(pathList.get(0));
        for (int i = 1; i < pathList.size(); ++i) {
            sb.append(sep);
            sb.append(pathList.get(i));
        }
        return sb.toString();
    }

    protected final void buildResourcePathSpecificFirst(ArrayList<String> pathList) {
        ClassLoader parent = this.getParent();
        ArrayList<Loader> loaders = this.getLoaders();
        int size = loaders != null ? loaders.size() : 0;
        for (int i = 0; i < size; ++i) {
            Loader loader = loaders.get(i);
            loader.buildSourcePath(pathList);
        }
        if (parent instanceof DynamicClassLoader) {
            ((DynamicClassLoader)parent).buildResourcePathSpecificFirst(pathList);
        } else {
            String tail = CauchoSystem.getClassPath();
            if (tail != null) {
                char sep = CauchoSystem.getPathSeparatorChar();
                String[] values = tail.split("[" + sep + "]");
                for (int i = 0; i < values.length; ++i) {
                    pathList.add(values[i]);
                }
            }
        }
    }

    protected static String toClassPath(ArrayList<String> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(CauchoSystem.getPathSeparatorChar());
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    @Override
    public final boolean isModified() {
        return this.isModified(this._isEnableDependencyCheck);
    }

    public final boolean isModified(boolean enable) {
        if (this._lifecycle.isDestroyed()) {
            return true;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return true;
        }
        if (enable) {
            boolean isModified = dependencies.isModified();
            return isModified;
        }
        boolean isModified = DynamicClassLoader.isModified(this.getParent());
        return isModified;
    }

    public final boolean isModifiedNow() {
        if (this._lifecycle.isDestroyed()) {
            return true;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return true;
        }
        return dependencies.isModifiedNow();
    }

    @Override
    public final boolean logModified(Logger log) {
        if (this._lifecycle.isDestroyed()) {
            return true;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies != null) {
            return dependencies.logModified(log);
        }
        return false;
    }

    public final void resetDependencyCheckInterval() {
        if (this._lifecycle.isDestroyed()) {
            return;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return;
        }
        dependencies.resetDependencyCheckInterval();
    }

    public final void clearModified() {
        if (this._lifecycle.isDestroyed()) {
            return;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return;
        }
        dependencies.clearModified();
    }

    public static boolean isModified(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof DynamicClassLoader) {
                return ((DynamicClassLoader)loader).isModified();
            }
            loader = loader.getParent();
        }
        return false;
    }

    @Override
    public final void make() throws Exception {
        this.makeParents(this.getParent());
        if (this._makeList != null) {
            this._makeList.make();
        }
    }

    private final void makeParents(ClassLoader loader) throws Exception {
        if (loader == null) {
            return;
        }
        this.makeParents(loader.getParent());
        if (loader instanceof Make) {
            ((Make)((Object)loader)).make();
        }
    }

    @Override
    protected Package definePackage(String name, String a1, String a2, String a3, String b1, String b2, String b3, URL url) {
        name = name.replace('/', '.');
        if ((name = name.replace('\\', '.')).endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        return super.definePackage(name, a1, a2, a3, b1, b2, b3, url);
    }

    public void init() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        try {
            this.sendAddLoaderEvent();
            ArrayList<ClassLoaderListener> listeners = this.getListeners();
            if (listeners != null) {
                for (int i = 0; i < listeners.size(); ++i) {
                    ClassLoaderListener listener = listeners.get(i);
                    listener.classLoaderInit(this);
                }
            }
        }
        catch (Exception e) {
            DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
        }
    }

    public void validate() throws ConfigException {
        ArrayList<Loader> loaders = this.getLoaders();
        if (loaders == null) {
            throw new IllegalStateException(_L.l("Class loader {0} is closed during initialization.", (Object)this));
        }
        for (int i = 0; i < loaders.size(); ++i) {
            loaders.get(i).validate();
        }
    }

    public void addScanRoot() {
        this._hasNewLoader = true;
    }

    protected void scan() {
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = null;
        try {
            cl = this.loadClassImpl(name, resolve);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(e.getMessage() + " (in " + this + ")", e);
        }
        catch (NoClassDefFoundError e) {
            DynamicClassLoader.log().finer(e.toString() + " (in " + this + ")");
            throw e;
        }
        if (cl != null) {
            return cl;
        }
        ClassNotFoundException exn = new ClassNotFoundException(name + " (in " + this + ")");
        throw exn;
    }

    public Class<?> loadClassImpl(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl;
        ClassEntry entry;
        if (this._entryCache != null && (entry = this._entryCache.get(name)) != null && (cl = entry.getEntryClass()) != null) {
            return cl;
        }
        Class<?> cl2 = this.findLoadedClass(name);
        if (cl2 != null) {
            if (resolve) {
                this.resolveClass(cl2);
            }
            return cl2;
        }
        if (this._lifecycle.isDestroyed()) {
            DynamicClassLoader.log().fine(DynamicClassLoader.L().l("Loading class {0} when class loader {1} has been closed.", (Object)name, (Object)this));
            return super.loadClass(name, resolve);
        }
        boolean normalJdkOrder = this.isNormalJdkOrder(name);
        if (this._lifecycle.isBeforeInit()) {
            this.init();
        }
        if (normalJdkOrder) {
            ClassLoader parent = this.getParent();
            try {
                cl2 = parent instanceof DynamicClassLoader ? ((DynamicClassLoader)parent).loadClassImpl(name, resolve) : (parent != null ? Class.forName(name, false, parent) : this.findSystemClass(name));
            }
            catch (ClassNotFoundException e) {
            }
            catch (Error e) {
                if (!(parent instanceof DynamicClassLoader)) {
                    DynamicClassLoader.log().warning(e + "\n  while loading " + name + " (in " + this + ")");
                }
                throw e;
            }
            if (cl2 == null) {
                cl2 = this.findImportClass(name);
            }
            if (cl2 == null) {
                cl2 = this.findClassImpl(name);
            }
        } else {
            try {
                cl2 = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                ClassLoader parent = this.getParent();
                cl2 = parent != null ? Class.forName(name, false, parent) : this.findSystemClass(name);
            }
        }
        if (resolve && cl2 != null) {
            this.resolveClass(cl2);
        }
        return cl2;
    }

    protected Class<?> findImportClass(String name) {
        return null;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cl = this.findClassImpl(name);
        if (cl != null) {
            return cl;
        }
        throw new ClassNotFoundException(name);
    }

    public Class<?> findClassImpl(String name) throws ClassNotFoundException {
        ClassEntry oldEntry;
        if (this._isVerbose) {
            this.verbose(name, "findClass");
        }
        if (this._lifecycle.isDestroyed()) {
            DynamicClassLoader.log().fine("Class loader has been closed.");
            return super.findClass(name);
        }
        if (this._lifecycle.isBeforeInit()) {
            this.init();
        }
        if (name.indexOf(47) >= 0) {
            name = name.replace('/', '.');
        }
        if (name.indexOf(92) >= 0) {
            name = name.replace('\\', '.');
        }
        ClassEntry entry = null;
        ClassEntry classEntry = entry = this._entryCache == null ? null : this._entryCache.get(name);
        if (entry == null) {
            int len = this._loaders.size();
            for (int i = 0; i < len; ++i) {
                Class<?> cl = this._loaders.get(i).loadClass(name);
                if (cl == null) continue;
                return cl;
            }
            entry = this.getClassEntry(name);
        }
        if (entry == null) {
            return null;
        }
        if (entry != null && this._isVerbose) {
            this.verbose(name, this.isNormalJdkOrder(name) ? "found" : "found (took priority from parent)");
        }
        if (this._isEnableDependencyCheck) {
            entry.addDependencies(this._dependencies);
        }
        if ((oldEntry = this._entryCache.putIfAbsent(name, entry)) != null) {
            entry = oldEntry;
        }
        try {
            return this.loadClassEntry(entry);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            DynamicClassLoader.log().log(Level.FINE, e.toString(), e);
            throw new ClassNotFoundException(name + " [" + e + "]", e);
        }
    }

    protected ClassEntry getClassEntry(String name) throws ClassNotFoundException {
        String pathName = name.replace('.', '/') + ".class";
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            ClassEntry entry = loader.getClassEntry(name, pathName);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClassEntry(ClassEntry entry) throws IOException, ClassNotFoundException {
        int bLen;
        byte[] bBuf;
        Class<?> cl = null;
        ClassEntry classEntry = entry;
        synchronized (classEntry) {
            cl = entry.getEntryClass();
            if (cl != null) {
                return cl;
            }
            entry.preLoad();
            String name = entry.getName();
            int p = name.lastIndexOf(46);
            if (p > 0) {
                String packageName = name.substring(0, p);
                Package pkg = this.getPackage(packageName);
                ClassPackage classPackage = entry.getClassPackage();
                if (pkg == null) {
                    if (classPackage != null) {
                        this.definePackage(packageName, classPackage.getSpecificationTitle(), classPackage.getSpecificationVersion(), classPackage.getSpecificationVendor(), classPackage.getImplementationTitle(), classPackage.getImplementationVersion(), classPackage.getImplementationVendor(), null);
                    } else {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                }
            }
            ByteBuffer buffer = new ByteBuffer();
            entry.load(buffer);
            bBuf = buffer.getBuffer();
            bLen = buffer.length();
            if (this._classFileTransformerList != null) {
                Class<?> redefineClass = null;
                String className = name.replace('.', '/');
                if (bBuf.length != bLen) {
                    byte[] tempBuf = new byte[bLen];
                    System.arraycopy(bBuf, 0, tempBuf, 0, bLen);
                    bBuf = tempBuf;
                }
                ProtectionDomain protectionDomain = null;
                for (int i = 0; i < this._classFileTransformerList.size(); ++i) {
                    ClassFileTransformer transformer = this._classFileTransformerList.get(i);
                    try {
                        byte[] enhancedBuffer = transformer.transform(this, className, redefineClass, protectionDomain, bBuf);
                        if (enhancedBuffer == null) continue;
                        bBuf = enhancedBuffer;
                        bLen = enhancedBuffer.length;
                        if (!this._isVerbose) continue;
                        this.verbose(name, String.valueOf(transformer));
                        continue;
                    }
                    catch (EnhancerRuntimeException e) {
                        e.printStackTrace();
                        throw e;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
                    }
                }
            }
        }
        try {
            cl = this.findLoadedClass(entry.getName());
            if (cl != null) {
                if (entry.getEntryClass() == null) {
                    entry.setEntryClass(cl);
                }
                return cl;
            }
            cl = this.defineClass(entry.getName(), bBuf, 0, bLen, entry.getCodeSource());
            entry.setEntryClass(cl);
        }
        catch (RuntimeException e) {
            DynamicClassLoader.log().log(Level.FINE, entry.getName() + " [" + e.toString() + "]", e);
            throw e;
        }
        catch (Exception e) {
            DynamicClassLoader.log().log(Level.FINE, entry.getName() + " [" + e.toString() + "]", e);
            ClassNotFoundException exn = new ClassNotFoundException(entry.getName() + " [" + e + "]", e);
            throw exn;
        }
        catch (LinkageError e) {
            cl = this.findLoadedClass(entry.getName());
            if (cl != null) {
                DynamicClassLoader.log().log(Level.FINE, e.toString(), e);
                return cl;
            }
            throw e;
        }
        if (entry.postLoad()) {
            this._dependencies.add(AlwaysModified.create());
            this._dependencies.setModified(true);
        }
        return cl;
    }

    public Class<?> loadClass(String className, byte[] bytecode) {
        Class<?> cl = this.defineClass(className, bytecode, 0, bytecode.length);
        return cl;
    }

    @Override
    public URL getResource(String name) {
        boolean isNormalJdkOrder;
        URL url;
        if (this._resourceCache == null) {
            long expireInterval = this.getDependencyCheckInterval();
            this._resourceCache = new TimedCache(256, expireInterval);
        }
        if ((url = this._resourceCache.get(name)) == NULL_URL) {
            return null;
        }
        if (url != null) {
            return url;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((isNormalJdkOrder = this.isNormalJdkOrder(name)) && (url = this.getParentResource(name)) != null) {
            return url;
        }
        url = this.getImportResource(name);
        if (url != null) {
            return url;
        }
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; loaders != null && i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            url = loader.getResource(name);
            if (url == null) continue;
            this._resourceCache.put(name, url);
            return url;
        }
        if (!isNormalJdkOrder && (url = this.getParentResource(name)) != null) {
            return url;
        }
        this._resourceCache.put(name, NULL_URL);
        return null;
    }

    protected String getResourceAlias(String name) {
        return null;
    }

    protected URL getImportResource(String name) {
        return null;
    }

    private URL getParentResource(String name) {
        URL url;
        ClassLoader parent = this.getParent();
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        if (parent != null) {
            URL url2 = parent.getResource(name);
            if (url2 != null) {
                this._resourceCache.put(name, url2);
                return url2;
            }
        } else if (this != systemLoader && (url = DynamicClassLoader.getSystemResource(name)) != null) {
            this._resourceCache.put(name, url);
            return url;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        boolean isNormalJdkOrder = this.isNormalJdkOrder(name);
        InputStream is = null;
        if (isNormalJdkOrder && (is = this.getParentResourceAsStream(name)) != null) {
            return is;
        }
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; loaders != null && i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            is = loader.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        if (!isNormalJdkOrder) {
            is = this.getParentResourceAsStream(name);
        }
        return is;
    }

    private InputStream getParentResourceAsStream(String name) {
        InputStream is;
        ClassLoader parent = this.getParent();
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        if (parent != null) {
            InputStream is2 = parent.getResourceAsStream(name);
            if (is2 != null) {
                return is2;
            }
        } else if (this != systemLoader && (is = DynamicClassLoader.getSystemResourceAsStream(name)) != null) {
            return is;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        String alias;
        Vector<URL> resources = new Vector<URL>();
        this.getResources(resources, name);
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((alias = this.getResourceAlias(name)) != null) {
            this.getResources(resources, alias);
        }
        return resources.elements();
    }

    private void getResources(Vector<URL> resources, String name) throws IOException {
        ClassLoader parent = this.getParent();
        if (parent != null) {
            if (parent instanceof DynamicClassLoader) {
                DynamicClassLoader dynParent = (DynamicClassLoader)parent;
                dynParent.getResources(resources, name);
            } else {
                Enumeration<URL> parentResources = parent.getResources(name);
                while (parentResources.hasMoreElements()) {
                    URL url = parentResources.nextElement();
                    resources.add(url);
                }
            }
        }
        this.fillResources(resources, name);
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        Vector<URL> resources = new Vector<URL>();
        this.fillResources(resources, name);
        String alias = this.getResourceAlias(name);
        if (alias != null) {
            this.fillResources(resources, alias);
        }
        return resources.elements();
    }

    private void fillResources(Vector<URL> resources, String name) {
        ArrayList<Loader> loaders;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((loaders = this.getLoaders()) != null) {
            for (int i = 0; i < loaders.size(); ++i) {
                Loader loader = loaders.get(i);
                loader.getResources(resources, name);
            }
        }
    }

    @Override
    public String findLibrary(String name) {
        int i;
        String systemName = System.mapLibraryName(name);
        ArrayList<Loader> loaders = this.getLoaders();
        for (i = 0; i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            Path path = loader.getPath(systemName);
            if (path == null || !path.canRead()) continue;
            return path.getNativePath();
        }
        for (i = 0; i < this._nativePath.size(); ++i) {
            Path path = this._nativePath.get(i);
            if (!path.canRead()) continue;
            return path.getNativePath();
        }
        return super.findLibrary(name);
    }

    public Path findPath(String name) {
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            Path path = loader.getPath(name);
            if (path == null || !path.canRead()) continue;
            return path;
        }
        return null;
    }

    private boolean isNormalJdkOrder(String className) {
        String canonName;
        if (this._priorityPackages != null) {
            canonName = className.replace('/', '.');
            canonName = canonName.replace('\\', '.');
            for (String priorityPackage : this._priorityPackages) {
                if (!canonName.startsWith(priorityPackage)) continue;
                return false;
            }
        }
        if (!this._useServletHack) {
            return true;
        }
        canonName = className.replace('/', '.');
        canonName = canonName.replace('\\', '.');
        String[] pkgs = this._parentPriorityPackages;
        for (int i = 0; pkgs != null && i < pkgs.length; ++i) {
            if (!canonName.startsWith(pkgs[i])) continue;
            return true;
        }
        return false;
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this._zombieMarker == null) {
            this._zombieMarker = new ZombieClassLoaderMarker();
        }
        try {
            this.stop();
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (!this._lifecycle.toDestroying()) {
            return;
        }
        try {
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof DynamicClassLoader)) continue;
                DynamicClassLoader loader = (DynamicClassLoader)parent;
                if (this._closeListener == null) continue;
                loader.removeListener(this._closeListener);
            }
            ArrayList<ClassLoaderListener> listeners = this._listeners;
            this._listeners = null;
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                if (listeners != null) {
                    Collections.sort(listeners, LISTENER_SORT);
                    for (int i = listeners.size() - 1; i >= 0; --i) {
                        ClassLoaderListener listener = listeners.get(i);
                        try {
                            thread.setContextClassLoader(this);
                            listener.classLoaderDestroy(this);
                            continue;
                        }
                        catch (Throwable e) {
                            DynamicClassLoader.log().log(Level.FINE, e.toString(), e);
                        }
                    }
                }
                Object var9_12 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            ArrayList<Loader> loaders = this.getLoaders();
            for (int i = loaders.size() - 1; i >= 0; --i) {
                Loader loader = loaders.get(i);
                try {
                    loader.destroy();
                    continue;
                }
                catch (Throwable e) {
                    DynamicClassLoader.log().log(Level.FINE, e.toString(), e);
                }
            }
            Object var11_16 = null;
            this._loaders = null;
            this._jarLoader = null;
            this._pathLoader = null;
            this._nativePath = null;
            this._entryCache = null;
            this._resourceCache = null;
            this._dependencies = null;
            this._makeList = null;
            this._listeners = null;
            this._permissions = null;
            this._codeSource = null;
            this._classFileTransformerList = null;
            this._urls = null;
            this._closeListener = null;
            this._lifecycle.toDestroy();
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            this._loaders = null;
            this._jarLoader = null;
            this._pathLoader = null;
            this._nativePath = null;
            this._entryCache = null;
            this._resourceCache = null;
            this._dependencies = null;
            this._makeList = null;
            this._listeners = null;
            this._permissions = null;
            this._codeSource = null;
            this._classFileTransformerList = null;
            this._urls = null;
            this._closeListener = null;
            this._lifecycle.toDestroy();
            throw throwable;
        }
    }

    public static void setOldLoader(Thread thread, ClassLoader oldLoader) {
        if (!(oldLoader instanceof DynamicClassLoader)) {
            thread.setContextClassLoader(oldLoader);
            return;
        }
        DynamicClassLoader dynLoader = (DynamicClassLoader)oldLoader;
        if (!dynLoader.isDestroyed()) {
            thread.setContextClassLoader(oldLoader);
        } else {
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this;
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.getNewTempClassLoader();
    }

    public ClassLoader getNewTempClassLoader() {
        return new TempDynamicClassLoader(this);
    }

    protected void replace(DynamicClassLoader source) {
        this._id = source._id;
        this._loaders.addAll(source._loaders);
        this._jarLoader = source._jarLoader;
        this._dependencies = source._dependencies;
        this._makeList = source._makeList;
        this._useServletHack = source._useServletHack;
        this._parentPriorityPackages = source._parentPriorityPackages;
        if (source._listeners != null) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            this._listeners.addAll(source._listeners);
            source._listeners.clear();
        }
        if (source._permissions != null) {
            if (this._permissions == null) {
                this._permissions = new ArrayList();
            }
            this._permissions.addAll(source._permissions);
        }
        this._codeSource = source._codeSource;
        this._lifecycle.copyState(source._lifecycle);
    }

    public String toString() {
        if (this._id != null) {
            return this.getClass().getSimpleName() + "[" + this._id + "]";
        }
        return this.getClass().getSimpleName() + this.getLoaders();
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(DynamicClassLoader.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(DynamicClassLoader.class.getName());
        }
        return _log;
    }

    static {
        NULL_URL_ARRAY = new URL[0];
        _globalDependencyCheckInterval = 2000L;
        _isJarCacheEnabled = true;
        LISTENER_SORT = new ListenerComparator();
        URL url = null;
        try {
            url = new URL("file:/caucho/null");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NULL_URL = url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListenerComparator
    implements Comparator<Object> {
        ListenerComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            return a.getClass().getName().compareTo(b.getClass().getName());
        }
    }
}

