/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.JarEntry;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ZipScanner;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarMap {
    private static final Logger log = Logger.getLogger(JarMap.class.getName());
    private static final AtomicReference<JarList> _key = new AtomicReference();
    private JarList[] _entries = new JarList[1024];
    private int _mask = this._entries.length - 1;
    private int _size;

    public JarList add(String name, JarEntry entry) {
        int length = name.length();
        char[] cbuf = new char[length];
        name.getChars(0, length, cbuf, 0);
        return this.add(cbuf, length, entry);
    }

    public JarList get(String name) {
        JarList key = _key.getAndSet(null);
        if (key == null) {
            key = new JarList();
        }
        key.init(name);
        int hash = key.hashCode() & this._mask;
        JarList ptr = this._entries[hash];
        while (ptr != null) {
            if (ptr.equals(key)) {
                _key.set(key);
                return ptr;
            }
            ptr = ptr._nextHash;
        }
        _key.set(key);
        return null;
    }

    public Iterator<String> keys() {
        return new JarKeyIterator();
    }

    private void resize() {
    }

    public void scan(Path jar) {
        JarEntry jarEntry = new JarEntry(JarPath.create(jar));
        this.scan(jar, jarEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Path jar, JarEntry jarEntry) {
        ZipScanner scan = null;
        try {
            try {
                boolean isScan = true;
                boolean isValidScan = false;
                try {
                    if (isScan && jar.canRead()) {
                        scan = new ZipScanner(jar);
                    }
                    if (scan != null && scan.open()) {
                        this.scanZip(scan, jarEntry);
                        isValidScan = true;
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                    isScan = false;
                }
                if (!isValidScan && jar.canRead()) {
                    ZipFile file = new ZipFile(jar.getNativePath());
                    try {
                        Enumeration<? extends ZipEntry> e = file.entries();
                        while (e.hasMoreElements()) {
                            ZipEntry entry = e.nextElement();
                            String name = entry.getName();
                            this.add(name, jarEntry);
                        }
                        Object var11_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        file.close();
                        throw throwable;
                    }
                    file.close();
                    {
                    }
                }
                Object var13_15 = null;
                if (scan != null) {
                    scan.close();
                }
            }
            catch (IOException e) {
                if (jar.canRead()) {
                    log.log(Level.WARNING, e.toString(), e);
                } else {
                    log.log(Level.FINER, e.toString(), e);
                }
                Object var13_16 = null;
                if (scan != null) {
                    scan.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (scan != null) {
                scan.close();
            }
            throw throwable;
        }
    }

    private void scanZip(ZipScanner scan, JarEntry jarEntry) throws IOException {
        while (scan.next()) {
            char[] buffer = scan.getNameBuffer();
            int length = scan.getNameLength();
            if (length > 0 && buffer[length - 1] == '/') {
                --length;
            }
            this.add(buffer, length, jarEntry);
        }
    }

    public JarList add(char[] name, int length, JarEntry entry) {
        if (this._entries.length <= this._size) {
            this.resize();
        }
        JarList key = new JarList();
        key.init(name, length);
        key._entry = entry;
        int hash = key.hashCode() & this._mask;
        JarList ptr = this._entries[hash];
        while (ptr != null) {
            if (ptr.equals(key)) {
                key.clearName();
                key._next = ptr._next;
                ptr._next = key;
                return ptr;
            }
            ptr = ptr._nextHash;
        }
        ++this._size;
        key.copyName();
        key._nextHash = this._entries[hash];
        this._entries[hash] = key;
        return key;
    }

    public void clear() {
        this._size = 0;
        for (int i = 0; i < this._entries.length; ++i) {
            this._entries[i] = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JarKeyIterator
    implements Iterator<String> {
        private int _index;
        private JarList _entry;

        JarKeyIterator() {
            while (this._index < JarMap.this._entries.length) {
                this._entry = JarMap.this._entries[this._index];
                if (this._entry != null) break;
                ++this._index;
            }
        }

        @Override
        public boolean hasNext() {
            return this._entry != null;
        }

        @Override
        public String next() {
            JarList next = this._entry;
            if (this._entry != null) {
                this._entry = this._entry._nextHash;
            }
            if (this._entry == null) {
                ++this._index;
                while (this._index < JarMap.this._entries.length) {
                    this._entry = JarMap.this._entries[this._index];
                    if (this._entry != null) break;
                    ++this._index;
                }
            }
            if (next != null) {
                return next.getNameString();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    static final class JarList {
        private JarList _nextHash;
        private JarList _next;
        private JarEntry _entry;
        private char[] _name;
        private int _length;

        JarList() {
        }

        JarList(JarEntry entry, JarList next) {
            this._entry = entry;
            this._next = next;
        }

        void init(char[] name, int length) {
            this._name = name;
            this._length = length;
        }

        void init(String name) {
            int length = name.length();
            if (this._name == null || this._name.length <= length) {
                this._name = new char[length];
            }
            name.getChars(0, length, this._name, 0);
            this._length = length;
        }

        int getLength() {
            return this._length;
        }

        void clearName() {
            this._name = null;
            this._length = 0;
        }

        void copyName() {
            char[] newName = new char[this._length];
            System.arraycopy(this._name, 0, newName, 0, this._length);
            this._name = newName;
        }

        String getNameString() {
            return new String(this._name, 0, this._length);
        }

        JarEntry getEntry() {
            return this._entry;
        }

        JarList getNext() {
            return this._next;
        }

        public int hashCode() {
            char[] name = this._name;
            int hash = 37;
            for (int i = this._length - 1; i >= 0; --i) {
                hash = 65521 * hash + name[i];
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JarList)) {
                return false;
            }
            JarList entry = (JarList)o;
            return this.equals(entry);
        }

        public boolean equals(JarList entry) {
            if (this == entry) {
                return true;
            }
            int length = this._length;
            if (length != entry._length) {
                return false;
            }
            char[] nameA = this._name;
            char[] nameB = entry._name;
            for (int i = length - 1; i >= 0; --i) {
                if (nameA[i] == nameB[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + new String(this._name, 0, this._length) + "]";
        }
    }
}

